/*
 * Decompiled with CFR 0.152.
 */
package sootup.core.jimple.common.ref;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import sootup.core.jimple.basic.JimpleComparator;
import sootup.core.jimple.basic.Local;
import sootup.core.jimple.basic.Value;
import sootup.core.jimple.common.ref.JFieldRef;
import sootup.core.jimple.visitor.RefVisitor;
import sootup.core.signatures.FieldSignature;
import sootup.core.util.Copyable;
import sootup.core.util.printer.StmtPrinter;

public final class JInstanceFieldRef
extends JFieldRef
implements Copyable {
    private final Local base;

    public JInstanceFieldRef(@Nonnull Local base, @Nonnull FieldSignature fieldSig) {
        super(fieldSig);
        this.base = base;
    }

    public String toString() {
        return this.base.toString() + "." + this.getFieldSignature().toString();
    }

    @Override
    public void toString(@Nonnull StmtPrinter up) {
        this.base.toString(up);
        up.literal(".");
        up.fieldSignature(this.getFieldSignature());
    }

    public Local getBase() {
        return this.base;
    }

    @Override
    @Nonnull
    public final List<Value> getUses() {
        ArrayList<Value> list = new ArrayList<Value>(this.base.getUses());
        list.add(this.base);
        return list;
    }

    @Override
    public void accept(@Nonnull RefVisitor v) {
        v.caseInstanceFieldRef(this);
    }

    @Override
    public boolean equivTo(Object o, @Nonnull JimpleComparator comparator) {
        return comparator.caseInstanceFieldRef(this, o);
    }

    @Override
    public int equivHashCode() {
        return this.getFieldSignature().hashCode() * 101 + this.base.hashCode() + 17;
    }

    @Nonnull
    public JInstanceFieldRef withBase(@Nonnull Local base) {
        return new JInstanceFieldRef(base, this.getFieldSignature());
    }

    @Nonnull
    public JInstanceFieldRef withFieldSignature(@Nonnull FieldSignature fieldSignature) {
        return new JInstanceFieldRef(this.getBase(), fieldSignature);
    }
}

