/*
 * Decompiled with CFR 0.152.
 */
package sootup.core.jimple.common.stmt;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import sootup.core.jimple.basic.EquivTo;
import sootup.core.jimple.basic.StmtPositionInfo;
import sootup.core.jimple.basic.Value;
import sootup.core.jimple.common.expr.AbstractInvokeExpr;
import sootup.core.jimple.common.ref.JArrayRef;
import sootup.core.jimple.common.ref.JFieldRef;
import sootup.core.jimple.visitor.Acceptor;
import sootup.core.jimple.visitor.StmtVisitor;
import sootup.core.util.Copyable;
import sootup.core.util.printer.StmtPrinter;

public abstract class Stmt
implements EquivTo,
Acceptor<StmtVisitor>,
Copyable {
    protected final StmtPositionInfo positionInfo;

    public Stmt(@Nonnull StmtPositionInfo positionInfo) {
        this.positionInfo = positionInfo;
    }

    @Nonnull
    public List<Value> getUses() {
        return Collections.emptyList();
    }

    @Nonnull
    public List<Value> getDefs() {
        return Collections.emptyList();
    }

    @Nonnull
    public List<Value> getUsesAndDefs() {
        List<Value> uses = this.getUses();
        List<Value> defs = this.getDefs();
        if (uses.isEmpty()) {
            return defs;
        }
        if (defs.isEmpty()) {
            return uses;
        }
        ArrayList<Value> values = new ArrayList<Value>();
        values.addAll(defs);
        values.addAll(uses);
        return values;
    }

    public abstract boolean fallsThrough();

    public abstract boolean branches();

    public int getExpectedSuccessorCount() {
        return 1;
    }

    public abstract void toString(@Nonnull StmtPrinter var1);

    public boolean containsInvokeExpr() {
        return false;
    }

    public AbstractInvokeExpr getInvokeExpr() {
        throw new RuntimeException("getInvokeExpr() called with no invokeExpr present!");
    }

    public boolean containsArrayRef() {
        return false;
    }

    public JArrayRef getArrayRef() {
        throw new RuntimeException("getArrayRef() called with no ArrayRef present!");
    }

    public boolean containsFieldRef() {
        return false;
    }

    public JFieldRef getFieldRef() {
        throw new RuntimeException("getFieldRef() called with no JFieldRef present!");
    }

    public StmtPositionInfo getPositionInfo() {
        return this.positionInfo;
    }
}

