/*
 * Decompiled with CFR 0.152.
 */
package sootup.core.model;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import sootup.core.graph.StmtGraph;
import sootup.core.jimple.basic.Local;
import sootup.core.jimple.basic.Value;
import sootup.core.jimple.common.stmt.AbstractDefinitionStmt;
import sootup.core.jimple.common.stmt.JAssignStmt;
import sootup.core.jimple.common.stmt.JIdentityStmt;
import sootup.core.jimple.common.stmt.Stmt;
import sootup.core.jimple.visitor.ReplaceUseStmtVisitor;

public class BodyUtils {
    public static Map<Local, List<Stmt>> collectDefs(List<Stmt> stmts) {
        HashMap<Local, List<Stmt>> allDefs = new HashMap<Local, List<Stmt>>();
        for (Stmt stmt : stmts) {
            List<Value> defs = stmt.getDefs();
            for (Value value : defs) {
                if (!(value instanceof Local)) continue;
                ArrayList<Stmt> localDefs = (ArrayList<Stmt>)allDefs.get(value);
                if (localDefs == null) {
                    localDefs = new ArrayList<Stmt>();
                }
                localDefs.add(stmt);
                allDefs.put((Local)value, localDefs);
            }
        }
        return allDefs;
    }

    public static Map<Local, List<Stmt>> collectUses(List<Stmt> stmts) {
        HashMap<Local, List<Stmt>> allUses = new HashMap<Local, List<Stmt>>();
        for (Stmt stmt : stmts) {
            List<Value> uses = stmt.getUses();
            for (Value value : uses) {
                if (!(value instanceof Local)) continue;
                ArrayList<Stmt> localUses = (ArrayList<Stmt>)allUses.get(value);
                if (localUses == null) {
                    localUses = new ArrayList<Stmt>();
                }
                localUses.add(stmt);
                allUses.put((Local)value, localUses);
            }
        }
        return allUses;
    }

    public static List<AbstractDefinitionStmt> getDefsOfLocal(Local local, List<Stmt> defs) {
        ArrayList<AbstractDefinitionStmt> localDefs = new ArrayList<AbstractDefinitionStmt>();
        for (Stmt stmt : defs) {
            if (!(stmt instanceof AbstractDefinitionStmt) || !((AbstractDefinitionStmt)stmt).getLeftOp().equals(local)) continue;
            localDefs.add((AbstractDefinitionStmt)stmt);
        }
        return localDefs;
    }

    public static List<Stmt> getDefsForLocalUse(StmtGraph<?> graph, Local use, Stmt stmt) {
        if (!stmt.getUses().contains(use)) {
            throw new RuntimeException(stmt + " doesn't use the local " + use.toString());
        }
        ArrayList<Stmt> defStmts = new ArrayList<Stmt>();
        HashSet<Stmt> visited = new HashSet<Stmt>();
        ArrayDeque<Stmt> queue = new ArrayDeque<Stmt>();
        queue.add(stmt);
        while (!queue.isEmpty()) {
            Stmt s2 = (Stmt)queue.removeFirst();
            if (visited.contains(s2)) continue;
            visited.add(s2);
            if (s2 instanceof AbstractDefinitionStmt && s2.getDefs().get(0).equivTo(use)) {
                defStmts.add(s2);
                continue;
            }
            for (Stmt pred : graph.predecessors(s2)) {
                queue.add(pred);
            }
        }
        return defStmts;
    }

    @Nonnull
    public static Stmt withNewUse(@Nonnull Stmt oldStmt, @Nonnull Value oldUse, @Nonnull Value newUse) {
        ReplaceUseStmtVisitor visitor = new ReplaceUseStmtVisitor(oldUse, newUse);
        oldStmt.accept(visitor);
        return (Stmt)visitor.getResult();
    }

    @Nonnull
    public static Stmt withNewDef(@Nonnull Stmt oldStmt, @Nonnull Local newDef) {
        if (oldStmt instanceof JAssignStmt) {
            return ((JAssignStmt)oldStmt).withVariable(newDef);
        }
        if (oldStmt instanceof JIdentityStmt) {
            return ((JIdentityStmt)oldStmt).withLocal(newDef);
        }
        throw new RuntimeException("The given stmt must be JAssignStmt or JIdentityStmt!");
    }
}

