/*
 * Decompiled with CFR 0.152.
 */
package sootup.core.model;

import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import sootup.core.frontend.BodySource;
import sootup.core.frontend.OverridingBodySource;
import sootup.core.frontend.ResolveException;
import sootup.core.jimple.basic.NoPositionInformation;
import sootup.core.model.Body;
import sootup.core.model.Method;
import sootup.core.model.Modifier;
import sootup.core.model.Position;
import sootup.core.model.SootClassMember;
import sootup.core.signatures.MethodSignature;
import sootup.core.signatures.MethodSubSignature;
import sootup.core.types.ClassType;
import sootup.core.types.Type;
import sootup.core.util.Copyable;
import sootup.core.util.ImmutableUtils;
import sootup.core.util.printer.StmtPrinter;

public class SootMethod
extends SootClassMember<MethodSignature>
implements Method,
Copyable {
    @Nonnull
    protected final ImmutableList<Type> parameterTypes;
    @Nonnull
    protected final ImmutableList<ClassType> exceptions;
    @Nonnull
    protected final BodySource bodySource;
    @Nonnull
    private final Supplier<Body> _lazyBody = Suppliers.memoize(this::lazyBodyInitializer);

    public SootMethod(@Nonnull BodySource source, @Nonnull MethodSignature methodSignature, @Nonnull Iterable<Modifier> modifiers, @Nonnull Iterable<ClassType> thrownExceptions, @Nonnull Position position) {
        super(methodSignature, modifiers, position);
        this.bodySource = source;
        this.parameterTypes = ImmutableUtils.immutableListOf(methodSignature.getParameterTypes());
        this.exceptions = ImmutableUtils.immutableListOf(thrownExceptions);
    }

    @Nonnull
    private Body lazyBodyInitializer() {
        if (!this.isConcrete()) {
            throw new ResolveException("There is no corresponding body if the method is not concrete i.e." + this.getSignature() + " is abstract or native.", Paths.get("", new String[0]));
        }
        try {
            return this.bodySource.resolveBody(this.getModifiers());
        }
        catch (IOException | ResolveException e) {
            throw new ResolveException("Could not resolve a corresponding body for " + this.getSignature(), Paths.get("", new String[0]), e);
        }
    }

    public boolean isConcrete() {
        return !this.isAbstract() && !this.isNative();
    }

    @Nonnull
    public Type getReturnType() {
        return ((MethodSignature)this.getSignature()).getType();
    }

    public int getParameterCount() {
        return this.parameterTypes.size();
    }

    @Nonnull
    public Type getParameterType(int n) {
        return (Type)this.parameterTypes.get(n);
    }

    @Nonnull
    public List<Type> getParameterTypes() {
        return this.parameterTypes;
    }

    @Nonnull
    public Body getBody() {
        return this._lazyBody.get();
    }

    public boolean hasBody() {
        return this.isConcrete();
    }

    @Nonnull
    public BodySource getBodySource() {
        return this.bodySource;
    }

    @Nonnull
    public List<ClassType> getExceptionSignatures() {
        return this.exceptions;
    }

    public boolean isAbstract() {
        return Modifier.isAbstract(this.getModifiers());
    }

    public boolean isNative() {
        return Modifier.isNative(this.getModifiers());
    }

    public boolean isSynchronized() {
        return Modifier.isSynchronized(this.getModifiers());
    }

    public boolean isMain() {
        return this.isPublic() && this.isStatic() && ((MethodSubSignature)((MethodSignature)this.getSignature()).getSubSignature()).toString().equals("void main(java.lang.String[])");
    }

    public boolean isBuiltInMethod() {
        return ((MethodSignature)this.getSignature()).getDeclClassType().isBuiltInClass();
    }

    public void toString(@Nonnull StmtPrinter printer) {
        Set<Modifier> modifiers = this.getModifiers();
        printer.modifier(Modifier.toString(modifiers));
        if (modifiers.size() != 0) {
            printer.literal(" ");
        }
        MethodSubSignature subSignature = (MethodSubSignature)((MethodSignature)this.getSignature()).getSubSignature();
        subSignature.toString(printer);
        Iterator<ClassType> exceptionIt = this.getExceptionSignatures().iterator();
        if (exceptionIt.hasNext()) {
            printer.literal(" throws ");
            printer.typeSignature(exceptionIt.next());
            while (exceptionIt.hasNext()) {
                printer.literal(", ");
                printer.typeSignature(exceptionIt.next());
            }
        }
    }

    @Nonnull
    public SootMethod withOverridingMethodSource(Function<OverridingBodySource, OverridingBodySource> overrider) {
        return new SootMethod(overrider.apply(new OverridingBodySource(this.bodySource)), (MethodSignature)this.getSignature(), this.getModifiers(), this.exceptions, this.getPosition());
    }

    @Nonnull
    public SootMethod withSource(BodySource source) {
        return new SootMethod(source, (MethodSignature)this.getSignature(), this.getModifiers(), this.exceptions, this.getPosition());
    }

    @Nonnull
    public SootMethod withModifiers(Iterable<Modifier> modifiers) {
        return new SootMethod(this.bodySource, (MethodSignature)this.getSignature(), modifiers, this.getExceptionSignatures(), this.getPosition());
    }

    @Nonnull
    public SootMethod withThrownExceptions(Iterable<ClassType> thrownExceptions) {
        return new SootMethod(this.bodySource, (MethodSignature)this.getSignature(), this.getModifiers(), thrownExceptions, this.getPosition());
    }

    @Nonnull
    public SootMethod withBody(@Nonnull Body body) {
        return new SootMethod(new OverridingBodySource(this.bodySource).withBody(body), (MethodSignature)this.getSignature(), this.getModifiers(), this.exceptions, this.getPosition());
    }

    @Nonnull
    public static MethodSourceStep builder() {
        return new SootMethodBuilder();
    }

    public int hashCode() {
        return Objects.hash(this.getBodySource(), this.getBodySource().getSignature(), this.getModifiers(), this.getParameterTypes());
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SootMethod)) {
            return false;
        }
        return this.getBodySource() == ((SootMethod)obj).getBodySource() && this.getBodySource().getSignature() == ((SootMethod)obj).getBodySource().getSignature() && this.getModifiers() == ((SootMethod)obj).getModifiers() && this.getParameterTypes() == ((SootMethod)obj).getParameterTypes();
    }

    public static class SootMethodBuilder
    implements MethodSourceStep,
    SignatureStep,
    ModifierStep,
    ThrownExceptionsStep,
    BuildStep {
        @Nullable
        private BodySource source;
        @Nonnull
        private Iterable<Modifier> modifiers = Collections.emptyList();
        @Nullable
        private MethodSignature methodSignature;
        @Nonnull
        private Iterable<ClassType> thrownExceptions = Collections.emptyList();
        @Nonnull
        private Position position = NoPositionInformation.getInstance();

        @Nonnull
        public Iterable<Modifier> getModifiers() {
            return this.modifiers;
        }

        @Nullable
        public BodySource getSource() {
            return this.source;
        }

        @Nullable
        public MethodSignature getSignature() {
            return this.methodSignature;
        }

        @Nonnull
        public Position getPosition() {
            return this.position;
        }

        @Nonnull
        public Iterable<ClassType> getThrownExceptions() {
            return this.thrownExceptions;
        }

        @Override
        @Nonnull
        public SignatureStep withSource(@Nonnull BodySource source) {
            this.source = source;
            return this;
        }

        @Override
        @Nonnull
        public ModifierStep withSignature(@Nonnull MethodSignature methodSignature) {
            this.methodSignature = methodSignature;
            return this;
        }

        @Override
        @Nonnull
        public ThrownExceptionsStep withModifier(@Nonnull Iterable<Modifier> modifiers) {
            this.modifiers = modifiers;
            return this;
        }

        @Override
        @Nonnull
        public BuildStep withThrownExceptions(@Nonnull Iterable<ClassType> thrownExceptions) {
            this.thrownExceptions = thrownExceptions;
            return this;
        }

        @Override
        @Nonnull
        public BuildStep withPosition(@Nonnull Position position) {
            this.position = position;
            return this;
        }

        @Override
        @Nonnull
        public SootMethod build() {
            return new SootMethod(this.getSource(), this.getSignature(), this.getModifiers(), this.getThrownExceptions(), this.position);
        }
    }

    public static interface BuildStep {
        @Nonnull
        public SootMethod build();

        @Nonnull
        public BuildStep withPosition(Position var1);
    }

    public static interface ThrownExceptionsStep {
        @Nonnull
        public BuildStep withThrownExceptions(@Nonnull Iterable<ClassType> var1);

        @Nonnull
        public SootMethod build();
    }

    public static interface ModifierStep {
        @Nonnull
        public ThrownExceptionsStep withModifier(@Nonnull Iterable<Modifier> var1);

        @Nonnull
        default public ThrownExceptionsStep withModifiers(@Nonnull Modifier first, Modifier ... rest) {
            return this.withModifier(EnumSet.of(first, rest));
        }
    }

    public static interface SignatureStep {
        @Nonnull
        public ModifierStep withSignature(@Nonnull MethodSignature var1);
    }

    public static interface MethodSourceStep {
        @Nonnull
        public SignatureStep withSource(@Nonnull BodySource var1);
    }
}

