/*
 * Decompiled with CFR 0.152.
 */
package sootup.core.types;

import com.google.common.base.Objects;
import javax.annotation.Nonnull;
import sootup.core.jimple.visitor.TypeVisitor;
import sootup.core.types.ReferenceType;
import sootup.core.types.Type;
import sootup.core.util.printer.StmtPrinter;

public class ArrayType
extends ReferenceType {
    private final Type baseType;
    private final int dimension;

    public ArrayType(Type baseType, int dimension) {
        this.baseType = baseType;
        this.dimension = dimension;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.baseType);
        for (int i = 0; i < this.dimension; ++i) {
            sb.append("[]");
        }
        return sb.toString();
    }

    public void toString(StmtPrinter printer) {
        printer.typeSignature(this.baseType);
        for (int i = 0; i < this.dimension; ++i) {
            printer.literal("[]");
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ArrayType that = (ArrayType)o;
        return this.dimension == that.dimension && Objects.equal(this.baseType, that.baseType);
    }

    public int hashCode() {
        return Objects.hashCode(this.baseType, this.dimension);
    }

    public Type getBaseType() {
        return this.baseType;
    }

    public int getDimension() {
        return this.dimension;
    }

    @Override
    public void accept(@Nonnull TypeVisitor v) {
        v.caseArrayType();
    }
}

