/*
 * Decompiled with CFR 0.152.
 */
package sootup.core.util;

import java.io.FilterWriter;
import java.io.IOException;
import java.io.Writer;

public class EscapedWriter
extends FilterWriter {
    private final String lineSeparator = System.getProperty("line.separator");
    private final int cr = this.lineSeparator.charAt(0);
    private final int lf = this.lineSeparator.length() == 2 ? (int)this.lineSeparator.charAt(1) : -1;
    private final StringBuilder mini = new StringBuilder(8);

    public EscapedWriter(Writer fos) {
        super(fos);
    }

    public void print(int ch) throws IOException {
        this.write(ch);
        throw new RuntimeException();
    }

    @Override
    public void write(String s2, int off, int len) throws IOException {
        int end = off + len;
        for (int i = off; i < end; ++i) {
            this.write(s2.charAt(i));
        }
    }

    private boolean isClean(int ch) {
        return ch >= 32 && ch <= 126 || ch == this.cr || ch == this.lf;
    }

    @Override
    public void write(int ch) throws IOException {
        if (this.isClean(ch)) {
            super.write(ch);
            return;
        }
        this.mini.setLength(0);
        this.mini.append(Integer.toHexString(ch));
        int len = this.mini.length();
        int cutPos = len < 4 ? 6 - len : 2;
        super.write("\\u0000", 0, cutPos);
        super.write(this.mini.toString(), 0, len);
    }
}

