/*
 * Decompiled with CFR 0.152.
 */
package sootup.core.util;

import java.text.StringCharacterIterator;

public class StringTools {
    public static final String lineSeparator = System.getProperty("line.separator");

    public static String getEscapedStringOf(String fromString) {
        char[] fromStringArray = fromString.toCharArray();
        char cr = lineSeparator.charAt(0);
        char lf = lineSeparator.length() == 2 ? lineSeparator.charAt(1) : cr;
        int firstNonAlphaPos = -1;
        int size = fromStringArray.length;
        for (int j = 0; j < size; ++j) {
            boolean isPrintableAscii;
            char ch = fromStringArray[j];
            boolean bl = isPrintableAscii = ch >= ' ' && ch <= '~';
            if ((isPrintableAscii || ch == cr || ch == lf) && ch != '\\') continue;
            firstNonAlphaPos = j;
            break;
        }
        if (firstNonAlphaPos == -1) {
            return fromString;
        }
        StringBuilder sb = new StringBuilder(fromString.length() + 5);
        for (int i = 0; i < firstNonAlphaPos; ++i) {
            sb.append(fromStringArray[i]);
        }
        int fromStringArrayLength = fromStringArray.length;
        for (int j = firstNonAlphaPos; j < fromStringArrayLength; ++j) {
            char ch = fromStringArray[j];
            if ((ch >= ' ' && ch <= '~' || ch == cr || ch == lf) && ch != '\\') {
                sb.append(ch);
                continue;
            }
            sb.append(StringTools.getUnicodeStringFromChar(ch));
        }
        return sb.toString();
    }

    public static String getQuotedStringOf(String fromString, boolean needsQuotes) {
        StringBuilder builder = new StringBuilder(fromString.length() + 20);
        builder.append("\"");
        for (int i = 0; i < fromString.length(); ++i) {
            char ch = fromString.charAt(i);
            if (ch == '\\') {
                builder.append("\\\\");
                needsQuotes = true;
                continue;
            }
            if (ch == '\'') {
                builder.append("\\'");
                needsQuotes = true;
                continue;
            }
            if (ch == '\"') {
                builder.append("\\\"");
                needsQuotes = true;
                continue;
            }
            if (ch == '\n') {
                builder.append("\\n");
                needsQuotes = true;
                continue;
            }
            if (ch == '\t') {
                builder.append("\\t");
                needsQuotes = true;
                continue;
            }
            if (ch == '\r') {
                builder.append("\\r");
                needsQuotes = true;
                continue;
            }
            if (ch == '\f') {
                builder.append("\\f");
                needsQuotes = true;
                continue;
            }
            if (ch >= ' ' && ch <= '~') {
                builder.append(ch);
                if (ch != ' ' && ch != ';' && ch != '/') continue;
                needsQuotes = true;
                continue;
            }
            builder.append(StringTools.getUnicodeStringFromChar(ch));
        }
        return needsQuotes ? builder.append('\"').toString() : builder.subSequence(1, builder.length()).toString();
    }

    public static String getUnicodeStringFromChar(char ch) {
        StringBuilder sb = new StringBuilder(6);
        sb.append("\\u");
        String hexVal = Integer.toHexString(ch);
        switch (hexVal.length()) {
            case 1: {
                sb.append("000");
                break;
            }
            case 2: {
                sb.append("00");
                break;
            }
            case 3: {
                sb.append('0');
            }
        }
        sb.append(hexVal);
        return sb.toString();
    }

    public static String getUnEscapedStringOf(String str) {
        StringBuilder buf = new StringBuilder();
        StringCharacterIterator iter = new StringCharacterIterator(str);
        char ch = iter.first();
        while (ch != '\uffff') {
            if (ch != '\\') {
                buf.append(ch);
            } else {
                ch = iter.next();
                if (ch == '\\') {
                    buf.append(ch);
                } else {
                    char format = StringTools.getCFormatChar(ch);
                    if (format != '\u0000') {
                        buf.append(format);
                    } else if (ch == 'u') {
                        StringBuilder mini = new StringBuilder(4);
                        for (int i = 0; i < 4; ++i) {
                            mini.append(iter.next());
                        }
                        ch = (char)Integer.parseInt(mini.toString(), 16);
                        buf.append(ch);
                    } else {
                        throw new RuntimeException("Unexpected char: " + ch);
                    }
                }
            }
            ch = iter.next();
        }
        return buf.toString();
    }

    public static char getCFormatChar(char c) {
        char res;
        switch (c) {
            case 'n': {
                res = '\n';
                break;
            }
            case 't': {
                res = '\t';
                break;
            }
            case 'r': {
                res = '\r';
                break;
            }
            case 'b': {
                res = '\b';
                break;
            }
            case 'f': {
                res = '\f';
                break;
            }
            case '\"': {
                res = '\"';
                break;
            }
            case '\'': {
                res = '\'';
                break;
            }
            default: {
                res = '\u0000';
            }
        }
        return res;
    }
}

