/*
 * Decompiled with CFR 0.152.
 */
package sootup.core.util.printer;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import sootup.core.jimple.Jimple;
import sootup.core.jimple.basic.Local;
import sootup.core.jimple.common.constant.Constant;
import sootup.core.jimple.common.stmt.Stmt;
import sootup.core.signatures.PackageName;
import sootup.core.types.ArrayType;
import sootup.core.types.ClassType;
import sootup.core.types.Type;
import sootup.core.util.printer.StmtPrinter;

public abstract class AbstractStmtPrinter
extends StmtPrinter {
    protected boolean startOfLine = true;
    protected final char indentChar = (char)32;
    protected final int indentStep = 4;
    protected int indent = 0;
    protected StringBuilder output = new StringBuilder();
    private final HashMap<String, PackageName> imports = new HashMap();
    boolean useImports = false;

    void enableImports(boolean enable) {
        this.useImports = enable;
    }

    public boolean addImport(Type referencedImport) {
        if (referencedImport instanceof ClassType) {
            String referencedClassName = ((ClassType)referencedImport).getClassName();
            PackageName referencedPackageName = ((ClassType)referencedImport).getPackageName();
            PackageName packageName = this.imports.get(referencedClassName);
            if (packageName == null) {
                this.imports.put(referencedClassName, referencedPackageName);
                return true;
            }
            return packageName.equals(referencedPackageName);
        }
        return false;
    }

    public Map<String, PackageName> getImports() {
        return this.imports;
    }

    public void stmt(Stmt currentStmt) {
        this.startStmt(currentStmt);
        currentStmt.toString(this);
        this.endStmt(currentStmt);
        this.output.append(";");
        this.newline();
    }

    @Override
    public void startStmt(Stmt u) {
        this.handleIndent();
    }

    @Override
    public void endStmt(Stmt u) {
    }

    @Override
    public void noIndent() {
        this.startOfLine = false;
    }

    @Override
    public void setIndent(int offset) {
        this.indent += offset;
    }

    @Override
    public void incIndent() {
        this.indent += 4;
    }

    @Override
    public void decIndent() {
        this.indent -= 4;
    }

    @Override
    public void modifier(String str) {
        this.handleIndent();
        this.output.append(str);
    }

    @Override
    public void typeSignature(@Nonnull Type type) {
        this.handleIndent();
        if (this.useImports) {
            if (type instanceof ClassType) {
                if (this.addImport(type)) {
                    this.output.append(Jimple.escape(((ClassType)type).getClassName()));
                }
            } else if (type instanceof ArrayType) {
                ((ArrayType)type).toString(this);
            } else {
                this.output.append(type.toString());
            }
        } else {
            this.output.append(Jimple.escape(type.toString()));
        }
    }

    @Override
    public void newline() {
        this.output.append("\n");
        this.startOfLine = true;
    }

    @Override
    public void local(Local l) {
        this.handleIndent();
        this.output.append(l.toString());
    }

    @Override
    public void constant(Constant c) {
        this.handleIndent();
        this.output.append(c);
    }

    @Override
    public void handleIndent() {
        if (this.startOfLine) {
            for (int i = this.indent; i > 0; --i) {
                this.output.append(' ');
            }
        }
        this.startOfLine = false;
    }

    public String toString() {
        return this.output.toString();
    }
}

