/*
 * Decompiled with CFR 0.152.
 */
package sootup.core.util.printer;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import sootup.core.graph.StmtGraph;
import sootup.core.jimple.Jimple;
import sootup.core.jimple.basic.Trap;
import sootup.core.jimple.common.ref.IdentityRef;
import sootup.core.jimple.common.stmt.Stmt;
import sootup.core.model.SootField;
import sootup.core.model.SootMethod;
import sootup.core.signatures.FieldSignature;
import sootup.core.signatures.FieldSubSignature;
import sootup.core.signatures.MethodSignature;
import sootup.core.signatures.MethodSubSignature;
import sootup.core.types.Type;
import sootup.core.util.printer.AbstractStmtPrinter;

public abstract class LabeledStmtPrinter
extends AbstractStmtPrinter {
    protected Map<Stmt, String> labels;
    protected Map<Stmt, String> references;

    public Map<Stmt, String> getLabels() {
        return this.labels;
    }

    public Map<Stmt, String> getReferences() {
        return this.references;
    }

    @Override
    public abstract void literal(String var1);

    @Override
    public abstract void method(SootMethod var1);

    @Override
    public abstract void field(SootField var1);

    @Override
    public abstract void identityRef(IdentityRef var1);

    @Override
    public void stmtRef(Stmt stmt, boolean branchTarget) {
        if (branchTarget) {
            this.setIndent(-2);
            this.handleIndent();
            this.setIndent(2);
            String label = this.labels.get(stmt);
            if (label == null) {
                this.output.append("[?= ").append(Jimple.escape(stmt.toString())).append(']');
            } else {
                this.output.append(Jimple.escape(label));
            }
        } else {
            String ref = this.references.get(stmt);
            if (this.startOfLine) {
                this.setIndent(-2);
                this.handleIndent();
                this.setIndent(2);
                this.output.append('(').append(Jimple.escape(ref)).append(')');
            } else {
                this.output.append(Jimple.escape(ref));
            }
        }
    }

    public Iterable<Stmt> initializeSootMethod(@Nonnull StmtGraph<?> stmtGraph) {
        this.graph = stmtGraph;
        List<Stmt> linearizedStmtGraph = this.getStmts(stmtGraph);
        return linearizedStmtGraph;
    }

    @Nonnull
    public List<Stmt> getStmts(@Nonnull StmtGraph<?> stmtGraph) {
        Collection<Stmt> targetStmtsOfBranches = stmtGraph.getLabeledStmts();
        List<Trap> traps = stmtGraph.getTraps();
        int maxEstimatedSize = targetStmtsOfBranches.size() + traps.size() * 3;
        this.labels = new HashMap<Stmt, String>(maxEstimatedSize, 1.0f);
        this.references = new HashMap<Stmt, String>(maxEstimatedSize, 1.0f);
        HashSet<Stmt> labelStmts = new HashSet<Stmt>();
        HashSet<Stmt> refStmts = new HashSet<Stmt>();
        HashSet trapStmts = new HashSet();
        traps.forEach(trap -> {
            trapStmts.add(trap.getHandlerStmt());
            trapStmts.add(trap.getBeginStmt());
            trapStmts.add(trap.getEndStmt());
        });
        for (Stmt stmt : targetStmtsOfBranches) {
            if (stmtGraph.isStmtBranchTarget(stmt) || trapStmts.contains(stmt)) {
                labelStmts.add(stmt);
                continue;
            }
            refStmts.add(stmt);
        }
        int maxDigits = 1 + (int)Math.log10(labelStmts.size());
        String formatString = "label%0" + maxDigits + "d";
        int labelCount = 0;
        int refCount = 0;
        List<Stmt> linearizedStmtGraph = stmtGraph.getStmts();
        for (Stmt s2 : linearizedStmtGraph) {
            if (labelStmts.contains(s2)) {
                this.labels.put(s2, String.format(formatString, ++labelCount));
            }
            if (!refStmts.contains(s2)) continue;
            this.references.put(s2, Integer.toString(refCount++));
        }
        return linearizedStmtGraph;
    }

    @Override
    public void methodSignature(MethodSignature methodSig) {
        this.output.append('<');
        this.typeSignature(methodSig.getDeclClassType());
        this.output.append(": ");
        this.typeSignature(methodSig.getType());
        this.output.append(' ').append(Jimple.escape(methodSig.getName())).append('(');
        List<Type> parameterTypes = ((MethodSubSignature)methodSig.getSubSignature()).getParameterTypes();
        int parameterTypesSize = parameterTypes.size();
        if (parameterTypesSize > 0) {
            this.typeSignature(parameterTypes.get(0));
            for (int i = 1; i < parameterTypesSize; ++i) {
                this.output.append(',');
                this.typeSignature(parameterTypes.get(i));
            }
        }
        this.output.append(")>");
    }

    @Override
    public void fieldSignature(FieldSignature fieldSig) {
        this.output.append('<');
        this.typeSignature(fieldSig.getDeclClassType());
        this.output.append(": ");
        FieldSubSignature subSignature = (FieldSubSignature)fieldSig.getSubSignature();
        this.typeSignature(subSignature.getType());
        this.output.append(' ').append(Jimple.escape(subSignature.getName())).append('>');
    }
}

