/*
 * Decompiled with CFR 0.152.
 */
package sootup.core.views;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import sootup.core.IdentifierFactory;
import sootup.core.Project;
import sootup.core.Scope;
import sootup.core.model.SootClass;
import sootup.core.model.SootField;
import sootup.core.model.SootMethod;
import sootup.core.signatures.FieldSignature;
import sootup.core.signatures.FieldSubSignature;
import sootup.core.signatures.MethodSignature;
import sootup.core.signatures.MethodSubSignature;
import sootup.core.typehierarchy.TypeHierarchy;
import sootup.core.typehierarchy.ViewTypeHierarchy;
import sootup.core.views.View;

public abstract class AbstractView<T extends SootClass<?>>
implements View<T> {
    @Nonnull
    private final Project<T, ? extends View<T>> project;
    @Nonnull
    private final Map<View.ModuleDataKey<?>, Object> moduleData = new HashMap();
    @Nullable
    private TypeHierarchy typeHierarchy;

    @Override
    @Nonnull
    public TypeHierarchy getTypeHierarchy() {
        if (this.typeHierarchy == null) {
            this.typeHierarchy = new ViewTypeHierarchy(this);
        }
        return this.typeHierarchy;
    }

    public AbstractView(@Nonnull Project<?, ? extends View<?>> project) {
        this.project = project;
        this.typeHierarchy = new ViewTypeHierarchy(this);
    }

    @Override
    @Nonnull
    public IdentifierFactory getIdentifierFactory() {
        return this.getProject().getIdentifierFactory();
    }

    @Override
    @Nonnull
    public Optional<Scope> getScope() {
        throw new UnsupportedOperationException("not implemented yet");
    }

    @Override
    @Nonnull
    public Optional<? extends SootMethod> getMethod(@Nonnull MethodSignature signature) {
        Optional aClass = this.getClass(signature.getDeclClassType());
        if (!aClass.isPresent()) {
            return Optional.empty();
        }
        return ((SootClass)aClass.get()).getMethod((MethodSubSignature)signature.getSubSignature());
    }

    @Override
    @Nonnull
    public Optional<? extends SootField> getField(@Nonnull FieldSignature signature) {
        Optional aClass = this.getClass(signature.getDeclClassType());
        if (!aClass.isPresent()) {
            return Optional.empty();
        }
        return ((SootClass)aClass.get()).getField((FieldSubSignature)signature.getSubSignature());
    }

    @Override
    @Nullable
    public <K> K getModuleData(@Nonnull View.ModuleDataKey<K> key) {
        return (K)this.moduleData.get(key);
    }

    @Override
    public <K> void putModuleData(@Nonnull View.ModuleDataKey<K> key, @Nonnull K value) {
        this.moduleData.put(key, value);
    }

    @Override
    @Nonnull
    public Project<? extends T, ? extends View<T>> getProject() {
        return this.project;
    }
}

