/*
 * Decompiled with CFR 0.152.
 */
package sootup.java.bytecode.frontend;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;
import sootup.core.IdentifierFactory;
import sootup.core.frontend.ResolveException;
import sootup.core.inputlocation.AnalysisInputLocation;
import sootup.core.jimple.basic.NoPositionInformation;
import sootup.core.model.Modifier;
import sootup.core.model.Position;
import sootup.core.model.SootClass;
import sootup.core.model.SootField;
import sootup.core.model.SootMethod;
import sootup.core.signatures.FieldSignature;
import sootup.core.signatures.MethodSignature;
import sootup.core.types.ClassType;
import sootup.core.types.Type;
import sootup.java.bytecode.frontend.AsmMethodSource;
import sootup.java.bytecode.frontend.AsmUtil;
import sootup.java.core.AnnotationUsage;
import sootup.java.core.JavaIdentifierFactory;
import sootup.java.core.JavaSootClassSource;
import sootup.java.core.JavaSootField;
import sootup.java.core.JavaSootMethod;
import sootup.java.core.types.JavaClassType;

class AsmClassSource
extends JavaSootClassSource {
    @Nonnull
    private final ClassNode classNode;

    public AsmClassSource(AnalysisInputLocation<? extends SootClass<?>> inputLocation, Path sourcePath, JavaClassType javaClassType, @Nonnull ClassNode classNode) {
        super(inputLocation, javaClassType, sourcePath);
        this.classNode = classNode;
    }

    private static Set<JavaSootField> resolveFields(List<FieldNode> fieldNodes, IdentifierFactory signatureFactory, ClassType classSignature) {
        return fieldNodes.stream().map(fieldNode -> {
            String fieldName = fieldNode.name;
            Type fieldType = AsmUtil.toJimpleType(fieldNode.desc);
            FieldSignature fieldSignature = signatureFactory.getFieldSignature(fieldName, classSignature, fieldType);
            EnumSet<Modifier> modifiers = AsmUtil.getModifiers(fieldNode.access);
            return new JavaSootField(fieldSignature, modifiers, AsmClassSource.convertAnnotation(fieldNode.invisibleAnnotations), NoPositionInformation.getInstance());
        }).collect(Collectors.toSet());
    }

    protected static List<AnnotationUsage> convertAnnotation(List<AnnotationNode> nodes) {
        if (nodes == null) {
            return Collections.emptyList();
        }
        return StreamSupport.stream(AsmUtil.createAnnotationUsage(nodes).spliterator(), false).collect(Collectors.toList());
    }

    @Override
    protected Iterable<AnnotationUsage> resolveAnnotations() {
        ArrayList<AnnotationNode> annotationNodes = new ArrayList<AnnotationNode>();
        annotationNodes.addAll(this.classNode.visibleAnnotations != null ? this.classNode.visibleAnnotations : Collections.emptyList());
        annotationNodes.addAll(this.classNode.visibleTypeAnnotations != null ? this.classNode.visibleTypeAnnotations : Collections.emptyList());
        annotationNodes.addAll(this.classNode.invisibleAnnotations != null ? this.classNode.invisibleAnnotations : Collections.emptyList());
        annotationNodes.addAll(this.classNode.invisibleTypeAnnotations != null ? this.classNode.invisibleTypeAnnotations : Collections.emptyList());
        return AsmClassSource.convertAnnotation(annotationNodes);
    }

    @Override
    @Nonnull
    public Collection<? extends SootMethod> resolveMethods() throws ResolveException {
        JavaIdentifierFactory identifierFactory = JavaIdentifierFactory.getInstance();
        return this.classNode.methods.stream().map(methodSource -> {
            AsmMethodSource asmClassClassSourceContent = (AsmMethodSource)methodSource;
            asmClassClassSourceContent.setDeclaringClass(this.classSignature);
            ArrayList<ClassType> exceptions = new ArrayList<ClassType>();
            exceptions.addAll(AsmUtil.asmIdToSignature(methodSource.exceptions));
            String methodName = methodSource.name;
            EnumSet<Modifier> modifiers = AsmUtil.getModifiers(methodSource.access);
            List<Type> sigTypes = AsmUtil.toJimpleSignatureDesc(methodSource.desc);
            Type retType = sigTypes.remove(sigTypes.size() - 1);
            MethodSignature methodSignature = identifierFactory.getMethodSignature(this.classSignature, methodName, retType, sigTypes);
            return new JavaSootMethod(asmClassClassSourceContent, methodSignature, modifiers, exceptions, AsmClassSource.convertAnnotation(methodSource.invisibleAnnotations), NoPositionInformation.getInstance());
        }).collect(Collectors.toSet());
    }

    @Override
    @Nonnull
    public Collection<? extends SootField> resolveFields() throws ResolveException {
        JavaIdentifierFactory identifierFactory = JavaIdentifierFactory.getInstance();
        return AsmClassSource.resolveFields(this.classNode.fields, identifierFactory, this.classSignature);
    }

    @Nonnull
    public EnumSet<Modifier> resolveModifiers() {
        return AsmUtil.getModifiers(this.classNode.access);
    }

    @Override
    @Nonnull
    public Set<? extends ClassType> resolveInterfaces() {
        return new HashSet<JavaClassType>(AsmUtil.asmIdToSignature(this.classNode.interfaces));
    }

    @Override
    @Nonnull
    public Optional<? extends ClassType> resolveSuperclass() {
        if (this.classNode.superName == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(AsmUtil.toJimpleClassType(this.classNode.superName));
    }

    @Override
    @Nonnull
    public Optional<? extends ClassType> resolveOuterClass() {
        return Optional.ofNullable(AsmUtil.toJimpleClassType(this.classNode.outerClass));
    }

    @Override
    @Nonnull
    public Position resolvePosition() {
        return NoPositionInformation.getInstance();
    }

    public String toString() {
        return this.getSourcePath().toString();
    }
}

