/*
 * Decompiled with CFR 0.152.
 */
package sootup.java.bytecode.frontend;

import com.google.common.base.Suppliers;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Table;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.objectweb.asm.Handle;
import org.objectweb.asm.commons.JSRInlinerAdapter;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.IincInsnNode;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.IntInsnNode;
import org.objectweb.asm.tree.InvokeDynamicInsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.LineNumberNode;
import org.objectweb.asm.tree.LocalVariableNode;
import org.objectweb.asm.tree.LookupSwitchInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MultiANewArrayInsnNode;
import org.objectweb.asm.tree.TableSwitchInsnNode;
import org.objectweb.asm.tree.TryCatchBlockNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;
import sootup.core.frontend.BodySource;
import sootup.core.graph.MutableBlockStmtGraph;
import sootup.core.jimple.Jimple;
import sootup.core.jimple.basic.Immediate;
import sootup.core.jimple.basic.Local;
import sootup.core.jimple.basic.NoPositionInformation;
import sootup.core.jimple.basic.StmtPositionInfo;
import sootup.core.jimple.basic.Trap;
import sootup.core.jimple.basic.Value;
import sootup.core.jimple.common.constant.Constant;
import sootup.core.jimple.common.constant.DoubleConstant;
import sootup.core.jimple.common.constant.FloatConstant;
import sootup.core.jimple.common.constant.IntConstant;
import sootup.core.jimple.common.constant.LongConstant;
import sootup.core.jimple.common.constant.MethodHandle;
import sootup.core.jimple.common.constant.NullConstant;
import sootup.core.jimple.common.expr.AbstractBinopExpr;
import sootup.core.jimple.common.expr.AbstractConditionExpr;
import sootup.core.jimple.common.expr.AbstractInstanceInvokeExpr;
import sootup.core.jimple.common.expr.AbstractInvokeExpr;
import sootup.core.jimple.common.expr.AbstractUnopExpr;
import sootup.core.jimple.common.expr.Expr;
import sootup.core.jimple.common.expr.JAddExpr;
import sootup.core.jimple.common.expr.JCastExpr;
import sootup.core.jimple.common.expr.JDynamicInvokeExpr;
import sootup.core.jimple.common.expr.JInstanceOfExpr;
import sootup.core.jimple.common.expr.JNewArrayExpr;
import sootup.core.jimple.common.expr.JNewMultiArrayExpr;
import sootup.core.jimple.common.expr.JStaticInvokeExpr;
import sootup.core.jimple.common.ref.JArrayRef;
import sootup.core.jimple.common.ref.JCaughtExceptionRef;
import sootup.core.jimple.common.ref.JFieldRef;
import sootup.core.jimple.common.ref.JInstanceFieldRef;
import sootup.core.jimple.common.ref.JParameterRef;
import sootup.core.jimple.common.ref.JStaticFieldRef;
import sootup.core.jimple.common.ref.JThisRef;
import sootup.core.jimple.common.stmt.AbstractOpStmt;
import sootup.core.jimple.common.stmt.BranchingStmt;
import sootup.core.jimple.common.stmt.JAssignStmt;
import sootup.core.jimple.common.stmt.JGotoStmt;
import sootup.core.jimple.common.stmt.JIdentityStmt;
import sootup.core.jimple.common.stmt.JIfStmt;
import sootup.core.jimple.common.stmt.JInvokeStmt;
import sootup.core.jimple.common.stmt.JNopStmt;
import sootup.core.jimple.common.stmt.JReturnStmt;
import sootup.core.jimple.common.stmt.JThrowStmt;
import sootup.core.jimple.common.stmt.Stmt;
import sootup.core.jimple.javabytecode.stmt.JSwitchStmt;
import sootup.core.jimple.visitor.Acceptor;
import sootup.core.jimple.visitor.ConstantVisitor;
import sootup.core.model.Body;
import sootup.core.model.Modifier;
import sootup.core.model.Position;
import sootup.core.signatures.FieldSignature;
import sootup.core.signatures.MethodSignature;
import sootup.core.transform.BodyInterceptor;
import sootup.core.types.ArrayType;
import sootup.core.types.ClassType;
import sootup.core.types.PrimitiveType;
import sootup.core.types.Type;
import sootup.core.types.UnknownType;
import sootup.core.types.VoidType;
import sootup.java.bytecode.frontend.AsmUtil;
import sootup.java.bytecode.frontend.BranchedInsnInfo;
import sootup.java.bytecode.frontend.NonIndexOutofBoundsArrayList;
import sootup.java.bytecode.frontend.Operand;
import sootup.java.bytecode.frontend.OperandStack;
import sootup.java.bytecode.frontend.StackFrame;
import sootup.java.bytecode.frontend.StmtContainer;
import sootup.java.core.JavaIdentifierFactory;
import sootup.java.core.jimple.basic.JavaLocal;
import sootup.java.core.language.JavaJimple;
import sootup.java.core.types.JavaClassType;

public class AsmMethodSource
extends JSRInlinerAdapter
implements BodySource {
    private int nextLocal;
    private List<JavaLocal> locals;
    private LinkedListMultimap<BranchingStmt, LabelNode> stmtsThatBranchToLabel;
    private Map<AbstractInsnNode, Stmt> insnToStmt;
    @Nonnull
    private final Map<Stmt, Stmt> replacedStmt = new HashMap<Stmt, Stmt>();
    private OperandStack operandStack;
    private Map<LabelNode, Stmt> trapHandler;
    private int currentLineNumber = -1;
    private int maxLineNumber = 0;
    @Nullable
    private JavaClassType declaringClass;
    @Nonnull
    private final List<BodyInterceptor> bodyInterceptors;
    @Nonnull
    private final Set<LabelNode> inlineExceptionLabels = new HashSet<LabelNode>();
    @Nonnull
    private final Map<LabelNode, Stmt> inlineExceptionHandlers = new HashMap<LabelNode, Stmt>();
    @Nonnull
    private final Map<LabelNode, Stmt> labelsToStmt = new HashMap<LabelNode, Stmt>();
    private JavaIdentifierFactory javaIdentifierFactory = JavaIdentifierFactory.getInstance();
    private final Supplier<MethodSignature> lazyMethodSignature = Suppliers.memoize(() -> {
        List<Type> sigTypes = AsmUtil.toJimpleSignatureDesc(this.desc);
        Type retType = sigTypes.remove(sigTypes.size() - 1);
        return this.javaIdentifierFactory.getMethodSignature((ClassType)this.declaringClass, this.name, retType, sigTypes);
    });

    AsmMethodSource(int access, @Nonnull String name, @Nonnull String desc, @Nonnull String signature, @Nonnull String[] exceptions, @Nonnull List<BodyInterceptor> bodyInterceptors) {
        super(589824, null, access, name, desc, signature, exceptions);
        this.bodyInterceptors = bodyInterceptors;
    }

    @Override
    @Nonnull
    public MethodSignature getSignature() {
        return this.lazyMethodSignature.get();
    }

    void setDeclaringClass(@Nonnull ClassType declaringClass) {
        this.declaringClass = (JavaClassType)declaringClass;
    }

    @Override
    @Nonnull
    public Body resolveBody(@Nonnull Iterable<Modifier> modifierIt) {
        this.nextLocal = this.maxLocals;
        this.locals = new NonIndexOutofBoundsArrayList<JavaLocal>(this.maxLocals + Math.max(this.maxLocals / 2, 5));
        this.stmtsThatBranchToLabel = LinkedListMultimap.create();
        this.insnToStmt = new LinkedHashMap<AbstractInsnNode, Stmt>(this.instructions.size());
        this.operandStack = new OperandStack(this, this.instructions.size());
        this.trapHandler = new LinkedHashMap<LabelNode, Stmt>(this.tryCatchBlocks.size());
        for (TryCatchBlockNode tc : this.tryCatchBlocks) {
            this.trapHandler.put(tc.handler, null);
        }
        try {
            this.convert();
        }
        catch (Exception e) {
            this.instructions.iterator().forEachRemaining(item -> System.out.println(AsmUtil.toString(item)));
            throw new RuntimeException("Failed to convert " + this.lazyMethodSignature.get(), e);
        }
        MutableBlockStmtGraph graph = new MutableBlockStmtGraph();
        Body.BodyBuilder bodyBuilder = Body.builder(graph);
        bodyBuilder.setModifiers(AsmUtil.getModifiers(this.access));
        try {
            this.arrangeStmts(graph, bodyBuilder);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to convert " + this.lazyMethodSignature.get(), e);
        }
        if (graph.nodes().size() > 0) {
            Position firstStmtPos = graph.getStartingStmt().getPositionInfo().getStmtPosition();
            bodyBuilder.setPosition(new Position(firstStmtPos.getFirstLine(), firstStmtPos.getFirstCol(), this.maxLineNumber, Integer.MAX_VALUE));
        } else {
            bodyBuilder.setPosition(NoPositionInformation.getInstance());
        }
        this.locals = null;
        this.stmtsThatBranchToLabel = null;
        this.insnToStmt = null;
        this.operandStack = null;
        bodyBuilder.setMethodSignature(this.lazyMethodSignature.get());
        for (BodyInterceptor bodyInterceptor : this.bodyInterceptors) {
            try {
                bodyInterceptor.interceptBody(bodyBuilder);
            }
            catch (Exception e) {
                throw new IllegalStateException("Failed to apply " + bodyInterceptor + " to " + this.lazyMethodSignature.get(), e);
            }
        }
        return bodyBuilder.build();
    }

    @Override
    public Object resolveAnnotationsDefaultValue() {
        return this.resolveAnnotationsInDefaultValue(this.annotationDefault);
    }

    private Object resolveAnnotationsInDefaultValue(Object a) {
        if (a instanceof AnnotationNode) {
            return AsmUtil.createAnnotationUsage(Collections.singletonList((AnnotationNode)a));
        }
        if (a instanceof ArrayList) {
            ArrayList list = new ArrayList();
            ((ArrayList)a).forEach(e -> list.add(this.resolveAnnotationsInDefaultValue(e)));
            return list;
        }
        return AsmUtil.convertAnnotationValue(a);
    }

    @Nonnull
    private JavaLocal getOrCreateLocal(int idx) {
        if (idx >= this.maxLocals) {
            throw new IllegalArgumentException("Invalid local index: " + idx);
        }
        JavaLocal local = this.locals.get(idx);
        if (local == null) {
            String name = this.determineLocalName(idx);
            local = JavaJimple.newLocal(name, UnknownType.getInstance(), Collections.emptyList());
            this.locals.set(idx, local);
        }
        return local;
    }

    @Nonnull
    private String determineLocalName(int idx) {
        String name;
        if (this.localVariables != null) {
            name = null;
            for (LocalVariableNode lvn : this.localVariables) {
                if (lvn.index != idx) continue;
                name = lvn.name;
                break;
            }
            if (name == null) {
                name = "l" + idx;
            }
        } else {
            name = "l" + idx;
        }
        return name;
    }

    void setStmt(@Nonnull AbstractInsnNode insn, @Nonnull Stmt stmt) {
        Stmt overwrittenStmt = this.insnToStmt.put(insn, stmt);
        if (overwrittenStmt != null) {
            throw new IllegalArgumentException(insn.getOpcode() + " already has an associated Stmt: " + overwrittenStmt);
        }
    }

    void mergeStmts(@Nonnull AbstractInsnNode insn, @Nonnull Stmt stmt) {
        Stmt prev = this.insnToStmt.put(insn, stmt);
        if (prev != null) {
            Stmt merged = StmtContainer.create(prev, stmt);
            this.insnToStmt.put(insn, merged);
        }
    }

    @Nonnull
    Local newStackLocal() {
        int idx = this.nextLocal++;
        JavaLocal l = JavaJimple.newLocal("$stack" + idx, UnknownType.getInstance(), Collections.emptyList());
        this.locals.set(idx, l);
        return l;
    }

    <A extends Stmt> A getStmt(@Nonnull AbstractInsnNode insn) {
        return (A)this.insnToStmt.get(insn);
    }

    private void addReadOperandAssignments() {
        this.addReadOperandAssignments_internal((opValue, operand) -> {
            if (opValue instanceof Local) {
                return true;
            }
            int op = operand.insn.getOpcode();
            return op != 180 && op != 178 && (op < 46 || op > 53);
        });
    }

    private void addReadOperandAssignments(@Nonnull Local local) {
        this.addReadOperandAssignments_internal((opValue, operand) -> {
            if (!opValue.equivTo(local)) {
                boolean noRef = true;
                for (Value use : opValue.getUses()) {
                    if (!use.equivTo(local)) continue;
                    noRef = false;
                    break;
                }
                return noRef;
            }
            return false;
        });
    }

    private void addReadOperandAssignments_internal(BiFunction<Value, Operand, Boolean> func) {
        for (Operand operand : this.operandStack.getStack()) {
            Local stackLocal;
            Value opValue = operand.value;
            if (operand == Operand.DWORD_DUMMY || operand.stackLocal != null || func.apply(opValue, operand).booleanValue()) continue;
            operand.stackLocal = stackLocal = this.newStackLocal();
            JAssignStmt<Local, Value> asssignStmt = Jimple.newAssignStmt(stackLocal, opValue, new StmtPositionInfo(this.currentLineNumber));
            this.setStmt(operand.insn, asssignStmt);
            operand.updateUsages();
        }
    }

    private void convertGetFieldInsn(@Nonnull FieldInsnNode insn) {
        Operand opr;
        Type type;
        StackFrame frame = this.operandStack.getOrCreateStackframe(insn);
        Operand[] out = frame.getOut();
        if (out == null) {
            JFieldRef val;
            JavaClassType declClass = this.javaIdentifierFactory.getClassType(AsmUtil.toQualifiedName(insn.owner));
            type = AsmUtil.toJimpleType(insn.desc);
            if (insn.getOpcode() == 178) {
                FieldSignature ref = this.javaIdentifierFactory.getFieldSignature(insn.name, (ClassType)declClass, type);
                val = Jimple.newStaticFieldRef(ref);
            } else {
                Operand base = this.operandStack.popLocal();
                FieldSignature ref = this.javaIdentifierFactory.getFieldSignature(insn.name, (ClassType)declClass, type);
                val = Jimple.newInstanceFieldRef((Local)base.stackOrValue(), ref);
                frame.setIn(base);
            }
            opr = new Operand(insn, val, this);
            frame.setOut(opr);
        } else {
            opr = out[0];
            type = ((JFieldRef)opr.value).getFieldSignature().getType();
            if (insn.getOpcode() == 180) {
                frame.mergeIn(this.operandStack.pop());
            }
        }
        this.operandStack.push(type, opr);
    }

    private void convertPutFieldInsn(@Nonnull FieldInsnNode insn) {
        boolean notInstance = insn.getOpcode() != 181;
        StackFrame frame = this.operandStack.getOrCreateStackframe(insn);
        Operand[] out = frame.getOut();
        if (out == null) {
            JFieldRef val;
            JavaClassType declClass = this.javaIdentifierFactory.getClassType(AsmUtil.toQualifiedName(insn.owner));
            Type type = AsmUtil.toJimpleType(insn.desc);
            Operand rvalue = this.operandStack.popImmediate(type);
            if (notInstance) {
                FieldSignature ref = this.javaIdentifierFactory.getFieldSignature(insn.name, (ClassType)declClass, type);
                val = Jimple.newStaticFieldRef(ref);
                frame.setIn(rvalue);
            } else {
                Operand base = this.operandStack.popLocal();
                FieldSignature ref = this.javaIdentifierFactory.getFieldSignature(insn.name, (ClassType)declClass, type);
                JInstanceFieldRef ifr = Jimple.newInstanceFieldRef((Local)base.stackOrValue(), ref);
                val = ifr;
                frame.setIn(rvalue, base);
            }
            Operand opr = new Operand(insn, val, this);
            frame.setOut(opr);
            JAssignStmt<JStaticFieldRef, Value> as = Jimple.newAssignStmt(val, rvalue.stackOrValue(), StmtPositionInfo.createNoStmtPositionInfo());
            this.setStmt(insn, as);
            rvalue.addUsageInStmt(as);
        } else {
            Operand opr = out[0];
            Type type = ((JFieldRef)opr.value).getFieldSignature().getType();
            Operand rvalue = this.operandStack.pop(type);
            if (notInstance) {
                frame.mergeIn(rvalue);
            } else {
                frame.mergeIn(rvalue, this.operandStack.pop());
            }
        }
        this.addReadOperandAssignments();
    }

    private void convertFieldInsn(@Nonnull FieldInsnNode insn) {
        int op = insn.getOpcode();
        if (op == 178 || op == 180) {
            this.convertGetFieldInsn(insn);
        } else {
            this.convertPutFieldInsn(insn);
        }
    }

    private void convertIincInsn(@Nonnull IincInsnNode insn) {
        JavaLocal local = this.getOrCreateLocal(insn.var);
        this.addReadOperandAssignments(local);
        if (!this.insnToStmt.containsKey(insn)) {
            JAddExpr add = Jimple.newAddExpr(local, IntConstant.getInstance(insn.incr));
            this.setStmt(insn, Jimple.newAssignStmt(local, add, new StmtPositionInfo(this.currentLineNumber)));
        }
    }

    private void convertConstInsn(@Nonnull InsnNode insn) {
        Operand opr;
        int op = insn.getOpcode();
        StackFrame frame = this.operandStack.getOrCreateStackframe(insn);
        Operand[] out = frame.getOut();
        if (out == null) {
            Constant v;
            if (op == 1) {
                v = NullConstant.getInstance();
            } else if (op >= 2 && op <= 8) {
                v = IntConstant.getInstance(op - 3);
            } else if (op == 9 || op == 10) {
                v = LongConstant.getInstance(op - 9);
            } else if (op >= 11 && op <= 13) {
                v = FloatConstant.getInstance(op - 11);
            } else if (op == 14 || op == 15) {
                v = DoubleConstant.getInstance(op - 14);
            } else {
                throw new UnsupportedOperationException("Unknown constant opcode: " + op);
            }
            opr = new Operand(insn, v, this);
            frame.setOut(opr);
        } else {
            opr = out[0];
        }
        if (op == 9 || op == 10 || op == 14 || op == 15) {
            this.operandStack.pushDual(opr);
        } else {
            this.operandStack.push(opr);
        }
    }

    private void convertArrayLoadInsn(@Nonnull InsnNode insn) {
        Operand opr;
        StackFrame frame = this.operandStack.getOrCreateStackframe(insn);
        Operand[] out = frame.getOut();
        if (out == null) {
            Operand indx = this.operandStack.popImmediate();
            Operand base = this.operandStack.popImmediate();
            JArrayRef ar = JavaJimple.getInstance().newArrayRef((Local)base.stackOrValue(), (Immediate)indx.stackOrValue());
            opr = new Operand(insn, ar, this);
            frame.setIn(indx, base);
            frame.setOut(opr);
        } else {
            opr = out[0];
            frame.mergeIn(this.operandStack.pop(), this.operandStack.pop());
        }
        int op = insn.getOpcode();
        if (op == 49 || op == 47) {
            this.operandStack.pushDual(opr);
        } else {
            this.operandStack.push(opr);
        }
    }

    private void convertArrayStoreInsn(@Nonnull InsnNode insn) {
        int op = insn.getOpcode();
        boolean dword = op == 80 || op == 82;
        StackFrame frame = this.operandStack.getOrCreateStackframe(insn);
        if (!this.insnToStmt.containsKey(insn)) {
            Operand valueOp = dword ? this.operandStack.popImmediateDual() : this.operandStack.popImmediate();
            Operand indexOp = this.operandStack.popImmediate();
            Operand baseOp = this.operandStack.popLocal();
            JArrayRef ar = JavaJimple.getInstance().newArrayRef((Local)baseOp.stackOrValue(), (Immediate)indexOp.stackOrValue());
            JAssignStmt<JArrayRef, Value> as = Jimple.newAssignStmt(ar, valueOp.stackOrValue(), StmtPositionInfo.createNoStmtPositionInfo());
            frame.setIn(valueOp, indexOp, baseOp);
            this.setStmt(insn, as);
            valueOp.addUsageInStmt(as);
        } else {
            frame.mergeIn(dword ? this.operandStack.popDual() : this.operandStack.pop(), this.operandStack.pop(), this.operandStack.pop());
        }
    }

    private void convertDupInsn(@Nonnull InsnNode insn) {
        boolean dword;
        int op = insn.getOpcode();
        Operand dupd = this.operandStack.popImmediate();
        Operand dupd2 = null;
        boolean bl = dword = op == 92 || op == 93 || op == 94;
        if (dword) {
            if (this.operandStack.peek() == Operand.DWORD_DUMMY) {
                this.operandStack.pop();
                dupd2 = dupd;
            } else {
                dupd2 = this.operandStack.popImmediate();
            }
        }
        if (op == 89) {
            this.operandStack.push(dupd);
            this.operandStack.push(dupd);
        } else if (op == 90) {
            Operand o2 = this.operandStack.popImmediate();
            this.operandStack.push(dupd);
            this.operandStack.push(o2);
            this.operandStack.push(dupd);
        } else if (op == 91) {
            Operand o2 = this.operandStack.popImmediate();
            Operand o3 = this.operandStack.peek() == Operand.DWORD_DUMMY ? this.operandStack.pop() : this.operandStack.popImmediate();
            this.operandStack.push(dupd);
            this.operandStack.push(o3);
            this.operandStack.push(o2);
            this.operandStack.push(dupd);
        } else if (op == 92) {
            this.operandStack.push(dupd2);
            this.operandStack.push(dupd);
            this.operandStack.push(dupd2);
            this.operandStack.push(dupd);
        } else if (op == 93) {
            Operand o2 = this.operandStack.popImmediate();
            this.operandStack.push(dupd2);
            this.operandStack.push(dupd);
            this.operandStack.push(o2);
            this.operandStack.push(dupd2);
            this.operandStack.push(dupd);
        } else if (op == 94) {
            Operand o2 = this.operandStack.popImmediate();
            Operand o2h = this.operandStack.peek() == Operand.DWORD_DUMMY ? this.operandStack.pop() : this.operandStack.popImmediate();
            this.operandStack.push(dupd2);
            this.operandStack.push(dupd);
            this.operandStack.push(o2h);
            this.operandStack.push(o2);
            this.operandStack.push(dupd2);
            this.operandStack.push(dupd);
        }
    }

    private void convertBinopInsn(@Nonnull InsnNode insn) {
        Operand opr;
        int op = insn.getOpcode();
        boolean dword = op == 99 || op == 97 || op == 103 || op == 101 || op == 107 || op == 105 || op == 111 || op == 109 || op == 115 || op == 113 || op == 121 || op == 123 || op == 125 || op == 127 || op == 129 || op == 131 || op == 148 || op == 151 || op == 152;
        StackFrame frame = this.operandStack.getOrCreateStackframe(insn);
        Operand[] out = frame.getOut();
        if (out == null) {
            AbstractBinopExpr binop;
            Operand op2 = dword && op != 121 && op != 123 && op != 125 ? this.operandStack.popImmediateDual() : this.operandStack.popImmediate();
            Operand op1 = dword ? this.operandStack.popImmediateDual() : this.operandStack.popImmediate();
            Immediate v1 = (Immediate)op1.stackOrValue();
            Immediate v2 = (Immediate)op2.stackOrValue();
            if (op >= 96 && op <= 99) {
                binop = Jimple.newAddExpr(v1, v2);
            } else if (op >= 100 && op <= 103) {
                binop = Jimple.newSubExpr(v1, v2);
            } else if (op >= 104 && op <= 107) {
                binop = Jimple.newMulExpr(v1, v2);
            } else if (op >= 108 && op <= 111) {
                binop = Jimple.newDivExpr(v1, v2);
            } else if (op >= 112 && op <= 115) {
                binop = Jimple.newRemExpr(v1, v2);
            } else if (op >= 120 && op <= 121) {
                binop = Jimple.newShlExpr(v1, v2);
            } else if (op >= 122 && op <= 123) {
                binop = Jimple.newShrExpr(v1, v2);
            } else if (op >= 124 && op <= 125) {
                binop = Jimple.newUshrExpr(v1, v2);
            } else if (op >= 126 && op <= 127) {
                binop = Jimple.newAndExpr(v1, v2);
            } else if (op >= 128 && op <= 129) {
                binop = Jimple.newOrExpr(v1, v2);
            } else if (op >= 130 && op <= 131) {
                binop = Jimple.newXorExpr(v1, v2);
            } else if (op == 148) {
                binop = Jimple.newCmpExpr(v1, v2);
            } else if (op == 149 || op == 151) {
                binop = Jimple.newCmplExpr(v1, v2);
            } else if (op == 150 || op == 152) {
                binop = Jimple.newCmpgExpr(v1, v2);
            } else {
                throw new UnsupportedOperationException("Unknown binop: " + op);
            }
            opr = new Operand(insn, binop, this);
            op1.addUsageInExpr(binop);
            op2.addUsageInExpr(binop);
            frame.setIn(op2, op1);
            frame.setOut(opr);
        } else {
            opr = out[0];
            if (dword) {
                if (op != 121 && op != 123 && op != 125) {
                    frame.mergeIn(this.operandStack.popDual(), this.operandStack.popDual());
                } else {
                    frame.mergeIn(this.operandStack.pop(), this.operandStack.popDual());
                }
            } else {
                frame.mergeIn(this.operandStack.pop(), this.operandStack.pop());
            }
        }
        if (dword && op < 148) {
            this.operandStack.pushDual(opr);
        } else {
            this.operandStack.push(opr);
        }
    }

    private void convertUnopInsn(@Nonnull InsnNode insn) {
        Operand opr;
        int op = insn.getOpcode();
        boolean dword = op == 117 || op == 119;
        StackFrame frame = this.operandStack.getOrCreateStackframe(insn);
        Operand[] out = frame.getOut();
        if (out == null) {
            AbstractUnopExpr unop;
            Operand op1 = dword ? this.operandStack.popImmediateDual() : this.operandStack.popImmediate();
            Value v1 = op1.stackOrValue();
            if (op >= 116 && op <= 119) {
                unop = Jimple.newNegExpr((Immediate)v1);
            } else if (op == 190) {
                unop = Jimple.newLengthExpr((Immediate)v1);
            } else {
                throw new UnsupportedOperationException("Unknown unop: " + op);
            }
            op1.addUsageInExpr(unop);
            opr = new Operand(insn, unop, this);
            frame.setIn(op1);
            frame.setOut(opr);
        } else {
            opr = out[0];
            frame.mergeIn(dword ? this.operandStack.popDual() : this.operandStack.pop());
        }
        if (dword) {
            this.operandStack.pushDual(opr);
        } else {
            this.operandStack.push(opr);
        }
    }

    private void convertPrimCastInsn(@Nonnull InsnNode insn) {
        Operand opr;
        int op = insn.getOpcode();
        boolean tod = op == 133 || op == 135 || op == 140 || op == 141 || op == 143 || op == 138;
        boolean fromd = op == 143 || op == 138 || op == 142 || op == 136 || op == 144 || op == 137;
        StackFrame frame = this.operandStack.getOrCreateStackframe(insn);
        Operand[] out = frame.getOut();
        if (out == null) {
            PrimitiveType totype;
            switch (op) {
                case 133: 
                case 140: 
                case 143: {
                    totype = PrimitiveType.getLong();
                    break;
                }
                case 136: 
                case 139: 
                case 142: {
                    totype = PrimitiveType.getInt();
                    break;
                }
                case 134: 
                case 137: 
                case 144: {
                    totype = PrimitiveType.getFloat();
                    break;
                }
                case 135: 
                case 138: 
                case 141: {
                    totype = PrimitiveType.getDouble();
                    break;
                }
                case 145: {
                    totype = PrimitiveType.getByte();
                    break;
                }
                case 147: {
                    totype = PrimitiveType.getShort();
                    break;
                }
                case 146: {
                    totype = PrimitiveType.getChar();
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown prim cast op: " + op);
                }
            }
            Operand val = fromd ? this.operandStack.popImmediateDual() : this.operandStack.popImmediate();
            JCastExpr cast = Jimple.newCastExpr((Immediate)val.stackOrValue(), totype);
            opr = new Operand(insn, cast, this);
            val.addUsageInExpr(cast);
            frame.setIn(val);
            frame.setOut(opr);
        } else {
            opr = out[0];
            frame.mergeIn(fromd ? this.operandStack.popDual() : this.operandStack.pop());
        }
        if (tod) {
            this.operandStack.pushDual(opr);
        } else {
            this.operandStack.push(opr);
        }
    }

    private void convertReturnInsn(@Nonnull InsnNode insn) {
        int op = insn.getOpcode();
        boolean dword = op == 173 || op == 175;
        StackFrame frame = this.operandStack.getOrCreateStackframe(insn);
        if (!this.insnToStmt.containsKey(insn)) {
            Operand val = dword ? this.operandStack.popImmediateDual() : this.operandStack.popImmediate();
            JReturnStmt ret = Jimple.newReturnStmt((Immediate)val.stackOrValue(), new StmtPositionInfo(this.currentLineNumber));
            frame.setIn(val);
            this.setStmt(insn, ret);
            val.addUsageInStmt(ret);
        } else {
            Operand operand = dword ? this.operandStack.popDual() : this.operandStack.pop();
            frame.mergeIn(operand);
        }
    }

    private void convertInsn(@Nonnull InsnNode insn) {
        int op = insn.getOpcode();
        if (op == 0) {
            if (!this.insnToStmt.containsKey(insn)) {
                this.insnToStmt.put(insn, Jimple.newNopStmt(new StmtPositionInfo(this.currentLineNumber)));
            }
        } else if (op >= 1 && op <= 15) {
            this.convertConstInsn(insn);
        } else if (op >= 46 && op <= 53) {
            this.convertArrayLoadInsn(insn);
        } else if (op >= 79 && op <= 86) {
            this.convertArrayStoreInsn(insn);
        } else if (op == 87) {
            this.operandStack.popImmediate();
        } else if (op == 88) {
            this.operandStack.popImmediate();
            if (this.operandStack.peek() == Operand.DWORD_DUMMY) {
                this.operandStack.pop();
            } else {
                this.operandStack.popImmediate();
            }
        } else if (op >= 89 && op <= 94) {
            this.convertDupInsn(insn);
        } else if (op == 95) {
            Operand o1 = this.operandStack.popImmediate();
            Operand o2 = this.operandStack.popImmediate();
            this.operandStack.push(o1);
            this.operandStack.push(o2);
        } else if (op >= 96 && op <= 115 || op >= 120 && op <= 131 || op >= 148 && op <= 152) {
            this.convertBinopInsn(insn);
        } else if (op >= 116 && op <= 119 || op == 190) {
            this.convertUnopInsn(insn);
        } else if (op >= 133 && op <= 147) {
            this.convertPrimCastInsn(insn);
        } else if (op >= 172 && op <= 176) {
            this.convertReturnInsn(insn);
        } else if (op == 177) {
            if (!this.insnToStmt.containsKey(insn)) {
                this.setStmt(insn, Jimple.newReturnVoidStmt(new StmtPositionInfo(this.currentLineNumber)));
            }
        } else if (op == 191) {
            Operand opr;
            StackFrame frame = this.operandStack.getOrCreateStackframe(insn);
            if (!this.insnToStmt.containsKey(insn)) {
                opr = this.operandStack.popImmediate();
                JThrowStmt ts = Jimple.newThrowStmt((Immediate)opr.stackOrValue(), new StmtPositionInfo(this.currentLineNumber));
                frame.setIn(opr);
                frame.setOut(opr);
                this.setStmt(insn, ts);
                opr.addUsageInStmt(ts);
            } else {
                opr = this.operandStack.pop();
                frame.mergeIn(opr);
            }
            this.operandStack.push(opr);
        } else if (op == 194 || op == 195) {
            StackFrame frame = this.operandStack.getOrCreateStackframe(insn);
            if (!this.insnToStmt.containsKey(insn)) {
                Operand opr = this.operandStack.popStackConst();
                AbstractOpStmt ts = op == 194 ? Jimple.newEnterMonitorStmt((Immediate)opr.stackOrValue(), new StmtPositionInfo(this.currentLineNumber)) : Jimple.newExitMonitorStmt((Immediate)opr.stackOrValue(), new StmtPositionInfo(this.currentLineNumber));
                frame.setIn(opr);
                this.setStmt(insn, ts);
                opr.addUsageInStmt(ts);
            } else {
                frame.mergeIn(this.operandStack.pop());
            }
        } else {
            throw new UnsupportedOperationException("Unknown insn op: " + op);
        }
    }

    private void convertIntInsn(@Nonnull IntInsnNode insn) {
        Operand opr;
        int op = insn.getOpcode();
        StackFrame frame = this.operandStack.getOrCreateStackframe(insn);
        Operand[] out = frame.getOut();
        if (out == null) {
            Acceptor<ConstantVisitor> v;
            if (op == 16 || op == 17) {
                v = IntConstant.getInstance(insn.operand);
            } else {
                PrimitiveType type;
                switch (insn.operand) {
                    case 4: {
                        type = PrimitiveType.getBoolean();
                        break;
                    }
                    case 5: {
                        type = PrimitiveType.getChar();
                        break;
                    }
                    case 6: {
                        type = PrimitiveType.getFloat();
                        break;
                    }
                    case 7: {
                        type = PrimitiveType.getDouble();
                        break;
                    }
                    case 8: {
                        type = PrimitiveType.getByte();
                        break;
                    }
                    case 9: {
                        type = PrimitiveType.getShort();
                        break;
                    }
                    case 10: {
                        type = PrimitiveType.getInt();
                        break;
                    }
                    case 11: {
                        type = PrimitiveType.getLong();
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException("Unknown NEWARRAY type!");
                    }
                }
                Operand size = this.operandStack.popImmediate();
                JNewArrayExpr anew = JavaJimple.getInstance().newNewArrayExpr(type, (Immediate)size.stackOrValue());
                size.addUsageInExpr(anew);
                frame.setIn(size);
                v = anew;
            }
            opr = new Operand(insn, (Value)((Object)v), this);
            frame.setOut(opr);
        } else {
            opr = out[0];
            if (op == 188) {
                frame.mergeIn(this.operandStack.pop());
            }
        }
        this.operandStack.push(opr);
    }

    private void convertJumpInsn(@Nonnull JumpInsnNode insn) {
        int op = insn.getOpcode();
        if (op == 167) {
            if (!this.insnToStmt.containsKey(insn)) {
                JGotoStmt gotoStmt = Jimple.newGotoStmt(new StmtPositionInfo(this.currentLineNumber));
                this.stmtsThatBranchToLabel.put(gotoStmt, insn.label);
                this.setStmt(insn, gotoStmt);
            }
            return;
        }
        StackFrame frame = this.operandStack.getOrCreateStackframe(insn);
        if (!this.insnToStmt.containsKey(insn)) {
            AbstractConditionExpr cond;
            Operand val = this.operandStack.popImmediate();
            Immediate v = (Immediate)val.stackOrValue();
            boolean isCmp = false;
            Operand val1 = null;
            if (op >= 159 && op <= 166) {
                isCmp = true;
                val1 = this.operandStack.popImmediate();
                Immediate v1 = (Immediate)val1.stackOrValue();
                switch (op) {
                    case 159: 
                    case 165: {
                        cond = Jimple.newEqExpr(v1, v);
                        break;
                    }
                    case 160: 
                    case 166: {
                        cond = Jimple.newNeExpr(v1, v);
                        break;
                    }
                    case 161: {
                        cond = Jimple.newLtExpr(v1, v);
                        break;
                    }
                    case 162: {
                        cond = Jimple.newGeExpr(v1, v);
                        break;
                    }
                    case 163: {
                        cond = Jimple.newGtExpr(v1, v);
                        break;
                    }
                    case 164: {
                        cond = Jimple.newLeExpr(v1, v);
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException("Unknown if op: " + op);
                    }
                }
                val1.addUsageInExpr(cond);
                val.addUsageInExpr(cond);
                frame.setIn(val, val1);
            } else {
                switch (op) {
                    case 153: {
                        cond = Jimple.newEqExpr(v, IntConstant.getInstance(0));
                        break;
                    }
                    case 154: {
                        cond = Jimple.newNeExpr(v, IntConstant.getInstance(0));
                        break;
                    }
                    case 155: {
                        cond = Jimple.newLtExpr(v, IntConstant.getInstance(0));
                        break;
                    }
                    case 156: {
                        cond = Jimple.newGeExpr(v, IntConstant.getInstance(0));
                        break;
                    }
                    case 157: {
                        cond = Jimple.newGtExpr(v, IntConstant.getInstance(0));
                        break;
                    }
                    case 158: {
                        cond = Jimple.newLeExpr(v, IntConstant.getInstance(0));
                        break;
                    }
                    case 198: {
                        cond = Jimple.newEqExpr(v, NullConstant.getInstance());
                        break;
                    }
                    case 199: {
                        cond = Jimple.newNeExpr(v, NullConstant.getInstance());
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException("Unknown if op: " + op);
                    }
                }
                val.addUsageInExpr(cond);
                frame.setIn(val);
            }
            JIfStmt ifStmt = Jimple.newIfStmt(cond, new StmtPositionInfo(this.currentLineNumber));
            this.stmtsThatBranchToLabel.put(ifStmt, insn.label);
            this.setStmt(insn, ifStmt);
            if (isCmp) {
                val1.addUsageInStmt(ifStmt);
            }
            val.addUsageInStmt(ifStmt);
        } else if (op >= 159 && op <= 166) {
            frame.mergeIn(this.operandStack.pop(), this.operandStack.pop());
        } else {
            frame.mergeIn(this.operandStack.pop());
        }
    }

    private void convertLdcInsn(@Nonnull LdcInsnNode insn) {
        Operand opr;
        Object val = insn.cst;
        boolean dword = val instanceof Long || val instanceof Double;
        StackFrame frame = this.operandStack.getOrCreateStackframe(insn);
        Operand[] out = frame.getOut();
        if (out == null) {
            Immediate v = this.toSootValue(val);
            opr = new Operand(insn, v, this);
            frame.setOut(opr);
        } else {
            opr = out[0];
        }
        if (dword) {
            this.operandStack.pushDual(opr);
        } else {
            this.operandStack.push(opr);
        }
    }

    private Immediate toSootValue(@Nonnull Object val) throws UnsupportedOperationException {
        Constant v;
        if (val instanceof Integer) {
            v = IntConstant.getInstance((Integer)val);
        } else if (val instanceof Float) {
            v = FloatConstant.getInstance(((Float)val).floatValue());
        } else if (val instanceof Long) {
            v = LongConstant.getInstance((Long)val);
        } else if (val instanceof Double) {
            v = DoubleConstant.getInstance((Double)val);
        } else if (val instanceof String) {
            v = JavaJimple.getInstance().newStringConstant(val.toString());
        } else if (val instanceof org.objectweb.asm.Type) {
            org.objectweb.asm.Type t = (org.objectweb.asm.Type)val;
            if (t.getSort() == 11) {
                List<Type> paramTypes = AsmUtil.toJimpleSignatureDesc(((org.objectweb.asm.Type)val).getDescriptor());
                Type returnType = paramTypes.remove(paramTypes.size() - 1);
                v = JavaJimple.getInstance().newMethodType(paramTypes, returnType);
            } else {
                v = JavaJimple.getInstance().newClassConstant(((org.objectweb.asm.Type)val).getDescriptor());
            }
        } else if (val instanceof Handle) {
            Handle h2 = (Handle)val;
            v = MethodHandle.isMethodRef(h2.getTag()) ? JavaJimple.getInstance().newMethodHandle(this.toMethodSignature((Handle)val), ((Handle)val).getTag()) : JavaJimple.getInstance().newMethodHandle(this.toSootFieldRef((Handle)val), ((Handle)val).getTag());
        } else {
            throw new UnsupportedOperationException("Unknown constant type: " + val.getClass());
        }
        return v;
    }

    private JFieldRef toSootFieldRef(Handle methodHandle) {
        String bsmClsName = AsmUtil.toQualifiedName(methodHandle.getOwner());
        JavaClassType bsmCls = this.javaIdentifierFactory.getClassType(bsmClsName);
        Type t = AsmUtil.toJimpleSignatureDesc(methodHandle.getDesc()).get(0);
        int kind = methodHandle.getTag();
        FieldSignature fieldSignature = this.javaIdentifierFactory.getFieldSignature(methodHandle.getName(), (ClassType)bsmCls, t);
        if (kind == MethodHandle.Kind.REF_GET_FIELD_STATIC.getValue() || kind == MethodHandle.Kind.REF_PUT_FIELD_STATIC.getValue()) {
            return Jimple.newStaticFieldRef(fieldSignature);
        }
        Operand base = this.operandStack.popLocal();
        return Jimple.newInstanceFieldRef((Local)base.stackOrValue(), fieldSignature);
    }

    private MethodSignature toMethodSignature(Handle methodHandle) {
        String bsmClsName = AsmUtil.toQualifiedName(methodHandle.getOwner());
        JavaClassType bsmCls = this.javaIdentifierFactory.getClassType(bsmClsName);
        List<Type> bsmSigTypes = AsmUtil.toJimpleSignatureDesc(methodHandle.getDesc());
        Type returnType = bsmSigTypes.remove(bsmSigTypes.size() - 1);
        return JavaIdentifierFactory.getInstance().getMethodSignature((ClassType)bsmCls, methodHandle.getName(), returnType, bsmSigTypes);
    }

    private void convertLookupSwitchInsn(@Nonnull LookupSwitchInsnNode insn) {
        StackFrame frame = this.operandStack.getOrCreateStackframe(insn);
        if (this.insnToStmt.containsKey(insn)) {
            frame.mergeIn(this.operandStack.pop());
            return;
        }
        Operand key = this.operandStack.popImmediate();
        ArrayList<IntConstant> keys = new ArrayList<IntConstant>(insn.keys.size());
        for (Integer i : insn.keys) {
            keys.add(IntConstant.getInstance(i));
        }
        JSwitchStmt lookupSwitchStmt = Jimple.newLookupSwitchStmt((Immediate)key.stackOrValue(), keys, new StmtPositionInfo(this.currentLineNumber));
        this.stmtsThatBranchToLabel.putAll((Object)lookupSwitchStmt, insn.labels);
        this.stmtsThatBranchToLabel.put(lookupSwitchStmt, insn.dflt);
        frame.setIn(key);
        this.setStmt(insn, lookupSwitchStmt);
        key.addUsageInStmt(lookupSwitchStmt);
    }

    private void convertMethodInsn(@Nonnull MethodInsnNode insn) {
        Operand opr;
        Type returnType;
        int op = insn.getOpcode();
        boolean isInstance = op != 184;
        StackFrame frame = this.operandStack.getOrCreateStackframe(insn);
        Operand[] out = frame.getOut();
        if (out == null) {
            AbstractInvokeExpr invoke;
            Operand[] args;
            String clsName = AsmUtil.toQualifiedName(insn.owner);
            if (clsName.charAt(0) == '[') {
                clsName = "java.lang.Object";
            }
            JavaClassType cls = this.javaIdentifierFactory.getClassType(AsmUtil.toQualifiedName(clsName));
            List<Type> sigTypes = AsmUtil.toJimpleSignatureDesc(insn.desc);
            returnType = sigTypes.remove(sigTypes.size() - 1);
            MethodSignature methodSignature = this.javaIdentifierFactory.getMethodSignature((ClassType)cls, insn.name, returnType, sigTypes);
            int nrArgs = sigTypes.size();
            List<Immediate> argList = Collections.emptyList();
            if (!isInstance) {
                Operand[] operandArray = args = nrArgs == 0 ? null : new Operand[nrArgs];
                if (args != null) {
                    argList = new ArrayList(nrArgs);
                }
            } else {
                args = new Operand[nrArgs + 1];
                if (nrArgs != 0) {
                    argList = new ArrayList(nrArgs);
                }
            }
            while (nrArgs-- != 0) {
                args[nrArgs] = this.operandStack.popImmediate(sigTypes.get(nrArgs));
                argList.add((Immediate)args[nrArgs].stackOrValue());
            }
            if (argList.size() > 1) {
                Collections.reverse(argList);
            }
            if (isInstance) {
                args[args.length - 1] = this.operandStack.popLocal();
            }
            if (!isInstance) {
                invoke = Jimple.newStaticInvokeExpr(methodSignature, argList);
            } else {
                AbstractInstanceInvokeExpr iinvoke;
                Operand baseOperand = args[args.length - 1];
                Local base = (Local)baseOperand.stackOrValue();
                switch (op) {
                    case 183: {
                        iinvoke = Jimple.newSpecialInvokeExpr(base, methodSignature, argList);
                        break;
                    }
                    case 182: {
                        iinvoke = Jimple.newVirtualInvokeExpr(base, methodSignature, argList);
                        break;
                    }
                    case 185: {
                        iinvoke = Jimple.newInterfaceInvokeExpr(base, methodSignature, argList);
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException("Unknown invoke op:" + op);
                    }
                }
                invoke = iinvoke;
                baseOperand.addUsageInExpr(invoke);
            }
            if (args != null) {
                for (int i = 0; i < sigTypes.size(); ++i) {
                    args[i].addUsageInExpr(invoke);
                }
                frame.setIn(args);
            }
            opr = new Operand(insn, invoke, this);
            frame.setOut(opr);
        } else {
            opr = out[0];
            AbstractInvokeExpr expr = (AbstractInvokeExpr)opr.value;
            List<Type> types = expr.getMethodSignature().getParameterTypes();
            int nrArgs = types.size();
            boolean isInstanceMethod = expr instanceof AbstractInstanceInvokeExpr;
            Operand[] oprs = !isInstanceMethod ? (nrArgs == 0 ? null : new Operand[nrArgs]) : new Operand[nrArgs + 1];
            if (oprs != null) {
                while (nrArgs-- != 0) {
                    oprs[nrArgs] = this.operandStack.pop(types.get(nrArgs));
                }
                if (isInstanceMethod) {
                    oprs[oprs.length - 1] = this.operandStack.pop();
                }
                frame.mergeIn(oprs);
            }
            returnType = expr.getMethodSignature().getType();
        }
        if (AsmUtil.isDWord(returnType)) {
            this.operandStack.pushDual(opr);
        } else if (returnType != VoidType.getInstance()) {
            this.operandStack.push(opr);
        } else if (!this.insnToStmt.containsKey(insn)) {
            JInvokeStmt stmt = Jimple.newInvokeStmt((AbstractInvokeExpr)opr.value, new StmtPositionInfo(this.currentLineNumber));
            this.setStmt(insn, stmt);
            opr.addUsageInStmt(stmt);
        }
        this.addReadOperandAssignments();
    }

    private void convertInvokeDynamicInsn(@Nonnull InvokeDynamicInsnNode insn) {
        Operand opr;
        Type returnType;
        StackFrame frame = this.operandStack.getOrCreateStackframe(insn);
        Operand[] out = frame.getOut();
        if (out == null) {
            MethodSignature bsmMethodRef = this.toMethodSignature(insn.bsm);
            ArrayList<Immediate> bsmMethodArgs = new ArrayList<Immediate>(insn.bsmArgs.length);
            for (Object bsmArg : insn.bsmArgs) {
                bsmMethodArgs.add(this.toSootValue(bsmArg));
            }
            JavaClassType bclass = this.javaIdentifierFactory.getClassType("sootup.dummy.InvokeDynamic");
            List<Type> types = AsmUtil.toJimpleSignatureDesc(insn.desc);
            int nrArgs = types.size() - 1;
            ArrayList<Type> parameterTypes = new ArrayList<Type>(nrArgs);
            ArrayList<Immediate> methodArgs = new ArrayList<Immediate>(nrArgs);
            Operand[] args = new Operand[nrArgs];
            for (int i = nrArgs - 1; i >= 0; --i) {
                parameterTypes.add(types.get(i));
                args[i] = this.operandStack.popImmediate(types.get(i));
                methodArgs.add((Immediate)args[i].stackOrValue());
            }
            if (methodArgs.size() > 1) {
                Collections.reverse(methodArgs);
                Collections.reverse(parameterTypes);
            }
            returnType = types.get(types.size() - 1);
            MethodSignature methodSig = this.javaIdentifierFactory.getMethodSignature((ClassType)bclass, insn.name, returnType, parameterTypes);
            JDynamicInvokeExpr indy = Jimple.newDynamicInvokeExpr(bsmMethodRef, bsmMethodArgs, methodSig, insn.bsm.getTag(), methodArgs);
            for (int i = 0; i < types.size() - 1; ++i) {
                args[i].addUsageInExpr(indy);
            }
            frame.setIn(args);
            opr = new Operand(insn, indy, this);
            frame.setOut(opr);
        } else {
            Operand[] oprs;
            opr = out[0];
            AbstractInvokeExpr expr = (AbstractInvokeExpr)opr.value;
            List<Type> types = expr.getMethodSignature().getParameterTypes();
            int nrArgs = types.size() - 1;
            boolean isStaticInvokeExpr = expr instanceof JStaticInvokeExpr;
            if (isStaticInvokeExpr) {
                oprs = nrArgs <= 0 ? null : new Operand[nrArgs];
            } else {
                Operand[] operandArray = oprs = nrArgs < 0 ? null : new Operand[nrArgs + 1];
            }
            if (oprs != null) {
                while (nrArgs-- > 0) {
                    oprs[nrArgs] = this.operandStack.pop(types.get(nrArgs));
                }
                if (!isStaticInvokeExpr) {
                    oprs[oprs.length - 1] = this.operandStack.pop();
                }
                frame.mergeIn(oprs);
            }
            returnType = expr.getType();
        }
        if (AsmUtil.isDWord(returnType)) {
            this.operandStack.pushDual(opr);
        } else if (!(returnType instanceof VoidType)) {
            this.operandStack.push(opr);
        } else if (!this.insnToStmt.containsKey(insn)) {
            JInvokeStmt stmt = Jimple.newInvokeStmt((AbstractInvokeExpr)opr.value, new StmtPositionInfo(this.currentLineNumber));
            this.setStmt(insn, stmt);
            opr.addUsageInStmt(stmt);
        }
        this.addReadOperandAssignments();
    }

    private void convertMultiANewArrayInsn(@Nonnull MultiANewArrayInsnNode insn) {
        Operand opr;
        StackFrame frame = this.operandStack.getOrCreateStackframe(insn);
        Operand[] out = frame.getOut();
        if (out == null) {
            ArrayType t = (ArrayType)AsmUtil.toJimpleType(insn.desc);
            int dims = insn.dims;
            Operand[] sizes = new Operand[dims];
            Immediate[] sizeVals = new Immediate[dims];
            while (dims-- != 0) {
                sizes[dims] = this.operandStack.popImmediate();
                sizeVals[dims] = (Immediate)sizes[dims].stackOrValue();
            }
            JNewMultiArrayExpr nm = Jimple.newNewMultiArrayExpr(t, Arrays.asList(sizeVals));
            for (int i = 0; i < dims; ++i) {
                sizes[i].addUsageInExpr(nm);
            }
            frame.setIn(sizes);
            opr = new Operand(insn, nm, this);
            frame.setOut(opr);
        } else {
            opr = out[0];
            int dims = insn.dims;
            Operand[] sizes = new Operand[dims];
            while (dims-- != 0) {
                sizes[dims] = this.operandStack.pop();
            }
            frame.mergeIn(sizes);
        }
        this.operandStack.push(opr);
    }

    private void convertTableSwitchInsn(@Nonnull TableSwitchInsnNode insn) {
        StackFrame frame = this.operandStack.getOrCreateStackframe(insn);
        if (this.insnToStmt.containsKey(insn)) {
            frame.mergeIn(this.operandStack.pop());
            return;
        }
        Operand key = this.operandStack.popImmediate();
        JSwitchStmt tableSwitchStmt = Jimple.newTableSwitchStmt((Immediate)key.stackOrValue(), insn.min, insn.max, new StmtPositionInfo(this.currentLineNumber));
        this.stmtsThatBranchToLabel.putAll((Object)tableSwitchStmt, insn.labels);
        this.stmtsThatBranchToLabel.put(tableSwitchStmt, insn.dflt);
        frame.setIn(key);
        this.setStmt(insn, tableSwitchStmt);
        key.addUsageInStmt(tableSwitchStmt);
    }

    private void convertTypeInsn(@Nonnull TypeInsnNode insn) {
        Operand opr;
        int op = insn.getOpcode();
        StackFrame frame = this.operandStack.getOrCreateStackframe(insn);
        Operand[] out = frame.getOut();
        if (out == null) {
            Expr val;
            JavaClassType t = AsmUtil.toJimpleClassType(insn.desc);
            if (op == 187) {
                val = Jimple.newNewExpr(t);
            } else {
                Operand op1 = this.operandStack.popImmediate();
                Value v1 = op1.stackOrValue();
                switch (op) {
                    case 189: {
                        JNewArrayExpr expr = JavaJimple.getInstance().newNewArrayExpr(t, (Immediate)v1);
                        val = expr;
                        op1.addUsageInExpr(expr);
                        break;
                    }
                    case 192: {
                        JCastExpr expr = Jimple.newCastExpr((Immediate)v1, t);
                        val = expr;
                        op1.addUsageInExpr(expr);
                        break;
                    }
                    case 193: {
                        JInstanceOfExpr expr = Jimple.newInstanceOfExpr((Immediate)v1, t);
                        val = expr;
                        op1.addUsageInExpr(expr);
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException("Unknown type op: " + op);
                    }
                }
                op1.addUsageInExpr(val);
                frame.setIn(op1);
            }
            opr = new Operand(insn, val, this);
            frame.setOut(opr);
        } else {
            opr = out[0];
            if (op != 187) {
                frame.mergeIn(this.operandStack.pop());
            }
        }
        this.operandStack.push(opr);
    }

    private void convertVarLoadInsn(@Nonnull VarInsnNode insn) {
        Operand opr;
        int op = insn.getOpcode();
        boolean dword = op == 22 || op == 24;
        StackFrame frame = this.operandStack.getOrCreateStackframe(insn);
        Operand[] out = frame.getOut();
        if (out == null) {
            opr = new Operand(insn, this.getOrCreateLocal(insn.var), this);
            frame.setOut(opr);
        } else {
            opr = out[0];
        }
        if (dword) {
            this.operandStack.pushDual(opr);
        } else {
            this.operandStack.push(opr);
        }
    }

    private void convertVarStoreInsn(@Nonnull VarInsnNode insn) {
        int op = insn.getOpcode();
        boolean dword = op == 55 || op == 57;
        StackFrame frame = this.operandStack.getOrCreateStackframe(insn);
        Operand opr = dword ? this.operandStack.popDual() : this.operandStack.pop();
        JavaLocal local = this.getOrCreateLocal(insn.var);
        if (!this.insnToStmt.containsKey(insn)) {
            JAssignStmt<JavaLocal, Value> as = Jimple.newAssignStmt(local, opr.stackOrValue(), new StmtPositionInfo(this.currentLineNumber));
            frame.setIn(opr);
            this.setStmt(insn, as);
            opr.addUsageInStmt(as);
        } else {
            frame.mergeIn(opr);
        }
        this.addReadOperandAssignments(local);
    }

    private void convertVarInsn(@Nonnull VarInsnNode insn) {
        int op = insn.getOpcode();
        if (op >= 21 && op <= 25) {
            this.convertVarLoadInsn(insn);
        } else if (op >= 54 && op <= 58) {
            this.convertVarStoreInsn(insn);
        } else if (op == 169) {
            if (!this.insnToStmt.containsKey(insn)) {
                this.setStmt(insn, Jimple.newRetStmt(this.getOrCreateLocal(insn.var), new StmtPositionInfo(this.currentLineNumber)));
            }
        } else {
            throw new UnsupportedOperationException("Unknown var op: " + op);
        }
    }

    private void convertLabel(@Nonnull LabelNode ln) {
        Operand opr;
        if (!this.trapHandler.containsKey(ln)) {
            return;
        }
        if (this.inlineExceptionLabels.contains(ln)) {
            if (!this.insnToStmt.containsKey(ln)) {
                JNopStmt nop = Jimple.newNopStmt(new StmtPositionInfo(this.currentLineNumber));
                this.setStmt(ln, nop);
            }
            return;
        }
        StackFrame frame = this.operandStack.getOrCreateStackframe(ln);
        Operand[] out = frame.getOut();
        if (out == null) {
            JCaughtExceptionRef ref = JavaJimple.getInstance().newCaughtExceptionRef();
            Local stack = this.newStackLocal();
            JIdentityStmt<JCaughtExceptionRef> as = Jimple.newIdentityStmt(stack, ref, new StmtPositionInfo(this.currentLineNumber));
            opr = new Operand(ln, ref, this);
            opr.stackLocal = stack;
            frame.setOut(opr);
            this.setStmt(ln, as);
            opr.addUsageInStmt(as);
        } else {
            opr = out[0];
        }
        this.operandStack.push(opr);
    }

    private void convertLine(@Nonnull LineNumberNode ln) {
        this.currentLineNumber = ln.line;
        if (this.currentLineNumber > this.maxLineNumber) {
            this.maxLineNumber = this.currentLineNumber;
        }
    }

    private void addEdges(@Nonnull Table<AbstractInsnNode, AbstractInsnNode, BranchedInsnInfo> edges, @Nonnull ArrayDeque<BranchedInsnInfo> conversionWorklist, @Nonnull AbstractInsnNode branchingInsn, @Nonnull AbstractInsnNode tgt, @Nonnull List<LabelNode> tgts) {
        Object[] stackss = this.operandStack.getStack().toArray(new Operand[0]);
        int i = 0;
        int lastIdx = tgts.size();
        block0: do {
            BranchedInsnInfo edge;
            if ((edge = edges.get(branchingInsn, tgt)) == null) {
                edge = new BranchedInsnInfo(tgt, this.operandStack.getStack());
                edge.addToPrevStack((Operand[])stackss);
                edges.put(branchingInsn, tgt, edge);
                conversionWorklist.add(edge);
                continue;
            }
            for (List<Operand> stackTemp : edge.getOperandStacks()) {
                int n;
                if (stackTemp.size() != stackss.length) continue;
                for (n = 0; n < stackss.length && stackTemp.get(n).equivTo((Operand)stackss[n]); ++n) {
                }
                if (n != stackss.length) continue;
                continue block0;
            }
            LinkedList<Operand[]> prevStacks = edge.getPrevStacks();
            for (Object[] objectArray : prevStacks) {
                if (!Arrays.equals(objectArray, stackss)) continue;
                continue block0;
            }
            edge.addOperandStack(this.operandStack.getStack());
            edge.addToPrevStack((Operand[])stackss);
            conversionWorklist.add(edge);
        } while (i < lastIdx && (tgt = (AbstractInsnNode)tgts.get(i++)) != null);
    }

    private void convert() {
        ArrayDeque<BranchedInsnInfo> worklist = new ArrayDeque<BranchedInsnInfo>();
        this.indexInlineExceptionHandlers();
        for (LabelNode handlerNode : this.trapHandler.keySet()) {
            if (this.inlineExceptionLabels.contains(handlerNode)) {
                JCaughtExceptionRef ref = JavaJimple.getInstance().newCaughtExceptionRef();
                Local local = this.newStackLocal();
                JIdentityStmt<JCaughtExceptionRef> as = Jimple.newIdentityStmt(local, ref, StmtPositionInfo.createNoStmtPositionInfo());
                Operand opr = new Operand(handlerNode, ref, this);
                opr.stackLocal = local;
                worklist.add(new BranchedInsnInfo(handlerNode, Collections.singletonList(opr)));
                this.inlineExceptionHandlers.put(handlerNode, as);
                continue;
            }
            worklist.add(new BranchedInsnInfo(handlerNode, new ArrayList<Operand>()));
        }
        worklist.add(new BranchedInsnInfo(this.instructions.getFirst(), Collections.emptyList()));
        HashBasedTable<AbstractInsnNode, AbstractInsnNode, BranchedInsnInfo> edges = HashBasedTable.create(1, 1);
        block1: do {
            BranchedInsnInfo edge = (BranchedInsnInfo)worklist.pollLast();
            AbstractInsnNode insn = edge.getInsn();
            this.operandStack.setOperandStack(new ArrayList<Operand>((Collection)edge.getOperandStacks().get(edge.getOperandStacks().size() - 1)));
            do {
                int type;
                if ((type = insn.getType()) == 4) {
                    this.convertFieldInsn((FieldInsnNode)insn);
                    continue;
                }
                if (type == 10) {
                    this.convertIincInsn((IincInsnNode)insn);
                    continue;
                }
                if (type == 0) {
                    this.convertInsn((InsnNode)insn);
                    int op = insn.getOpcode();
                    if ((op < 172 || op > 177) && op != 191) continue;
                    continue block1;
                }
                if (type == 1) {
                    this.convertIntInsn((IntInsnNode)insn);
                    continue;
                }
                if (type == 9) {
                    this.convertLdcInsn((LdcInsnNode)insn);
                    continue;
                }
                if (type == 7) {
                    JumpInsnNode jmp = (JumpInsnNode)insn;
                    this.convertJumpInsn(jmp);
                    int op = jmp.getOpcode();
                    if (op == 168) {
                        throw new UnsupportedOperationException("JSR!");
                    }
                    if (op != 167) {
                        AbstractInsnNode next = insn.getNext();
                        this.addEdges(edges, worklist, insn, next, Collections.singletonList(jmp.label));
                        continue block1;
                    }
                    this.addEdges(edges, worklist, insn, jmp.label, Collections.emptyList());
                    continue block1;
                }
                if (type == 12) {
                    LookupSwitchInsnNode swtch = (LookupSwitchInsnNode)insn;
                    this.convertLookupSwitchInsn(swtch);
                    LabelNode dflt = swtch.dflt;
                    this.addEdges(edges, worklist, insn, dflt, swtch.labels);
                    continue block1;
                }
                if (type == 5) {
                    this.convertMethodInsn((MethodInsnNode)insn);
                    continue;
                }
                if (type == 6) {
                    this.convertInvokeDynamicInsn((InvokeDynamicInsnNode)insn);
                    continue;
                }
                if (type == 13) {
                    this.convertMultiANewArrayInsn((MultiANewArrayInsnNode)insn);
                    continue;
                }
                if (type == 11) {
                    TableSwitchInsnNode swtch = (TableSwitchInsnNode)insn;
                    this.convertTableSwitchInsn(swtch);
                    LabelNode dflt = swtch.dflt;
                    this.addEdges(edges, worklist, insn, dflt, swtch.labels);
                    continue block1;
                }
                if (type == 3) {
                    this.convertTypeInsn((TypeInsnNode)insn);
                    continue;
                }
                if (type == 2) {
                    if (insn.getOpcode() == 169) {
                        throw new UnsupportedOperationException("RET!");
                    }
                    this.convertVarInsn((VarInsnNode)insn);
                    continue;
                }
                if (type == 8) {
                    this.convertLabel((LabelNode)insn);
                    continue;
                }
                if (type == 15) {
                    this.convertLine((LineNumberNode)insn);
                    continue;
                }
                if (type == 14) continue;
                throw new RuntimeException("Unknown instruction type: " + type);
            } while ((insn = insn.getNext()) != null);
        } while (!worklist.isEmpty());
    }

    private void indexInlineExceptionHandlers() {
        Set<LabelNode> handlerLabelNodes = this.trapHandler.keySet();
        if (handlerLabelNodes.isEmpty()) {
            return;
        }
        block0: for (AbstractInsnNode node : this.instructions) {
            if (node instanceof JumpInsnNode) {
                LabelNode handlerLabel = ((JumpInsnNode)node).label;
                if (!handlerLabelNodes.contains(handlerLabel)) continue;
                this.inlineExceptionLabels.add(handlerLabel);
                continue;
            }
            if (node instanceof LookupSwitchInsnNode) {
                LookupSwitchInsnNode lookupSwitchInsnNode = (LookupSwitchInsnNode)node;
                if (handlerLabelNodes.contains(lookupSwitchInsnNode.dflt)) {
                    this.inlineExceptionLabels.add(lookupSwitchInsnNode.dflt);
                    continue;
                }
                for (LabelNode l : lookupSwitchInsnNode.labels) {
                    if (!handlerLabelNodes.contains(l)) continue;
                    this.inlineExceptionLabels.add(l);
                    continue block0;
                }
                continue;
            }
            if (!(node instanceof TableSwitchInsnNode)) continue;
            TableSwitchInsnNode tableSwitchInsnNode = (TableSwitchInsnNode)node;
            if (handlerLabelNodes.contains(tableSwitchInsnNode.dflt)) {
                this.inlineExceptionLabels.add(tableSwitchInsnNode.dflt);
                continue;
            }
            for (LabelNode l : tableSwitchInsnNode.labels) {
                if (!handlerLabelNodes.contains(l)) continue;
                this.inlineExceptionLabels.add(l);
                continue block0;
            }
        }
    }

    @Nonnull
    private List<Stmt> buildPreambleLocals(Body.BodyBuilder bodyBuilder) {
        ArrayList<Stmt> preambleBlock = new ArrayList<Stmt>();
        MethodSignature methodSignature = this.lazyMethodSignature.get();
        int localIdx = 0;
        if (!bodyBuilder.getModifiers().contains((Object)Modifier.STATIC)) {
            JavaLocal l = this.getOrCreateLocal(localIdx++);
            JIdentityStmt<JThisRef> stmt = Jimple.newIdentityStmt(l, Jimple.newThisRef(this.declaringClass), new StmtPositionInfo(this.currentLineNumber));
            preambleBlock.add(stmt);
        }
        for (int i = 0; i < methodSignature.getParameterTypes().size(); ++i) {
            Type parameterType = methodSignature.getParameterTypes().get(i);
            JavaLocal local = JavaJimple.newLocal(this.determineLocalName(localIdx), UnknownType.getInstance(), AsmUtil.createAnnotationUsage(this.invisibleParameterAnnotations == null ? null : this.invisibleParameterAnnotations[i]));
            this.locals.set(localIdx, local);
            JIdentityStmt<JParameterRef> stmt = Jimple.newIdentityStmt(local, Jimple.newParameterRef(parameterType, i), StmtPositionInfo.createNoStmtPositionInfo());
            preambleBlock.add(stmt);
            if (AsmUtil.isDWord(parameterType)) {
                localIdx += 2;
                continue;
            }
            ++localIdx;
        }
        LinkedHashSet<Local> bodyLocals = new LinkedHashSet<Local>(this.locals);
        bodyBuilder.setLocals(bodyLocals);
        return preambleBlock;
    }

    private List<Trap> buildTraps() {
        ArrayList<Trap> traps = new ArrayList<Trap>();
        for (TryCatchBlockNode trycatch : this.tryCatchBlocks) {
            Stmt handler = this.trapHandler.get(trycatch.handler);
            if (handler == null) {
                throw new IllegalStateException("Label for the TrapHandler " + trycatch.handler + " has no associated Stmt to jump to.");
            }
            String exceptionName = trycatch.type != null ? AsmUtil.toQualifiedName(trycatch.type) : "java.lang.Throwable";
            JavaClassType exceptionType = this.javaIdentifierFactory.getClassType(exceptionName);
            Trap trap = Jimple.newTrap(exceptionType, this.labelsToStmt.get(trycatch.start), this.labelsToStmt.get(trycatch.end), handler);
            traps.add(trap);
        }
        return traps;
    }

    private void arrangeStmts(MutableBlockStmtGraph graph, Body.BodyBuilder builder) {
        AbstractInsnNode insn = this.instructions.getFirst();
        ArrayDeque<LabelNode> danglingLabel = new ArrayDeque<LabelNode>();
        HashMap<ClassType, Stmt> currentTraps = new HashMap<ClassType, Stmt>();
        List<Stmt> stmtList = this.buildPreambleLocals(builder);
        do {
            Object stmt;
            boolean isLabelNode;
            if (isLabelNode = insn instanceof LabelNode) {
                danglingLabel.add((LabelNode)insn);
            }
            if ((stmt = this.insnToStmt.get(insn)) == null) continue;
            if (!danglingLabel.isEmpty()) {
                JIdentityStmt<?> identityRef;
                Stmt stmt2 = stmt instanceof StmtContainer ? ((StmtContainer)stmt).getFirstStmt() : stmt;
                danglingLabel.forEach(l -> this.labelsToStmt.put((LabelNode)l, targetStmt));
                if (isLabelNode && (identityRef = this.findIdentityRefInStmtContainer((Stmt)stmt)) != null && identityRef.getRightOp() instanceof JCaughtExceptionRef) {
                    danglingLabel.forEach(label -> this.trapHandler.put((LabelNode)label, identityRef));
                }
                danglingLabel.clear();
            }
            this.emitStmt((Stmt)stmt, stmtList);
        } while ((insn = insn.getNext()) != null);
        HashMap<BranchingStmt, List<Stmt>> branchingMap = new HashMap<BranchingStmt, List<Stmt>>();
        for (Map.Entry entry : this.stmtsThatBranchToLabel.asMap().entrySet()) {
            BranchingStmt fromStmt = (BranchingStmt)entry.getKey();
            ArrayList<Stmt> targets = new ArrayList<Stmt>();
            for (LabelNode labelNode : (Collection)entry.getValue()) {
                Stmt targetStmt = this.labelsToStmt.get(labelNode);
                if (targetStmt == null) {
                    throw new IllegalStateException("targetStmt not found for fromStmt" + fromStmt + " " + entry.getValue() + " in method " + this.lazyMethodSignature.get());
                }
                targets.add(targetStmt);
            }
            branchingMap.put(fromStmt, targets);
        }
        List<Trap> traps = this.buildTraps();
        graph.initializeWith(stmtList, branchingMap, traps);
        for (LabelNode ln : this.inlineExceptionHandlers.keySet()) {
            Stmt handlerStmt = this.inlineExceptionHandlers.get(ln);
            this.emitStmt(handlerStmt, stmtList);
            this.trapHandler.put(ln, handlerStmt);
            JGotoStmt gotoStmt = Jimple.newGotoStmt(StmtPositionInfo.createNoStmtPositionInfo());
            stmtList.add(gotoStmt);
            graph.addBlock(stmtList, currentTraps);
            stmtList.clear();
            Stmt targetStmt = this.insnToStmt.get(ln);
            graph.putEdge(gotoStmt, targetStmt);
        }
    }

    private void emitStmt(@Nonnull Stmt handlerStmt, @Nonnull List<Stmt> block) {
        if (handlerStmt instanceof StmtContainer) {
            block.addAll(((StmtContainer)handlerStmt).getStmts());
        } else {
            block.add(handlerStmt);
        }
    }

    @Nullable
    private JIdentityStmt<?> findIdentityRefInStmtContainer(@Nonnull Stmt stmt) {
        if (stmt instanceof JIdentityStmt) {
            return (JIdentityStmt)stmt;
        }
        if (stmt instanceof StmtContainer) {
            for (Stmt stmtEntry : ((StmtContainer)stmt).getStmts()) {
                if (!(stmtEntry instanceof JIdentityStmt)) continue;
                return (JIdentityStmt)stmtEntry;
            }
        }
        return null;
    }

    @Nonnull
    Stmt getLatestVersionOfStmt(@Nonnull Stmt oldStmt) {
        Stmt replacedVersion;
        while ((replacedVersion = this.replacedStmt.get(oldStmt)) != null) {
            oldStmt = replacedVersion;
        }
        return oldStmt;
    }

    void replaceStmt(@Nonnull Stmt oldStmt, Stmt newStmt) {
        Collection branchLabels;
        AbstractInsnNode key = null;
        for (Map.Entry<AbstractInsnNode, Stmt> entry : this.insnToStmt.entrySet()) {
            if (!Objects.equals(oldStmt, entry.getValue())) continue;
            key = entry.getKey();
        }
        if (key == null) {
            return;
        }
        if (newStmt == null) {
            this.insnToStmt.remove(key);
            return;
        }
        this.insnToStmt.put(key, newStmt);
        this.replacedStmt.put(oldStmt, newStmt);
        if (oldStmt instanceof BranchingStmt && (branchLabels = this.stmtsThatBranchToLabel.get((Object)((BranchingStmt)oldStmt))) != null) {
            branchLabels.forEach(bl -> this.stmtsThatBranchToLabel.put((BranchingStmt)newStmt, (LabelNode)bl));
            this.stmtsThatBranchToLabel.removeAll(oldStmt);
        }
    }

    public Stream<Stmt> getStmtsThatUse(@Nonnull Expr expr) {
        Stream<Stmt> currentUses = this.insnToStmt.values().stream().flatMap(stmt -> stmt instanceof StmtContainer ? ((StmtContainer)stmt).getStmts().stream() : Stream.of(stmt)).filter(stmt -> stmt.getUses().contains(expr));
        Stream<Stmt> oldMappedUses = this.replacedStmt.entrySet().stream().filter(stmt -> ((Stmt)stmt.getKey()).getUses().contains(expr)).map(stmt -> this.getLatestVersionOfStmt((Stmt)stmt.getValue()));
        return Stream.concat(currentUses, oldMappedUses);
    }
}

