/*
 * Decompiled with CFR 0.152.
 */
package sootup.java.bytecode.frontend;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.objectweb.asm.tree.AbstractInsnNode;
import sootup.java.bytecode.frontend.Operand;

class BranchedInsnInfo {
    @Nonnull
    private final AbstractInsnNode insn;
    @Nonnull
    private final LinkedList<Operand[]> prevStacks;
    @Nullable
    private final List<List<Operand>> operandStacks = new ArrayList<List<Operand>>();

    BranchedInsnInfo(@Nonnull AbstractInsnNode insn, @Nonnull List<Operand> operands) {
        this.insn = insn;
        this.prevStacks = new LinkedList();
        this.operandStacks.add(operands);
    }

    @Nonnull
    public AbstractInsnNode getInsn() {
        return this.insn;
    }

    @Nonnull
    public List<List<Operand>> getOperandStacks() {
        return this.operandStacks;
    }

    public void addOperandStack(@Nullable List<Operand> operandStack) {
        this.operandStacks.add(operandStack);
    }

    @Nonnull
    public LinkedList<Operand[]> getPrevStacks() {
        return this.prevStacks;
    }

    public void addToPrevStack(@Nonnull Operand[] stacksOperands) {
        this.prevStacks.add(stacksOperands);
    }
}

