/*
 * Decompiled with CFR 0.152.
 */
package sootup.java.bytecode.inputlocation;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NotDirectoryException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sootup.core.frontend.AbstractClassSource;
import sootup.core.inputlocation.AnalysisInputLocation;
import sootup.core.model.SourceType;
import sootup.core.types.ClassType;
import sootup.core.util.PathUtils;
import sootup.core.util.StreamUtils;
import sootup.core.views.View;
import sootup.java.bytecode.inputlocation.PathBasedAnalysisInputLocation;
import sootup.java.core.JavaSootClass;

public class JavaClassPathAnalysisInputLocation
implements AnalysisInputLocation<JavaSootClass> {
    @Nonnull
    private static final Logger logger = LoggerFactory.getLogger(JavaClassPathAnalysisInputLocation.class);
    @Nonnull
    private static final String WILDCARD_CHAR = "*";
    @Nonnull
    private final Collection<AnalysisInputLocation<JavaSootClass>> cpEntries;
    private SourceType srcType = null;

    public JavaClassPathAnalysisInputLocation(@Nonnull String classPath) {
        if (classPath.length() <= 0) {
            throw new IllegalStateException("Empty class path given");
        }
        this.cpEntries = this.explodeClassPath(classPath);
        if (this.cpEntries.isEmpty()) {
            throw new IllegalStateException("Empty class path is given.");
        }
    }

    public JavaClassPathAnalysisInputLocation(@Nonnull String classPath, @Nullable SourceType srcType) {
        if (classPath.length() <= 0) {
            throw new IllegalStateException("Empty class path given");
        }
        this.setSpecifiedAsBuiltInByUser(srcType);
        this.cpEntries = this.explodeClassPath(classPath);
        if (this.cpEntries.isEmpty()) {
            throw new IllegalStateException("Empty class path is given.");
        }
    }

    public void setSpecifiedAsBuiltInByUser(@Nullable SourceType srcType) {
        this.srcType = srcType;
    }

    @Override
    public SourceType getSourceType() {
        return this.srcType;
    }

    @Nonnull
    static Stream<Path> explode(@Nonnull String paths, FileSystem fileSystem) {
        String regex = "(?<!\\\\)" + Pattern.quote(File.pathSeparator);
        Stream<Path> exploded = Stream.of(paths.split(regex)).flatMap(e -> JavaClassPathAnalysisInputLocation.handleWildCards(e, fileSystem));
        return exploded.map(Path::normalize).distinct();
    }

    @Nonnull
    static Stream<Path> explode(@Nonnull String paths) {
        return JavaClassPathAnalysisInputLocation.explode(paths, FileSystems.getDefault());
    }

    @Nonnull
    private static Stream<Path> handleWildCards(@Nonnull String entry, FileSystem fileSystem) {
        if (entry.endsWith(WILDCARD_CHAR)) {
            Path baseDir = fileSystem.getPath(entry.substring(0, entry.indexOf(WILDCARD_CHAR)), new String[0]);
            try {
                return StreamUtils.iteratorToStream(Files.newDirectoryStream(baseDir, "*.{jar,JAR}").iterator());
            }
            catch (NotDirectoryException | PatternSyntaxException e) {
                throw new IllegalStateException("Malformed wildcard entry", e);
            }
            catch (IOException e) {
                throw new IllegalStateException("Couldn't access entries denoted by wildcard", e);
            }
        }
        return Stream.of(fileSystem.getPath(entry, new String[0]));
    }

    @Nonnull
    private static Stream<Path> handleWildCards(@Nonnull String entry) {
        return JavaClassPathAnalysisInputLocation.handleWildCards(entry, FileSystems.getDefault());
    }

    @Override
    @Nonnull
    public Collection<? extends AbstractClassSource<JavaSootClass>> getClassSources(@Nonnull View<?> view) {
        HashSet<AbstractClassSource<JavaSootClass>> found = new HashSet<AbstractClassSource<JavaSootClass>>();
        for (AnalysisInputLocation<JavaSootClass> inputLocation : this.cpEntries) {
            found.addAll(inputLocation.getClassSources(view));
        }
        return found;
    }

    @Override
    @Nonnull
    public Optional<? extends AbstractClassSource<JavaSootClass>> getClassSource(@Nonnull ClassType type, @Nonnull View<?> view) {
        for (AnalysisInputLocation<JavaSootClass> inputLocation : this.cpEntries) {
            Optional<AbstractClassSource<JavaSootClass>> classSource = inputLocation.getClassSource(type, view);
            if (!classSource.isPresent()) continue;
            return classSource;
        }
        return Optional.empty();
    }

    @Nonnull
    private Optional<AnalysisInputLocation<JavaSootClass>> inputLocationForPath(@Nonnull Path path) {
        if (Files.exists(path, new LinkOption[0]) && (Files.isDirectory(path, new LinkOption[0]) || PathUtils.isArchive(path))) {
            return Optional.of(new PathBasedAnalysisInputLocation(path, this.srcType));
        }
        logger.warn("Invalid/Unknown class path entry: " + path);
        return Optional.empty();
    }

    private List<AnalysisInputLocation<JavaSootClass>> explodeClassPath(@Nonnull String jarPath) {
        return this.explodeClassPath(jarPath, FileSystems.getDefault());
    }

    private List<AnalysisInputLocation<JavaSootClass>> explodeClassPath(@Nonnull String jarPath, @Nonnull FileSystem fileSystem) {
        try {
            return JavaClassPathAnalysisInputLocation.explode(jarPath, fileSystem).flatMap(cp -> StreamUtils.optionalToStream(this.inputLocationForPath((Path)cp))).collect(Collectors.toList());
        }
        catch (IllegalArgumentException e) {
            throw new IllegalStateException("Malformed class path given: " + jarPath, e);
        }
    }

    public int hashCode() {
        return this.cpEntries.hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof JavaClassPathAnalysisInputLocation)) {
            return false;
        }
        return this.cpEntries.equals(((JavaClassPathAnalysisInputLocation)o).cpEntries);
    }
}

