/*
 * Decompiled with CFR 0.152.
 */
package sootup.java.bytecode.inputlocation;

import com.google.common.base.Preconditions;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import sootup.core.IdentifierFactory;
import sootup.core.frontend.AbstractClassSource;
import sootup.core.inputlocation.AnalysisInputLocation;
import sootup.core.types.ClassType;
import sootup.core.views.View;
import sootup.java.bytecode.inputlocation.ModuleFinder;
import sootup.java.core.JavaModuleIdentifierFactory;
import sootup.java.core.JavaModuleInfo;
import sootup.java.core.JavaSootClass;
import sootup.java.core.ModuleInfoAnalysisInputLocation;
import sootup.java.core.signatures.ModulePackageName;
import sootup.java.core.signatures.ModuleSignature;
import sootup.java.core.types.JavaClassType;

public class JavaModulePathAnalysisInputLocation
implements ModuleInfoAnalysisInputLocation {
    @Nonnull
    private final ModuleFinder moduleFinder;

    public JavaModulePathAnalysisInputLocation(@Nonnull String modulePath) {
        this(modulePath, FileSystems.getDefault());
    }

    public JavaModulePathAnalysisInputLocation(@Nonnull String modulePath, @Nonnull FileSystem fileSystem) {
        this.moduleFinder = new ModuleFinder(modulePath, fileSystem);
    }

    @Override
    @Nonnull
    public Optional<JavaModuleInfo> getModuleInfo(ModuleSignature sig, View<?> view) {
        return this.moduleFinder.getModuleInfo(sig);
    }

    @Override
    @Nonnull
    public Set<ModuleSignature> getModules(View<?> view) {
        return this.moduleFinder.getModules();
    }

    @Override
    @Nonnull
    public Collection<? extends AbstractClassSource<JavaSootClass>> getClassSources(@Nonnull View<?> view) {
        IdentifierFactory identifierFactory = view.getIdentifierFactory();
        Preconditions.checkArgument(identifierFactory instanceof JavaModuleIdentifierFactory, "Factory must be a JavaModuleSignatureFactory");
        Collection<ModuleSignature> allModules = this.moduleFinder.getAllModules();
        return allModules.stream().flatMap(sig -> this.getClassSourcesInternal((ModuleSignature)sig, view)).collect(Collectors.toList());
    }

    @Override
    @Nonnull
    public Collection<? extends AbstractClassSource<JavaSootClass>> getModulesClassSources(@Nonnull ModuleSignature moduleSignature, @Nonnull View<?> view) {
        IdentifierFactory identifierFactory = view.getIdentifierFactory();
        Preconditions.checkArgument(identifierFactory instanceof JavaModuleIdentifierFactory, "Factory must be a JavaModuleSignatureFactory");
        return this.getClassSourcesInternal(moduleSignature, view).collect(Collectors.toList());
    }

    protected Stream<? extends AbstractClassSource<JavaSootClass>> getClassSourcesInternal(@Nonnull ModuleSignature moduleSignature, @Nonnull View<?> view) {
        AnalysisInputLocation<JavaSootClass> inputLocation = this.moduleFinder.getModule(moduleSignature);
        if (inputLocation == null) {
            return Stream.empty();
        }
        return inputLocation.getClassSources(view).stream();
    }

    @Override
    @Nonnull
    public Optional<? extends AbstractClassSource<JavaSootClass>> getClassSource(@Nonnull ClassType classType, @Nonnull View<?> view) {
        JavaClassType klassType = (JavaClassType)classType;
        ModuleSignature modulename = ((ModulePackageName)klassType.getPackageName()).getModuleSignature();
        AnalysisInputLocation<JavaSootClass> inputLocation = this.moduleFinder.getModule(modulename);
        if (inputLocation == null) {
            return Optional.empty();
        }
        return inputLocation.getClassSource(klassType, view);
    }

    public int hashCode() {
        return this.moduleFinder.hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof JavaModulePathAnalysisInputLocation)) {
            return false;
        }
        return this.moduleFinder.equals(((JavaModulePathAnalysisInputLocation)o).moduleFinder);
    }
}

