/*
 * Decompiled with CFR 0.152.
 */
package sootup.java.bytecode.interceptors;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import sootup.core.graph.MutableStmtGraph;
import sootup.core.jimple.basic.Immediate;
import sootup.core.jimple.basic.Local;
import sootup.core.jimple.basic.Value;
import sootup.core.jimple.common.expr.AbstractBinopExpr;
import sootup.core.jimple.common.expr.AbstractInstanceInvokeExpr;
import sootup.core.jimple.common.ref.JArrayRef;
import sootup.core.jimple.common.ref.JFieldRef;
import sootup.core.jimple.common.stmt.AbstractDefinitionStmt;
import sootup.core.jimple.common.stmt.JAssignStmt;
import sootup.core.jimple.common.stmt.Stmt;
import sootup.core.model.Body;
import sootup.core.model.BodyUtils;
import sootup.core.transform.BodyInterceptor;

public class Aggregator
implements BodyInterceptor {
    boolean onlyStackVars;

    public Aggregator() {
        this(false);
    }

    public Aggregator(boolean onlyStackVars) {
        this.onlyStackVars = onlyStackVars;
    }

    @Override
    public void interceptBody(@Nonnull Body.BodyBuilder builder) {
        MutableStmtGraph graph = builder.getStmtGraph();
        List<Stmt> stmts = builder.getStmts();
        for (Stmt stmt : Lists.newArrayList(stmts)) {
            JAssignStmt assignStmt;
            Object lhs;
            if (!(stmt instanceof JAssignStmt) || !((lhs = (assignStmt = (JAssignStmt)stmt).getLeftOp()) instanceof Local)) continue;
            Local lhsLocal = (Local)lhs;
            if (this.onlyStackVars && !lhsLocal.getName().startsWith("$stack")) continue;
            for (Value val : assignStmt.getUses()) {
                List<AbstractDefinitionStmt> defs;
                if (!(val instanceof Local) || (defs = BodyUtils.getDefsOfLocal((Local)val, stmts)).size() != 1) continue;
                Stmt relevantDef = defs.get(0);
                List<Stmt> path = graph.getExtendedBasicBlockPathBetween(relevantDef, stmt);
                boolean cantAggr = false;
                boolean propagatingInvokeExpr = false;
                boolean propagatingFieldRef = false;
                boolean propagatingArrayRef = false;
                ArrayList<JFieldRef> fieldRefList = new ArrayList<JFieldRef>();
                ArrayList<Value> localsUsed = new ArrayList<Value>();
                for (Stmt pathStmt : path) {
                    Iterator<Value> allDefs = pathStmt.getDefs();
                    Iterator<Value> iterator = allDefs.iterator();
                    while (iterator.hasNext()) {
                        Value def = iterator.next();
                        if (def instanceof Local) {
                            localsUsed.add(def);
                            continue;
                        }
                        if (def instanceof AbstractInstanceInvokeExpr) {
                            propagatingInvokeExpr = true;
                            continue;
                        }
                        if (def instanceof JArrayRef) {
                            propagatingArrayRef = true;
                            continue;
                        }
                        if (!(def instanceof JFieldRef)) continue;
                        propagatingFieldRef = true;
                        fieldRefList.add((JFieldRef)def);
                    }
                }
                block4: for (Stmt pathStmt : path) {
                    if (pathStmt != stmt && pathStmt != relevantDef) {
                        block5: for (Value stmtDef : pathStmt.getDefs()) {
                            if (localsUsed.contains(stmtDef)) {
                                cantAggr = true;
                                break;
                            }
                            if (!propagatingInvokeExpr && !propagatingFieldRef && !propagatingArrayRef) continue;
                            if (stmtDef instanceof JFieldRef) {
                                if (propagatingInvokeExpr) {
                                    cantAggr = true;
                                    break;
                                }
                                if (!propagatingFieldRef) continue;
                                for (JFieldRef fieldRef : fieldRefList) {
                                    if (!fieldRef.equals((JFieldRef)stmtDef)) continue;
                                    cantAggr = true;
                                    continue block5;
                                }
                                continue;
                            }
                            if (!(stmtDef instanceof JArrayRef) || !propagatingInvokeExpr && !propagatingArrayRef) continue;
                            cantAggr = true;
                            break;
                        }
                    }
                    if (!propagatingInvokeExpr && !propagatingFieldRef && !propagatingArrayRef) continue;
                    for (Value value : stmt.getUses()) {
                        if (pathStmt == stmt && value == lhs) continue block4;
                        if (!(value instanceof AbstractInstanceInvokeExpr) && (!propagatingInvokeExpr || !(value instanceof JFieldRef) && !(value instanceof JArrayRef))) continue;
                        cantAggr = true;
                        continue block4;
                    }
                }
                if (cantAggr) continue;
                Object aggregatee = ((JAssignStmt)relevantDef).getRightOp();
                JAssignStmt newStmt = null;
                if (assignStmt.getRightOp() instanceof AbstractBinopExpr) {
                    AbstractBinopExpr newBinopExpr;
                    AbstractBinopExpr rightOp = (AbstractBinopExpr)assignStmt.getRightOp();
                    if (rightOp.getOp1() == val) {
                        newBinopExpr = rightOp.withOp1((Immediate)aggregatee);
                        newStmt = new JAssignStmt(assignStmt.getLeftOp(), newBinopExpr, assignStmt.getPositionInfo());
                    } else if (rightOp.getOp2() == val) {
                        newBinopExpr = rightOp.withOp2((Immediate)aggregatee);
                        newStmt = new JAssignStmt(assignStmt.getLeftOp(), newBinopExpr, assignStmt.getPositionInfo());
                    }
                } else {
                    newStmt = assignStmt.withRValue(aggregatee);
                }
                if (newStmt == null) continue;
                builder.replaceStmt(stmt, newStmt);
                if (graph.getStartingStmt() == relevantDef) {
                    Stmt newStartingStmt = builder.getStmtGraph().successors(relevantDef).get(0);
                    builder.setStartingStmt(newStartingStmt);
                }
                builder.removeStmt(relevantDef);
            }
        }
    }
}

