/*
 * Decompiled with CFR 0.152.
 */
package sootup.java.bytecode.interceptors;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import sootup.core.graph.MutableStmtGraph;
import sootup.core.jimple.basic.Local;
import sootup.core.jimple.basic.Value;
import sootup.core.jimple.common.stmt.Stmt;
import sootup.core.model.Body;
import sootup.core.model.BodyUtils;
import sootup.core.transform.BodyInterceptor;
import sootup.core.types.NullType;
import sootup.core.types.PrimitiveType;
import sootup.core.types.Type;
import sootup.core.types.UnknownType;

public class LocalNameStandardizer
implements BodyInterceptor {
    @Override
    public void interceptBody(@Nonnull Body.BodyBuilder builder) {
        Local newLocal;
        HashMap<Local, Integer> localToFirstOccurrence = new HashMap<Local, Integer>();
        int defsCount = 0;
        MutableStmtGraph stmtGraph = builder.getStmtGraph();
        for (Stmt stmt : stmtGraph) {
            Local def = null;
            List<Value> defs = stmt.getDefs();
            if (!defs.isEmpty() && defs.get(0) instanceof Local) {
                def = (Local)defs.get(0);
            }
            if (def == null || localToFirstOccurrence.containsKey(def)) continue;
            localToFirstOccurrence.put(def, defsCount);
            ++defsCount;
        }
        ArrayList<Local> localsList = new ArrayList<Local>(builder.getLocals());
        LocalComparator localComparator = new LocalComparator(localToFirstOccurrence);
        localsList.sort(localComparator);
        int refCount = 0;
        int longCount = 0;
        int booleanCount = 0;
        int charCount = 0;
        int floatCount = 0;
        int doubleCount = 0;
        int errorCount = 0;
        int nullCount = 0;
        HashMap<Local, Local> localToNewLocal = new HashMap<Local, Local>();
        for (Local local : localsList) {
            String prefix = "";
            boolean hasDollar = local.getName().startsWith("$");
            if (hasDollar) {
                prefix = "$";
            }
            Type type = local.getType();
            int index = localsList.indexOf(local);
            if (type.equals(PrimitiveType.getByte())) {
                newLocal = local.withName(prefix + "b" + longCount);
                ++longCount;
            } else if (type.equals(PrimitiveType.getShort())) {
                newLocal = local.withName(prefix + "s" + longCount);
                ++longCount;
            } else if (type.equals(PrimitiveType.getInt())) {
                newLocal = local.withName(prefix + "i" + longCount);
                ++longCount;
            } else if (type.equals(PrimitiveType.getLong())) {
                newLocal = local.withName(prefix + "l" + longCount);
                ++longCount;
            } else if (type.equals(PrimitiveType.getFloat())) {
                newLocal = local.withName(prefix + "f" + floatCount);
                ++floatCount;
            } else if (type.equals(PrimitiveType.getDouble())) {
                newLocal = local.withName(prefix + "d" + doubleCount);
                ++doubleCount;
            } else if (type.equals(PrimitiveType.getChar())) {
                newLocal = local.withName(prefix + "c" + charCount);
                ++charCount;
            } else if (type.equals(PrimitiveType.getBoolean())) {
                newLocal = local.withName(prefix + "z" + booleanCount);
                ++booleanCount;
            } else if (type instanceof UnknownType) {
                newLocal = local.withName(prefix + "e" + errorCount);
                ++errorCount;
            } else if (type instanceof NullType) {
                newLocal = local.withName(prefix + "n" + nullCount);
                ++nullCount;
            } else {
                newLocal = local.withName(prefix + "r" + refCount);
                ++refCount;
            }
            localsList.set(index, newLocal);
            localToNewLocal.put(local, newLocal);
        }
        LinkedHashSet<Local> sortedLocals = new LinkedHashSet<Local>(localsList);
        builder.setLocals(sortedLocals);
        Iterator<Stmt> iterator = stmtGraph.iterator();
        while (iterator.hasNext()) {
            Stmt stmt;
            Stmt newStmt = stmt = iterator.next();
            if (!stmt.getDefs().isEmpty() && stmt.getDefs().get(0) instanceof Local) {
                Local def = (Local)stmt.getDefs().get(0);
                Local newLocal2 = (Local)localToNewLocal.get(def);
                newStmt = BodyUtils.withNewDef(newStmt, newLocal2);
            }
            for (Value use : stmt.getUses()) {
                if (!(use instanceof Local)) continue;
                newLocal = (Local)localToNewLocal.get(use);
                newStmt = BodyUtils.withNewUse(newStmt, use, newLocal);
            }
            if (stmt.equals(newStmt)) continue;
            stmtGraph.replaceNode(stmt, newStmt);
        }
    }

    private static class LocalComparator
    implements Comparator<Local> {
        Map<Local, Integer> localToFirstOccurence;

        public LocalComparator(Map<Local, Integer> localToInteger) {
            this.localToFirstOccurence = localToInteger;
        }

        @Override
        public int compare(Local local1, Local local2) {
            int result = local1.getType().toString().compareTo(local2.getType().toString());
            if (result == 0) {
                result = Integer.compare(this.localToFirstOccurence.get(local1), this.localToFirstOccurence.get(local2));
            }
            return result;
        }
    }
}

