/*
 * Decompiled with CFR 0.152.
 */
package sootup.java.core;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import sootup.java.core.types.AnnotationType;

public class AnnotationUsage {
    @Nonnull
    private final AnnotationType annotation;
    @Nonnull
    private final Map<String, Object> values;
    private Map<String, Object> valuesWithDefaults;

    public AnnotationUsage(@Nonnull AnnotationType annotation, @Nonnull Map<String, Object> values) {
        this.annotation = annotation;
        this.values = values;
    }

    @Nonnull
    public AnnotationType getAnnotation() {
        return this.annotation;
    }

    @Nonnull
    public Map<String, Object> getValues() {
        return Collections.unmodifiableMap(this.values);
    }

    @Nonnull
    public Map<String, Object> getValuesWithDefaults() {
        if (this.valuesWithDefaults == null) {
            this.valuesWithDefaults = new HashMap<String, Object>(this.annotation.getDefaultValues(Optional.empty()));
            this.values.forEach((k, v) -> this.valuesWithDefaults.put((String)k, v));
        }
        return Collections.unmodifiableMap(this.valuesWithDefaults);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("@").append(this.annotation);
        if (!this.getValuesWithDefaults().isEmpty()) {
            sb.append("(");
            this.getValuesWithDefaults().forEach((k, v) -> sb.append((String)k).append("=").append(v).append(","));
            sb.setCharAt(sb.length() - 1, ')');
        }
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AnnotationUsage that = (AnnotationUsage)o;
        return this.annotation.equals(that.annotation) && this.values.equals(that.values);
    }

    public int hashCode() {
        return Objects.hash(this.annotation, this.values);
    }
}

