/*
 * Decompiled with CFR 0.152.
 */
package sootup.java.core;

import java.util.Collections;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import sootup.core.signatures.PackageName;
import sootup.java.core.AnnotationUsage;
import sootup.java.core.JavaIdentifierFactory;
import sootup.java.core.JavaSootClass;
import sootup.java.core.views.JavaView;

public class JavaPackageName
extends PackageName {
    @Nullable
    private Iterable<AnnotationUsage> annotations;

    public JavaPackageName(@Nonnull String packageName) {
        this(packageName, null);
    }

    public JavaPackageName(@Nonnull String packageName, @Nonnull Iterable<AnnotationUsage> annotations) {
        super(packageName);
        this.annotations = annotations;
    }

    @Nonnull
    public Iterable<AnnotationUsage> getAnnotations(@Nonnull JavaView view, @Nonnull String packageName) {
        if (this.annotations == null) {
            Optional<JavaSootClass> sc = view.getClass(JavaIdentifierFactory.getInstance().getClassType("package-info", packageName));
            this.annotations = sc.isPresent() ? sc.get().getAnnotations(Optional.of(view)) : Collections.emptyList();
        }
        return this.annotations;
    }
}

