/*
 * Decompiled with CFR 0.152.
 */
package sootup.java.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import sootup.core.model.Modifier;
import sootup.core.model.Position;
import sootup.core.model.SootClass;
import sootup.core.model.SootField;
import sootup.core.model.SootMethod;
import sootup.core.model.SourceType;
import sootup.core.signatures.FieldSubSignature;
import sootup.core.signatures.MethodSubSignature;
import sootup.core.types.ClassType;
import sootup.core.types.Type;
import sootup.java.core.AnnotationUsage;
import sootup.java.core.JavaSootClassSource;
import sootup.java.core.JavaSootField;
import sootup.java.core.JavaSootMethod;
import sootup.java.core.OverridingJavaClassSource;
import sootup.java.core.views.JavaView;

public class JavaSootClass
extends SootClass<JavaSootClassSource> {
    public boolean isJavaLibraryClass() {
        return this.classSignature.isBuiltInClass();
    }

    public JavaSootClass(JavaSootClassSource classSource, SourceType sourceType) {
        super(classSource, sourceType);
    }

    @Nonnull
    public Iterable<AnnotationUsage> getAnnotations(@Nonnull Optional<JavaView> view) {
        ArrayList<AnnotationUsage> annotationUsages = new ArrayList<AnnotationUsage>();
        if (view.isPresent()) {
            ClassType superClass;
            JavaView javaView = view.get();
            if (this.getSuperclass().isPresent() && javaView.getClass(superClass = this.getSuperclass().get()).isPresent()) {
                JavaSootClass superJavaSootClass = javaView.getClass(superClass).get();
                Collection annos = StreamSupport.stream(superJavaSootClass.getAnnotations(view).spliterator(), false).filter(annotationUsage -> annotationUsage.getAnnotation().isInherited(view)).collect(Collectors.toList());
                annotationUsages.addAll(annos);
            }
        }
        ((JavaSootClassSource)this.classSource).resolveAnnotations().forEach(annotationUsages::add);
        annotationUsages.forEach(e -> e.getAnnotation().getDefaultValues(view));
        for (AnnotationUsage annotationUsage2 : annotationUsages) {
            for (Object value : annotationUsage2.getValuesWithDefaults().values()) {
                if (!(value instanceof ArrayList) || ((ArrayList)value).isEmpty() || !(((ArrayList)value).get(0) instanceof AnnotationUsage)) continue;
                ((ArrayList)value).forEach(au -> au.getAnnotation().getDefaultValues(view));
            }
        }
        return annotationUsages;
    }

    @Override
    @Nonnull
    public Set<? extends JavaSootMethod> getMethods() {
        return super.getMethods();
    }

    @Override
    @Nonnull
    public Set<? extends JavaSootField> getFields() {
        return super.getFields();
    }

    @Override
    @Nonnull
    public Optional<JavaSootField> getField(@Nonnull String name) {
        return super.getField(name);
    }

    @Override
    @Nonnull
    public Optional<JavaSootField> getField(@Nonnull FieldSubSignature subSignature) {
        return super.getField(subSignature);
    }

    @Override
    @Nonnull
    public Optional<JavaSootMethod> getMethod(@Nonnull String name, @Nonnull Iterable<? extends Type> parameterTypes) {
        return super.getMethod(name, parameterTypes);
    }

    @Override
    @Nonnull
    public Optional<JavaSootMethod> getMethod(@Nonnull MethodSubSignature subSignature) {
        return super.getMethod(subSignature);
    }

    @Override
    @Nonnull
    public JavaSootClassSource getClassSource() {
        return (JavaSootClassSource)super.getClassSource();
    }

    @Nonnull
    public JavaSootClass withOverridingClassSource(Function<OverridingJavaClassSource, OverridingJavaClassSource> overrider) {
        return new JavaSootClass(overrider.apply(new OverridingJavaClassSource(this.getClassSource())), this.sourceType);
    }

    @Nonnull
    public JavaSootClass withReplacedMethod(@Nonnull SootMethod toReplace, @Nonnull SootMethod replacement) {
        return new JavaSootClass(new OverridingJavaClassSource(this.getClassSource()).withReplacedMethod(toReplace, replacement), this.sourceType);
    }

    @Nonnull
    public JavaSootClass withMethods(@Nonnull Collection<SootMethod> methods) {
        return new JavaSootClass(new OverridingJavaClassSource(this.getClassSource()).withMethods(methods), this.sourceType);
    }

    @Nonnull
    public JavaSootClass withReplacedField(@Nonnull SootField toReplace, @Nonnull SootField replacement) {
        return new JavaSootClass(new OverridingJavaClassSource(this.getClassSource()).withReplacedField(toReplace, replacement), this.sourceType);
    }

    @Nonnull
    public JavaSootClass withFields(@Nonnull Collection<SootField> fields) {
        return new JavaSootClass(new OverridingJavaClassSource(this.getClassSource()).withFields(fields), this.sourceType);
    }

    @Nonnull
    public JavaSootClass withModifiers(@Nonnull Set<Modifier> modifiers) {
        return new JavaSootClass(new OverridingJavaClassSource(this.getClassSource()).withModifiers(modifiers), this.sourceType);
    }

    @Nonnull
    public JavaSootClass withSuperclass(@Nonnull Optional<ClassType> superclass) {
        return new JavaSootClass(new OverridingJavaClassSource(this.getClassSource()).withSuperclass(superclass), this.sourceType);
    }

    @Nonnull
    public JavaSootClass withOuterClass(@Nonnull Optional<ClassType> outerClass) {
        return new JavaSootClass(new OverridingJavaClassSource(this.getClassSource()).withOuterClass(outerClass), this.sourceType);
    }

    @Nonnull
    public JavaSootClass withPosition(@Nullable Position position) {
        return new JavaSootClass(new OverridingJavaClassSource(this.getClassSource()).withPosition(position), this.sourceType);
    }
}

