/*
 * Decompiled with CFR 0.152.
 */
package sootup.java.core;

import java.util.Collections;
import java.util.Optional;
import javax.annotation.Nonnull;
import sootup.core.model.Modifier;
import sootup.core.model.Position;
import sootup.core.model.SootField;
import sootup.core.signatures.FieldSignature;
import sootup.java.core.AnnotationUsage;
import sootup.java.core.views.JavaView;

public class JavaSootField
extends SootField {
    @Nonnull
    private final Iterable<AnnotationUsage> annotations;

    public JavaSootField(@Nonnull FieldSignature signature, @Nonnull Iterable<Modifier> modifiers, @Nonnull Iterable<AnnotationUsage> annotations, Position position) {
        super(signature, modifiers, position);
        this.annotations = annotations;
    }

    @Nonnull
    public Iterable<AnnotationUsage> getAnnotations(@Nonnull Optional<JavaView> view) {
        this.annotations.forEach(e -> e.getAnnotation().getDefaultValues(view));
        return this.annotations;
    }

    @Nonnull
    public JavaSootField withAnnotations(@Nonnull Iterable<AnnotationUsage> annotations) {
        return new JavaSootField((FieldSignature)this.getSignature(), this.getModifiers(), annotations, this.getPosition());
    }

    @Nonnull
    public static AnnotationOrSignatureStep builder() {
        return new JavaSootFieldBuilder();
    }

    public static class JavaSootFieldBuilder
    extends SootField.SootFieldBuilder
    implements AnnotationOrSignatureStep {
        private Iterable<AnnotationUsage> annotations = null;

        @Nonnull
        public Iterable<AnnotationUsage> getAnnotations() {
            return this.annotations != null ? this.annotations : Collections.emptyList();
        }

        @Override
        @Nonnull
        public SootField.BuildStep withAnnotation(Iterable<AnnotationUsage> annotations) {
            this.annotations = annotations;
            return this;
        }

        @Override
        @Nonnull
        public JavaSootField build() {
            return new JavaSootField(this.getSignature(), this.getModifiers(), this.getAnnotations(), this.getPosition());
        }
    }

    public static interface AnnotationOrSignatureStep
    extends SootField.SignatureStep {
        public SootField.BuildStep withAnnotation(Iterable<AnnotationUsage> var1);
    }
}

