/*
 * Decompiled with CFR 0.152.
 */
package sootup.java.core;

import java.nio.file.Path;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import sootup.core.frontend.ResolveException;
import sootup.core.inputlocation.AnalysisInputLocation;
import sootup.core.model.Modifier;
import sootup.core.model.Position;
import sootup.core.model.SootField;
import sootup.core.model.SootMethod;
import sootup.core.types.ClassType;
import sootup.core.util.CollectionUtils;
import sootup.java.core.AnnotationUsage;
import sootup.java.core.JavaSootClass;
import sootup.java.core.JavaSootClassSource;

public class OverridingJavaClassSource
extends JavaSootClassSource {
    @Nullable
    private final Collection<SootMethod> overriddenSootMethods;
    @Nullable
    private final Collection<SootField> overriddenSootFields;
    @Nullable
    private final Set<Modifier> overriddenModifiers;
    @Nullable
    private final Set<ClassType> overriddenInterfaces;
    @Nullable
    private final Optional<ClassType> overriddenSuperclass;
    @Nullable
    private final Optional<ClassType> overriddenOuterClass;
    @Nullable
    private final Position position;
    @Nullable
    private final JavaSootClassSource delegate;
    @Nullable
    private final Iterable<AnnotationUsage> annotations;
    @Nullable
    private final Iterable<AnnotationUsage> methodAnnotations;
    @Nullable
    private final Iterable<AnnotationUsage> fieldAnnotations;

    public OverridingJavaClassSource(@Nonnull JavaSootClassSource delegate) {
        super(delegate);
        this.delegate = delegate;
        this.overriddenSootMethods = null;
        this.overriddenSootFields = null;
        this.overriddenModifiers = null;
        this.overriddenInterfaces = null;
        this.overriddenSuperclass = null;
        this.overriddenOuterClass = null;
        this.position = null;
        this.annotations = null;
        this.methodAnnotations = null;
        this.fieldAnnotations = null;
    }

    private OverridingJavaClassSource(@Nullable Collection<SootMethod> overriddenSootMethods, @Nullable Collection<SootField> overriddenSootFields, @Nullable Set<Modifier> overriddenModifiers, @Nullable Set<ClassType> overriddenInterfaces, @Nullable Optional<ClassType> overriddenSuperclass, @Nullable Optional<ClassType> overriddenOuterClass, @Nullable Position position, @Nullable Iterable<AnnotationUsage> annotations, @Nullable Iterable<AnnotationUsage> methodAnnotations, @Nullable Iterable<AnnotationUsage> fieldAnnotations, @Nonnull JavaSootClassSource delegate) {
        super(delegate);
        this.overriddenSootMethods = overriddenSootMethods;
        this.overriddenSootFields = overriddenSootFields;
        this.overriddenModifiers = overriddenModifiers;
        this.overriddenInterfaces = overriddenInterfaces;
        this.overriddenSuperclass = overriddenSuperclass;
        this.overriddenOuterClass = overriddenOuterClass;
        this.position = position;
        this.delegate = delegate;
        this.annotations = annotations;
        this.methodAnnotations = methodAnnotations;
        this.fieldAnnotations = fieldAnnotations;
    }

    public OverridingJavaClassSource(@Nonnull AnalysisInputLocation<JavaSootClass> srcNamespace, @Nonnull Path sourcePath, @Nonnull ClassType classType, @Nullable ClassType superClass, @Nonnull Set<ClassType> interfaces, @Nullable ClassType outerClass, @Nonnull Set<SootField> sootFields, @Nonnull Set<SootMethod> sootMethods, @Nonnull Position position, @Nonnull EnumSet<Modifier> modifiers, @Nonnull Iterable<AnnotationUsage> annotations, @Nonnull Iterable<AnnotationUsage> methodAnnotations, @Nullable Iterable<AnnotationUsage> fieldAnnotations) {
        super(srcNamespace, classType, sourcePath);
        this.delegate = null;
        this.overriddenSootMethods = sootMethods;
        this.overriddenSootFields = sootFields;
        this.overriddenModifiers = modifiers;
        this.overriddenInterfaces = interfaces;
        this.overriddenSuperclass = Optional.ofNullable(superClass);
        this.overriddenOuterClass = Optional.ofNullable(outerClass);
        this.position = position;
        this.annotations = annotations;
        this.methodAnnotations = methodAnnotations;
        this.fieldAnnotations = fieldAnnotations;
    }

    @Override
    @Nonnull
    public Collection<? extends SootMethod> resolveMethods() throws ResolveException {
        return this.overriddenSootMethods != null ? this.overriddenSootMethods : this.delegate.resolveMethods();
    }

    @Override
    @Nonnull
    public Collection<? extends SootField> resolveFields() throws ResolveException {
        return this.overriddenSootFields != null ? this.overriddenSootFields : this.delegate.resolveFields();
    }

    @Override
    @Nonnull
    public Set<Modifier> resolveModifiers() {
        return this.overriddenModifiers != null ? this.overriddenModifiers : this.delegate.resolveModifiers();
    }

    @Override
    @Nonnull
    public Set<? extends ClassType> resolveInterfaces() {
        return this.overriddenInterfaces != null ? this.overriddenInterfaces : this.delegate.resolveInterfaces();
    }

    @Override
    @Nonnull
    public Optional<? extends ClassType> resolveSuperclass() {
        return this.overriddenSuperclass != null ? this.overriddenSuperclass : this.delegate.resolveSuperclass();
    }

    @Override
    @Nonnull
    public Optional<? extends ClassType> resolveOuterClass() {
        return this.overriddenOuterClass != null ? this.overriddenOuterClass : this.delegate.resolveOuterClass();
    }

    @Override
    @Nonnull
    public Position resolvePosition() {
        return this.position != null ? this.position : this.delegate.resolvePosition();
    }

    @Override
    @Nonnull
    protected Iterable<AnnotationUsage> resolveAnnotations() {
        return this.annotations != null ? this.annotations : this.delegate.resolveAnnotations();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OverridingJavaClassSource that = (OverridingJavaClassSource)o;
        return Objects.equals(this.overriddenSuperclass, that.overriddenSuperclass) && Objects.equals(this.overriddenInterfaces, that.overriddenInterfaces) && Objects.equals(this.overriddenOuterClass, that.overriddenOuterClass) && Objects.equals(this.overriddenSootFields, that.overriddenSootFields) && Objects.equals(this.overriddenSootMethods, that.overriddenSootMethods) && Objects.equals(this.position, that.position) && Objects.equals(this.overriddenModifiers, that.overriddenModifiers) && Objects.equals(this.classSignature, that.classSignature) && Objects.equals(this.annotations, that.annotations) && Objects.equals(this.methodAnnotations, that.methodAnnotations);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.overriddenSuperclass, this.overriddenInterfaces, this.overriddenOuterClass, this.overriddenSootFields, this.overriddenSootMethods, this.position, this.overriddenModifiers, this.classSignature, this.annotations, this.methodAnnotations);
    }

    public String toString() {
        return "frontend.OverridingClassSource{superClass=" + this.overriddenSuperclass + ", interfaces=" + this.overriddenInterfaces + ", outerClass=" + this.overriddenOuterClass + ", sootFields=" + this.overriddenSootFields + ", sootMethods=" + this.overriddenSootMethods + ", position=" + this.position + ", modifiers=" + this.overriddenModifiers + ", classType=" + this.classSignature + '}';
    }

    @Nonnull
    public OverridingJavaClassSource withReplacedMethod(@Nonnull SootMethod toReplace, @Nonnull SootMethod replacement) {
        HashSet<SootMethod> newMethods = new HashSet<SootMethod>(this.resolveMethods());
        CollectionUtils.replace(newMethods, toReplace, replacement);
        return this.withMethods(newMethods);
    }

    @Nonnull
    public OverridingJavaClassSource withMethods(@Nonnull Collection<SootMethod> overriddenSootMethods) {
        return new OverridingJavaClassSource(overriddenSootMethods, this.overriddenSootFields, this.overriddenModifiers, this.overriddenInterfaces, this.overriddenSuperclass, this.overriddenOuterClass, this.position, this.annotations, this.methodAnnotations, this.fieldAnnotations, this.delegate);
    }

    @Nonnull
    public OverridingJavaClassSource withReplacedField(@Nonnull SootField toReplace, @Nonnull SootField replacement) {
        HashSet<SootField> newFields = new HashSet<SootField>(this.resolveFields());
        CollectionUtils.replace(newFields, toReplace, replacement);
        return this.withFields(newFields);
    }

    @Nonnull
    public OverridingJavaClassSource withFields(@Nonnull Collection<SootField> overriddenSootFields) {
        return new OverridingJavaClassSource(this.overriddenSootMethods, overriddenSootFields, this.overriddenModifiers, this.overriddenInterfaces, this.overriddenSuperclass, this.overriddenOuterClass, this.position, this.annotations, this.methodAnnotations, this.fieldAnnotations, this.delegate);
    }

    @Nonnull
    public OverridingJavaClassSource withModifiers(@Nonnull Set<Modifier> overriddenModifiers) {
        return new OverridingJavaClassSource(this.overriddenSootMethods, this.overriddenSootFields, overriddenModifiers, this.overriddenInterfaces, this.overriddenSuperclass, this.overriddenOuterClass, this.position, this.annotations, this.methodAnnotations, this.fieldAnnotations, this.delegate);
    }

    @Nonnull
    public OverridingJavaClassSource withInterfaces(@Nonnull Set<ClassType> overriddenInterfaces) {
        return new OverridingJavaClassSource(this.overriddenSootMethods, this.overriddenSootFields, this.overriddenModifiers, overriddenInterfaces, this.overriddenSuperclass, this.overriddenOuterClass, this.position, this.annotations, this.methodAnnotations, this.fieldAnnotations, this.delegate);
    }

    @Nonnull
    public OverridingJavaClassSource withSuperclass(@Nonnull Optional<ClassType> overriddenSuperclass) {
        return new OverridingJavaClassSource(this.overriddenSootMethods, this.overriddenSootFields, this.overriddenModifiers, this.overriddenInterfaces, overriddenSuperclass, this.overriddenOuterClass, this.position, this.annotations, this.methodAnnotations, this.fieldAnnotations, this.delegate);
    }

    @Nonnull
    public OverridingJavaClassSource withOuterClass(@Nonnull Optional<ClassType> overriddenOuterClass) {
        return new OverridingJavaClassSource(this.overriddenSootMethods, this.overriddenSootFields, this.overriddenModifiers, this.overriddenInterfaces, this.overriddenSuperclass, overriddenOuterClass, this.position, this.annotations, this.methodAnnotations, this.fieldAnnotations, this.delegate);
    }

    @Nonnull
    public OverridingJavaClassSource withPosition(@Nullable Position position) {
        return new OverridingJavaClassSource(this.overriddenSootMethods, this.overriddenSootFields, this.overriddenModifiers, this.overriddenInterfaces, this.overriddenSuperclass, this.overriddenOuterClass, position, this.annotations, this.methodAnnotations, this.fieldAnnotations, this.delegate);
    }
}

