/*
 * Decompiled with CFR 0.152.
 */
package sootup.java.core.signatures;

import com.google.common.base.Objects;
import sootup.java.core.JavaPackageName;
import sootup.java.core.signatures.ModuleSignature;

public class ModulePackageName
extends JavaPackageName {
    private final ModuleSignature moduleSignature;

    public ModulePackageName(String packageName, ModuleSignature moduleSignature) {
        super(packageName);
        this.moduleSignature = moduleSignature;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ModulePackageName that = (ModulePackageName)o;
        return Objects.equal(this.moduleSignature, that.moduleSignature) && Objects.equal(this.getPackageName(), that.getPackageName());
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(super.hashCode(), this.moduleSignature);
    }

    public ModuleSignature getModuleSignature() {
        return this.moduleSignature;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        String moduleSignatureStr = this.getModuleSignature().toString();
        String pckgStr = this.getPackageName();
        if (!moduleSignatureStr.isEmpty()) {
            sb.append(moduleSignatureStr).append("/");
        }
        if (!pckgStr.isEmpty()) {
            sb.append(pckgStr);
        }
        return sb.toString();
    }
}

