/*
 * Decompiled with CFR 0.152.
 */
package sootup.java.core.views;

import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import sootup.core.Project;
import sootup.core.frontend.AbstractClassSource;
import sootup.core.frontend.ResolveException;
import sootup.core.inputlocation.AnalysisInputLocation;
import sootup.core.inputlocation.ClassLoadingOptions;
import sootup.core.inputlocation.EmptyClassLoadingOptions;
import sootup.core.signatures.PackageName;
import sootup.core.types.ClassType;
import sootup.java.core.JavaModuleInfo;
import sootup.java.core.JavaModuleProject;
import sootup.java.core.JavaSootClass;
import sootup.java.core.ModuleInfoAnalysisInputLocation;
import sootup.java.core.signatures.ModulePackageName;
import sootup.java.core.signatures.ModuleSignature;
import sootup.java.core.types.JavaClassType;
import sootup.java.core.views.JavaView;

public class JavaModuleView
extends JavaView {
    @Nonnull
    final HashMap<ModuleSignature, JavaModuleInfo> moduleInfoMap = new HashMap();
    @Nonnull
    protected Function<AnalysisInputLocation<? extends JavaSootClass>, ClassLoadingOptions> classLoadingOptionsSpecifier;

    public JavaModuleView(@Nonnull Project<JavaSootClass, ? extends JavaView> project) {
        this(project, analysisInputLocation -> EmptyClassLoadingOptions.Default);
    }

    public JavaModuleView(@Nonnull Project<JavaSootClass, ? extends JavaView> project, @Nonnull Function<AnalysisInputLocation<? extends JavaSootClass>, ClassLoadingOptions> classLoadingOptionsSpecifier) {
        super(project);
        this.classLoadingOptionsSpecifier = classLoadingOptionsSpecifier;
        JavaModuleInfo unnamedModuleInfo = JavaModuleInfo.getUnnamedModuleInfo();
        this.moduleInfoMap.put(unnamedModuleInfo.getModuleSignature(), unnamedModuleInfo);
    }

    @Override
    @Nonnull
    public JavaModuleProject getProject() {
        return (JavaModuleProject)super.getProject();
    }

    @Nonnull
    public Optional<JavaModuleInfo> getModuleInfo(ModuleSignature sig) {
        JavaModuleInfo moduleInfo = this.moduleInfoMap.get(sig);
        if (moduleInfo != null) {
            return Optional.of(moduleInfo);
        }
        for (ModuleInfoAnalysisInputLocation inputLocation : this.getProject().getModuleInfoAnalysisInputLocation()) {
            Optional<JavaModuleInfo> moduleInfoOpt = inputLocation.getModuleInfo(sig, this);
            if (!moduleInfoOpt.isPresent()) continue;
            this.moduleInfoMap.put(sig, moduleInfoOpt.get());
            return moduleInfoOpt;
        }
        return Optional.empty();
    }

    private boolean isPackageVisibleToModule(ModuleSignature moduleSignature, ModulePackageName packageName) {
        if (packageName.getModuleSignature().equals(moduleSignature)) {
            return true;
        }
        Optional<JavaModuleInfo> moduleInfoOpt = this.getModuleInfo(packageName.getModuleSignature());
        if (!moduleInfoOpt.isPresent()) {
            throw new ResolveException("ModuleDescriptor not available.");
        }
        JavaModuleInfo moduleInfo = moduleInfoOpt.get();
        if (moduleInfo.isAutomaticModule()) {
            return true;
        }
        if (moduleInfo.isUnnamedModule()) {
            return true;
        }
        Collection<JavaModuleInfo.PackageReference> exports = moduleInfo.exports();
        Optional<JavaModuleInfo.PackageReference> filteredExportedPackages = exports.stream().filter(packageReference -> packageReference.getPackageName().equals(packageName)).findAny();
        return filteredExportedPackages.isPresent();
    }

    @Override
    @Nonnull
    protected Optional<? extends AbstractClassSource<? extends JavaSootClass>> getAbstractClass(@Nonnull ClassType type) {
        Optional<AbstractClassSource> cs = this.getProject().getModuleInfoAnalysisInputLocation().stream().map(location -> location.getClassSource(type, this)).filter(Optional::isPresent).map(Optional::get).findAny();
        if (cs.isPresent()) {
            return cs;
        }
        return super.getAbstractClass(type);
    }

    @Nonnull
    public synchronized Optional<JavaSootClass> getClass(@Nonnull ModulePackageName entryPackage, @Nonnull JavaClassType type) {
        Optional<JavaModuleInfo> startOpt = this.getModuleInfo(entryPackage.getModuleSignature());
        if (!startOpt.isPresent()) {
            return Optional.empty();
        }
        JavaModuleInfo moduleInfo = startOpt.get();
        if (moduleInfo.isUnnamedModule()) {
            List foundClassSources = this.getAbstractClassSourcesForModules(entryPackage.getModuleSignature(), type).limit(1L).map(Optional::get).collect(Collectors.toList());
            if (!foundClassSources.isEmpty()) {
                return this.buildClassFrom((AbstractClassSource)foundClassSources.get(0));
            }
            PackageName packageName = type.getPackageName();
            if (packageName instanceof ModulePackageName && ((ModulePackageName)packageName).getModuleSignature().isUnnamedModule()) {
                return this.getClass(type);
            }
        } else {
            if (moduleInfo.isAutomaticModule()) {
                List foundClassSources = this.getAbstractClassSourcesForModules(entryPackage.getModuleSignature(), type).limit(1L).map(Optional::get).collect(Collectors.toList());
                if (!foundClassSources.isEmpty()) {
                    return this.buildClassFrom((AbstractClassSource)foundClassSources.get(0));
                }
                return super.getClass(type);
            }
            boolean targetIsFromSameModule = type.getPackageName() instanceof ModulePackageName && ((ModulePackageName)type.getPackageName()).getModuleSignature() == entryPackage.getModuleSignature();
            Optional<AbstractClassSource> foundClassSources = this.getAbstractClassSourcesForModules(entryPackage.getModuleSignature(), type).map(Optional::get).filter(sc -> {
                if (targetIsFromSameModule) {
                    return true;
                }
                if (moduleInfo.requires().stream().anyMatch(req -> req.getModuleSignature().equals(((ModulePackageName)sc.getClassType().getPackageName()).getModuleSignature()))) {
                    return true;
                }
                return this.isTransitiveRequires(moduleInfo, ((ModulePackageName)sc.getClassType().getPackageName()).getModuleSignature()) || this.isProvidedInterfaceImplementation((JavaClassType)sc.getClassType());
            }).findAny();
            if (foundClassSources.isPresent()) {
                return this.buildClassFrom(foundClassSources.get());
            }
            return Optional.empty();
        }
        return Optional.empty();
    }

    private boolean isTransitiveRequires(JavaModuleInfo entryModuleInfo, ModuleSignature moduleSignature) {
        HashSet<ModuleSignature> visited = new HashSet<ModuleSignature>();
        visited.add(entryModuleInfo.getModuleSignature());
        ArrayDeque<ModuleSignature> stack = new ArrayDeque<ModuleSignature>();
        stack.add(entryModuleInfo.getModuleSignature());
        while (!stack.isEmpty()) {
            JavaModuleInfo moduleInfo;
            Optional<JavaModuleInfo> moduleInfoOpt = this.getModuleInfo((ModuleSignature)stack.pop());
            if (!moduleInfoOpt.isPresent() || (moduleInfo = moduleInfoOpt.get()).isAutomaticModule() || moduleInfo.isUnnamedModule()) continue;
            for (JavaModuleInfo.ModuleReference require : moduleInfo.requires()) {
                ModuleSignature requireModuleSig = require.getModuleSignature();
                if (moduleSignature.equals(requireModuleSig)) {
                    return true;
                }
                if (!visited.contains(requireModuleSig)) {
                    stack.add(requireModuleSig);
                }
                visited.add(requireModuleSig);
            }
        }
        return false;
    }

    @Nonnull
    public synchronized Collection<JavaSootClass> getModuleClasses(@Nonnull ModuleSignature moduleSignature) {
        Optional<JavaModuleInfo> startOpt = this.getModuleInfo(moduleSignature);
        if (!startOpt.isPresent()) {
            return Collections.emptyList();
        }
        JavaModuleInfo moduleInfo = startOpt.get();
        Stream<Optional<Object>> stream = moduleInfo.isUnnamedModule() ? this.getProject().getInputLocations().stream().flatMap(input -> input.getClassSources(this).stream()) : (moduleInfo.isAutomaticModule() ? Stream.concat(this.getProject().getInputLocations().stream().flatMap(input -> input.getClassSources(this).stream().filter(cs -> moduleSignature.equals(((ModulePackageName)cs.getClassType().getPackageName()).getModuleSignature()))), this.getProject().getModuleInfoAnalysisInputLocation().stream().flatMap(input -> input.getModulesClassSources(moduleSignature, this).stream())) : this.getProject().getModuleInfoAnalysisInputLocation().stream().flatMap(input -> input.getModulesClassSources(moduleSignature, this).stream()));
        return stream.map(this::buildClassFrom).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
    }

    @Nonnull
    private Stream<? extends Optional<? extends AbstractClassSource<JavaSootClass>>> getAbstractClassSourcesForModules(ModuleSignature moduleSig, @Nonnull JavaClassType type) {
        return this.getProject().getModuleInfoAnalysisInputLocation().stream().map(location -> location.getClassSource(type, this)).filter(Optional::isPresent).filter(cs -> this.isPackageVisibleToModule(moduleSig, (ModulePackageName)type.getPackageName()) || this.isProvidedInterfaceImplementation(type));
    }

    private boolean isProvidedInterfaceImplementation(@Nonnull JavaClassType type) {
        ModulePackageName packageName = (ModulePackageName)type.getPackageName();
        JavaModuleInfo moduleInfo = this.getModuleInfo(packageName.getModuleSignature()).get();
        for (JavaModuleInfo.InterfaceReference provides : moduleInfo.provides()) {
            String packageName2;
            JavaClassType interfaceType = provides.getInterfaceType();
            String packageName1 = interfaceType.getPackageName().getPackageName();
            if (!packageName1.equals(packageName2 = type.getPackageName().getPackageName()) || !interfaceType.getClassName().equals(type.getClassName())) continue;
            return true;
        }
        return false;
    }

    @Nonnull
    public Set<ModuleSignature> getNamedModules() {
        HashSet<ModuleSignature> modules = new HashSet<ModuleSignature>();
        for (ModuleInfoAnalysisInputLocation moduleInputLocation : this.getProject().getModuleInfoAnalysisInputLocation()) {
            modules.addAll(moduleInputLocation.getModules(this));
        }
        return modules;
    }

    @Override
    protected synchronized void resolveAll() {
        if (this.isFullyResolved) {
            return;
        }
        this.getProject().getInputLocations().stream().flatMap(location -> location.getClassSources(this).stream()).forEach(this::buildClassFrom);
        this.getProject().getModuleInfoAnalysisInputLocation().stream().flatMap(location -> location.getClassSources(this).stream()).forEach(this::buildClassFrom);
        this.isFullyResolved = true;
    }
}

