/*
 * Decompiled with CFR 0.152.
 */
package sootup.java.bytecode.frontend;

import java.io.IOException;
import java.nio.file.Path;
import javax.annotation.Nonnull;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.tree.ClassNode;
import sootup.core.frontend.AbstractClassSource;
import sootup.core.frontend.ClassProvider;
import sootup.core.frontend.ResolveException;
import sootup.core.inputlocation.AnalysisInputLocation;
import sootup.core.inputlocation.FileType;
import sootup.core.jimple.basic.NoPositionInformation;
import sootup.core.model.Position;
import sootup.core.model.SootClass;
import sootup.core.types.ClassType;
import sootup.core.views.View;
import sootup.java.bytecode.frontend.AsmAnnotationClassSource;
import sootup.java.bytecode.frontend.AsmClassSource;
import sootup.java.bytecode.frontend.AsmMethodSource;
import sootup.java.bytecode.frontend.AsmUtil;
import sootup.java.core.JavaSootClass;
import sootup.java.core.types.AnnotationType;
import sootup.java.core.types.JavaClassType;
import sootup.java.core.types.ModuleJavaClassType;

public class AsmJavaClassProvider
implements ClassProvider<JavaSootClass> {
    @Nonnull
    private final View<?> view;

    public AsmJavaClassProvider(@Nonnull View<?> view) {
        this.view = view;
    }

    public AbstractClassSource<JavaSootClass> createClassSource(AnalysisInputLocation<? extends SootClass<?>> analysisInputLocation, Path sourcePath, ClassType classType) {
        SootClassNode classNode = new SootClassNode(analysisInputLocation);
        try {
            AsmUtil.initAsmClassSource(sourcePath, (ClassVisitor)classNode);
        }
        catch (IOException exception) {
            throw new ResolveException(exception.getMessage(), sourcePath, (Position)NoPositionInformation.getInstance(), (Exception)exception);
        }
        JavaClassType klassType = (JavaClassType)classType;
        if (klassType instanceof ModuleJavaClassType && klassType.getClassName().equals("module-info")) {
            throw new ResolveException("Can not create ClassSource from a module info descriptor!", sourcePath);
        }
        if (klassType instanceof AnnotationType) {
            return new AsmAnnotationClassSource(analysisInputLocation, sourcePath, klassType, classNode);
        }
        return new AsmClassSource(analysisInputLocation, sourcePath, klassType, classNode);
    }

    @Nonnull
    public FileType getHandledFileType() {
        return FileType.CLASS;
    }

    class SootClassNode
    extends ClassNode {
        private final AnalysisInputLocation<? extends SootClass<?>> analysisInputLocation;

        SootClassNode(AnalysisInputLocation<? extends SootClass<?>> analysisInputLocation) {
            super(589824);
            this.analysisInputLocation = analysisInputLocation;
        }

        @Nonnull
        public MethodVisitor visitMethod(int access, @Nonnull String name, @Nonnull String desc, @Nonnull String signature, @Nonnull String[] exceptions) {
            AsmMethodSource mn = new AsmMethodSource(access, name, desc, signature, exceptions, AsmJavaClassProvider.this.view, AsmJavaClassProvider.this.view.getBodyInterceptors(this.analysisInputLocation));
            this.methods.add(mn);
            return mn;
        }
    }
}

