/*
 * Decompiled with CFR 0.152.
 */
package sootup.java.bytecode.frontend;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import org.objectweb.asm.tree.AbstractInsnNode;
import sootup.core.jimple.Jimple;
import sootup.core.jimple.basic.Local;
import sootup.core.jimple.basic.StmtPositionInfo;
import sootup.core.jimple.basic.Value;
import sootup.core.jimple.common.constant.Constant;
import sootup.core.jimple.common.stmt.Stmt;
import sootup.core.types.Type;
import sootup.java.bytecode.frontend.AsmMethodSource;
import sootup.java.bytecode.frontend.AsmUtil;
import sootup.java.bytecode.frontend.Operand;
import sootup.java.bytecode.frontend.StackFrame;

public class OperandStack {
    @Nonnull
    private final AsmMethodSource methodSource;
    private List<Operand> stack;
    @Nonnull
    public Map<AbstractInsnNode, StackFrame> frames;

    public OperandStack(@Nonnull AsmMethodSource methodSource, int nrInsn) {
        this.methodSource = methodSource;
        this.frames = new LinkedHashMap<AbstractInsnNode, StackFrame>(nrInsn);
    }

    @Nonnull
    public StackFrame getOrCreateStackframe(@Nonnull AbstractInsnNode insn) {
        StackFrame frame = this.frames.get(insn);
        if (frame == null) {
            frame = new StackFrame(this.methodSource);
            this.frames.put(insn, frame);
        }
        return frame;
    }

    public void push(@Nonnull Operand opr) {
        this.stack.add(opr);
    }

    public void pushDual(@Nonnull Operand opr) {
        this.stack.add(Operand.DWORD_DUMMY);
        this.stack.add(opr);
    }

    @Nonnull
    public Operand peek() {
        if (this.stack.isEmpty()) {
            throw new RuntimeException("Stack underrun");
        }
        return this.stack.get(this.stack.size() - 1);
    }

    public void push(@Nonnull Type t, @Nonnull Operand opr) {
        if (AsmUtil.isDWord(t)) {
            this.pushDual(opr);
        } else {
            this.push(opr);
        }
    }

    @Nonnull
    public Operand pop() {
        if (this.stack.isEmpty()) {
            throw new RuntimeException("Stack underrun");
        }
        return this.stack.remove(this.stack.size() - 1);
    }

    @Nonnull
    public Operand popDual() {
        Operand o = this.pop();
        Operand o2 = this.pop();
        if (o2 != Operand.DWORD_DUMMY && o2 != o) {
            throw new AssertionError((Object)("Not dummy operand, " + o2.value + " -- " + o.value));
        }
        return o;
    }

    @Nonnull
    public Operand pop(@Nonnull Type t) {
        return AsmUtil.isDWord(t) ? this.popDual() : this.pop();
    }

    @Nonnull
    public Operand popLocal(@Nonnull Operand o) {
        Value v = o.value;
        Local l = o.stackLocal;
        if (l == null && !(v instanceof Local)) {
            l = o.stackLocal = this.methodSource.newStackLocal();
            this.methodSource.setStmt(o.insn, (Stmt)Jimple.newAssignStmt((Value)l, (Value)v, (StmtPositionInfo)StmtPositionInfo.createNoStmtPositionInfo()));
            o.updateUsages();
        }
        return o;
    }

    @Nonnull
    public Operand popImmediate(@Nonnull Operand o) {
        Value v = o.value;
        Local l = o.stackLocal;
        if (l == null && !(v instanceof Local) && !(v instanceof Constant)) {
            l = o.stackLocal = this.methodSource.newStackLocal();
            this.methodSource.setStmt(o.insn, (Stmt)Jimple.newAssignStmt((Value)l, (Value)v, (StmtPositionInfo)StmtPositionInfo.createNoStmtPositionInfo()));
            o.updateUsages();
        }
        return o;
    }

    @Nonnull
    public Operand popStackConst(@Nonnull Operand o) {
        Value v = o.value;
        Local l = o.stackLocal;
        if (l == null && !(v instanceof Constant)) {
            l = o.stackLocal = this.methodSource.newStackLocal();
            this.methodSource.setStmt(o.insn, (Stmt)Jimple.newAssignStmt((Value)l, (Value)v, (StmtPositionInfo)StmtPositionInfo.createNoStmtPositionInfo()));
            o.updateUsages();
        }
        return o;
    }

    @Nonnull
    public Operand popLocal() {
        return this.popLocal(this.pop());
    }

    @Nonnull
    public Operand popLocalDual() {
        return this.popLocal(this.popDual());
    }

    @Nonnull
    public Operand popImmediate() {
        return this.popImmediate(this.pop());
    }

    @Nonnull
    public Operand popImmediateDual() {
        return this.popImmediate(this.popDual());
    }

    @Nonnull
    public Operand popImmediate(@Nonnull Type t) {
        return AsmUtil.isDWord(t) ? this.popImmediateDual() : this.popImmediate();
    }

    @Nonnull
    public Operand popStackConst() {
        return this.popStackConst(this.pop());
    }

    @Nonnull
    public Operand popStackConstDual() {
        return this.popStackConst(this.popDual());
    }

    @Nonnull
    public List<Operand> getStack() {
        return this.stack;
    }

    public void setOperandStack(@Nonnull List<Operand> stack) {
        this.stack = stack;
    }
}

