/*
 * Decompiled with CFR 0.152.
 */
package sootup.java.bytecode.frontend;

import java.util.ArrayList;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import sootup.core.jimple.Jimple;
import sootup.core.jimple.basic.Local;
import sootup.core.jimple.basic.SimpleStmtPositionInfo;
import sootup.core.jimple.basic.StmtPositionInfo;
import sootup.core.jimple.basic.Value;
import sootup.core.jimple.common.stmt.AbstractDefinitionStmt;
import sootup.core.jimple.common.stmt.JAssignStmt;
import sootup.core.jimple.common.stmt.JNopStmt;
import sootup.core.jimple.common.stmt.Stmt;
import sootup.java.bytecode.frontend.AsmMethodSource;
import sootup.java.bytecode.frontend.Operand;
import sootup.java.bytecode.frontend.StmtContainer;

final class StackFrame {
    @Nullable
    private Operand[] out;
    @Nullable
    private Local[] inStackLocals;
    @Nonnull
    private final ArrayList<Operand[]> in = new ArrayList(1);
    @Nonnull
    private final AsmMethodSource src;

    StackFrame(@Nonnull AsmMethodSource src) {
        this.src = src;
    }

    @Nullable
    Operand[] getOut() {
        return this.out;
    }

    void setIn(Operand ... oprs) {
        this.in.clear();
        this.in.add(oprs);
        this.inStackLocals = new Local[oprs.length];
    }

    void setOut(Operand ... oprs) {
        this.out = oprs;
    }

    void mergeIn(int lineNumber, Operand ... oprs) {
        if (this.in.get(0).length != oprs.length) {
            throw new IllegalArgumentException("Invalid in operands length!");
        }
        Object positionInfo = lineNumber > 0 ? new SimpleStmtPositionInfo(lineNumber) : StmtPositionInfo.createNoStmtPositionInfo();
        int nrIn = this.in.size();
        for (int i = 0; i < oprs.length; ++i) {
            int j;
            JAssignStmt as;
            Operand newOp = oprs[i];
            Local stack = this.inStackLocals[i];
            if (stack != null) {
                if (newOp.stackLocal == null) {
                    newOp.stackLocal = stack;
                    JAssignStmt as2 = Jimple.newAssignStmt((Value)stack, (Value)newOp.value, (StmtPositionInfo)positionInfo);
                    this.src.setStmt(newOp.insn, (Stmt)as2);
                    newOp.updateUsages();
                    continue;
                }
                Value rvalue = newOp.stackOrValue();
                if (stack == rvalue) continue;
                as = Jimple.newAssignStmt((Value)stack, (Value)rvalue, (StmtPositionInfo)positionInfo);
                this.src.mergeStmts(newOp.insn, (Stmt)as);
                continue;
            }
            for (j = 0; j != nrIn && (stack = this.in.get((int)j)[i].stackLocal) == null; ++j) {
            }
            if (stack == null && (stack = newOp.stackLocal) == null) {
                stack = this.src.newStackLocal();
            }
            for (j = 0; j != nrIn; ++j) {
                Operand prevOp = this.in.get(j)[i];
                if (prevOp.stackLocal == stack) continue;
                if (prevOp.stackLocal == null) {
                    prevOp.stackLocal = stack;
                    JAssignStmt as3 = Jimple.newAssignStmt((Value)stack, (Value)prevOp.value, (StmtPositionInfo)positionInfo);
                    this.src.setStmt(prevOp.insn, (Stmt)as3);
                } else {
                    Object u = this.src.getStmt(prevOp.insn);
                    AbstractDefinitionStmt as4 = (AbstractDefinitionStmt)(u instanceof StmtContainer ? ((StmtContainer)((Object)u)).getFirstStmt() : u);
                    Value lvb = as4.getLeftOp();
                    assert (lvb == prevOp.stackLocal) : "Invalid stack local!";
                    prevOp.stackLocal = stack;
                }
                prevOp.updateUsages();
            }
            if (newOp.stackLocal != stack) {
                if (newOp.stackLocal == null) {
                    newOp.stackLocal = stack;
                    JAssignStmt as5 = Jimple.newAssignStmt((Value)stack, (Value)newOp.value, (StmtPositionInfo)positionInfo);
                    this.src.setStmt(newOp.insn, (Stmt)as5);
                } else {
                    Object u = this.src.getStmt(newOp.insn);
                    if (!(u instanceof JNopStmt)) {
                        as = (AbstractDefinitionStmt)(u instanceof StmtContainer ? ((StmtContainer)((Object)u)).getFirstStmt() : u);
                        Value lvb = as.getLeftOp();
                        assert (lvb == newOp.stackLocal) : "Invalid stack local!";
                    }
                    newOp.stackLocal = stack;
                }
                newOp.updateUsages();
            }
            this.inStackLocals[i] = stack;
        }
        if (0 < oprs.length) {
            this.in.add(oprs);
        }
    }
}

