/*
 * Decompiled with CFR 0.152.
 */
package sootup.java.bytecode.inputlocation;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.googlecode.dex2jar.tools.Dex2jarCmd;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.jar.Attributes;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import sootup.core.IdentifierFactory;
import sootup.core.frontend.AbstractClassSource;
import sootup.core.frontend.ClassProvider;
import sootup.core.inputlocation.AnalysisInputLocation;
import sootup.core.inputlocation.FileType;
import sootup.core.model.SourceType;
import sootup.core.types.ClassType;
import sootup.core.util.PathUtils;
import sootup.core.util.StreamUtils;
import sootup.core.views.View;
import sootup.java.bytecode.frontend.AsmJavaClassProvider;
import sootup.java.bytecode.frontend.AsmModuleSource;
import sootup.java.bytecode.inputlocation.JavaModulePathAnalysisInputLocation;
import sootup.java.core.JavaModuleInfo;
import sootup.java.core.JavaSootClass;
import sootup.java.core.ModuleInfoAnalysisInputLocation;
import sootup.java.core.signatures.ModuleSignature;
import sootup.java.core.types.JavaClassType;
import sootup.java.core.types.ModuleJavaClassType;

public class PathBasedAnalysisInputLocation
implements AnalysisInputLocation<JavaSootClass> {
    protected Path path;
    private SourceType srcType = null;
    PathBasedAnalysisInputLocation pathBasedAnalysisInputLocationObj;

    public PathBasedAnalysisInputLocation getPathBasedAnalysisInputLocationObj() {
        return this.pathBasedAnalysisInputLocationObj;
    }

    public PathBasedAnalysisInputLocation(@Nonnull Path path) {
        this.path = path;
    }

    public PathBasedAnalysisInputLocation(@Nonnull Path path, @Nullable SourceType srcType) {
        if (Files.isDirectory(path, new LinkOption[0])) {
            this.pathBasedAnalysisInputLocationObj = new DirectoryBasedAnalysisInputLocation(path, srcType);
        } else if (PathUtils.isArchive((Path)path)) {
            this.pathBasedAnalysisInputLocationObj = PathUtils.hasExtension((Path)path, (FileType[])new FileType[]{FileType.WAR}) ? new WarArchiveAnalysisInputLocation(path, srcType) : (PathBasedAnalysisInputLocation.isMultiReleaseJar(path) ? new MultiReleaseJarAnalysisInputLocation(path, srcType) : (PathUtils.hasExtension((Path)path, (FileType[])new FileType[]{FileType.APK}) ? new ApkAnalysisInputLocation(path, srcType) : new ArchiveBasedAnalysisInputLocation(path, srcType)));
        } else {
            throw new IllegalArgumentException("Path '" + path.toAbsolutePath() + "' has to be pointing to the root of a class container, e.g. directory, jar, zip, apk, war etc.");
        }
    }

    public void setSpecifiedAsBuiltInByUser(@Nonnull SourceType srcType) {
        this.srcType = srcType;
    }

    @Nonnull
    public Optional<? extends AbstractClassSource<JavaSootClass>> getClassSource(@Nonnull ClassType type, @Nonnull View<?> view) {
        return this.pathBasedAnalysisInputLocationObj.getClassSource(type, view);
    }

    @Nonnull
    public Collection<? extends AbstractClassSource<JavaSootClass>> getClassSources(@Nonnull View<?> view) {
        return this.pathBasedAnalysisInputLocationObj.getClassSources(view);
    }

    public SourceType getSourceType() {
        return this.srcType;
    }

    private static boolean isMultiReleaseJar(Path path) {
        try {
            FileInputStream inputStream = new FileInputStream(path.toFile());
            JarInputStream jarStream = new JarInputStream(inputStream);
            Manifest mf = jarStream.getManifest();
            if (mf == null) {
                return false;
            }
            Attributes attributes = mf.getMainAttributes();
            String value = attributes.getValue("Multi-Release");
            return Boolean.parseBoolean(value);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return false;
    }

    @Nonnull
    Collection<? extends AbstractClassSource<JavaSootClass>> walkDirectory(@Nonnull Path dirPath, @Nonnull IdentifierFactory factory, @Nonnull ClassProvider<JavaSootClass> classProvider) {
        try {
            FileType handledFileType = classProvider.getHandledFileType();
            String moduleInfoFilename = "module-info.class";
            return Files.walk(dirPath, new FileVisitOption[0]).filter(filePath -> PathUtils.hasExtension((Path)filePath, (FileType[])new FileType[]{handledFileType}) && !filePath.toString().endsWith("module-info.class")).flatMap(p -> StreamUtils.optionalToStream(Optional.of(classProvider.createClassSource((AnalysisInputLocation)this, p, factory.fromPath(dirPath, p))))).collect(Collectors.toList());
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Nonnull
    protected Optional<? extends AbstractClassSource<JavaSootClass>> getClassSourceInternal(@Nonnull JavaClassType signature, @Nonnull Path path, @Nonnull ClassProvider<JavaSootClass> classProvider) {
        Path pathToClass = path.resolve(path.getFileSystem().getPath(signature.getFullyQualifiedName().replace('.', '/') + "." + classProvider.getHandledFileType().getExtension(), new String[0]));
        if (!Files.exists(pathToClass, new LinkOption[0])) {
            return Optional.empty();
        }
        return Optional.of(classProvider.createClassSource((AnalysisInputLocation)this, pathToClass, (ClassType)signature));
    }

    private static final class WarArchiveAnalysisInputLocation
    extends DirectoryBasedAnalysisInputLocation {
        public List<AnalysisInputLocation<JavaSootClass>> containedInputLocations = new ArrayList<AnalysisInputLocation<JavaSootClass>>();
        public static int maxAllowedBytesToExtract = 524288000;

        private WarArchiveAnalysisInputLocation(@Nonnull Path warPath, @Nullable SourceType srcType) {
            super(Paths.get(System.getProperty("java.io.tmpdir") + File.separator + "sootOutput-war" + warPath.hashCode() + "/", new String[0]), srcType);
            Path libDir;
            this.extractWarFile(warPath, this.path);
            Path webInfPath = this.path.resolve("WEB-INF");
            Path classDir = webInfPath.resolve("classes");
            if (Files.exists(classDir, new LinkOption[0])) {
                this.containedInputLocations.add(new DirectoryBasedAnalysisInputLocation(classDir, srcType));
            }
            if (Files.exists(libDir = webInfPath.resolve("lib"), new LinkOption[0])) {
                try {
                    Files.walk(libDir, new FileVisitOption[0]).filter(f -> PathUtils.hasExtension((Path)f, (FileType[])new FileType[]{FileType.JAR})).forEach(f -> this.containedInputLocations.add(new ArchiveBasedAnalysisInputLocation((Path)f, srcType)));
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }

        @Override
        @Nonnull
        public Collection<? extends AbstractClassSource<JavaSootClass>> getClassSources(@Nonnull View<?> view) {
            HashSet foundClasses = new HashSet();
            for (AnalysisInputLocation<JavaSootClass> inputLoc : this.containedInputLocations) {
                foundClasses.addAll(inputLoc.getClassSources(view));
            }
            return foundClasses;
        }

        @Override
        @Nonnull
        public Optional<? extends AbstractClassSource<JavaSootClass>> getClassSource(@Nonnull ClassType type, @Nonnull View<?> view) {
            for (AnalysisInputLocation<JavaSootClass> inputLocation : this.containedInputLocations) {
                Optional classSource = inputLocation.getClassSource(type, view);
                if (!classSource.isPresent()) continue;
                return classSource;
            }
            return Optional.empty();
        }

        protected void extractWarFile(Path warFilePath, Path destDirectory) {
            int extractedSize = 0;
            try {
                ZipEntry zipEntry;
                File dest = destDirectory.toFile();
                if (!dest.exists()) {
                    if (!dest.mkdir()) {
                        throw new RuntimeException("Could not create the directory to extract Warfile: " + destDirectory);
                    }
                    dest.deleteOnExit();
                }
                ZipInputStream zis = new ZipInputStream(new FileInputStream(warFilePath.toString()));
                while ((zipEntry = zis.getNextEntry()) != null) {
                    Path filepath = destDirectory.resolve(zipEntry.getName());
                    File file = filepath.toFile();
                    file.deleteOnExit();
                    if (zipEntry.isDirectory()) {
                        file.mkdir();
                    } else {
                        int readBytesZip;
                        byte[] incomingValues = new byte[4096];
                        if (file.exists()) {
                            BufferedInputStream bis = new BufferedInputStream(new FileInputStream(file));
                            byte[] bisBuf = new byte[4096];
                            while ((readBytesZip = zis.read(incomingValues)) != -1) {
                                if (extractedSize > maxAllowedBytesToExtract) {
                                    throw new RuntimeException("The extracted warfile exceeds the size of " + maxAllowedBytesToExtract + " byte. Either the file is a big archive (-> increase PathBasedAnalysisInputLocation.WarArchiveInputLocation.maxAllowedBytesToExtract) or maybe it contains an archive bomb.");
                                }
                                int readBytesExistingFile = bis.read(bisBuf, 0, readBytesZip);
                                if (readBytesExistingFile != readBytesZip) {
                                    throw new RuntimeException("Can't extract File \"" + file + "\" as it already exists and has a different size.");
                                }
                                if (!Arrays.equals(bisBuf, incomingValues)) {
                                    throw new RuntimeException("Can't extract File \"" + file + "\" as it already exists and has a different content which we can't override.");
                                }
                                extractedSize += readBytesZip;
                            }
                        } else {
                            BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(file));
                            while ((readBytesZip = zis.read(incomingValues)) != -1) {
                                if (extractedSize > maxAllowedBytesToExtract) {
                                    throw new RuntimeException("The extracted warfile exceeds the size of " + maxAllowedBytesToExtract + " byte. Either the file is a big archive or maybe it contains an archive bomb.");
                                }
                                bos.write(incomingValues, 0, readBytesZip);
                                extractedSize += readBytesZip;
                            }
                            bos.close();
                        }
                    }
                    zis.closeEntry();
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Nonnull
        public List<String> retrieveServletClasses(String extractedWARPath) {
            ArrayList<String> classesInXML = new ArrayList<String>();
            try {
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                DocumentBuilder builder = factory.newDocumentBuilder();
                Document document = builder.parse(new File(extractedWARPath + "/WEB-INF/web.xml"));
                document.getDocumentElement().normalize();
                NodeList nList = document.getElementsByTagName("servlet");
                for (int temp = 0; temp < nList.getLength(); ++temp) {
                    Node node = nList.item(temp);
                    if (node.getNodeType() != 1) continue;
                    Element eElement = (Element)node;
                    classesInXML.add(eElement.getElementsByTagName("servlet-class").item(0).getTextContent());
                }
            }
            catch (IOException | ParserConfigurationException | SAXException e) {
                throw new RuntimeException(e);
            }
            return classesInXML;
        }
    }

    private static class ArchiveBasedAnalysisInputLocation
    extends PathBasedAnalysisInputLocation {
        protected static final LoadingCache<Path, FileSystem> fileSystemCache = CacheBuilder.newBuilder().removalListener(removalNotification -> {
            try {
                ((FileSystem)removalNotification.getValue()).close();
            }
            catch (IOException e) {
                throw new RuntimeException("Could not close file system of " + removalNotification.getKey(), e);
            }
        }).expireAfterAccess(1L, TimeUnit.SECONDS).build(CacheLoader.from(path -> {
            try {
                return FileSystems.newFileSystem(Objects.requireNonNull(path), (ClassLoader)null);
            }
            catch (IOException e) {
                throw new RuntimeException("Could not open file system of " + path, e);
            }
        }));

        private ArchiveBasedAnalysisInputLocation(@Nonnull Path path, @Nullable SourceType srcType) {
            super(path);
            super.setSpecifiedAsBuiltInByUser(srcType);
        }

        @Override
        @Nonnull
        public Optional<? extends AbstractClassSource<JavaSootClass>> getClassSource(@Nonnull ClassType type, @Nonnull View<?> view) {
            try {
                FileSystem fs = (FileSystem)fileSystemCache.get((Object)this.path);
                Path archiveRoot = fs.getPath("/", new String[0]);
                return this.getClassSourceInternal((JavaClassType)type, archiveRoot, new AsmJavaClassProvider(view));
            }
            catch (ExecutionException e) {
                throw new RuntimeException("Failed to retrieve file system from cache for " + this.path, e);
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        @Nonnull
        public Collection<? extends AbstractClassSource<JavaSootClass>> getClassSources(@Nonnull View<?> view) {
            try (FileSystem fs = FileSystems.newFileSystem(this.path, (ClassLoader)null);){
                Path archiveRoot = fs.getPath("/", new String[0]);
                Collection<? extends AbstractClassSource<JavaSootClass>> collection = this.walkDirectory(archiveRoot, view.getProject().getIdentifierFactory(), new AsmJavaClassProvider(view));
                return collection;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static class ApkAnalysisInputLocation
    extends ArchiveBasedAnalysisInputLocation {
        private ApkAnalysisInputLocation(@Nonnull Path path, @Nullable SourceType srcType) {
            super(path, srcType);
            String jarPath = this.dex2jar(path);
            this.path = Paths.get(jarPath, new String[0]);
        }

        private String dex2jar(Path path) {
            String apkPath = path.toAbsolutePath().toString();
            String outDir = "./tmp/";
            int start = apkPath.lastIndexOf(File.separator);
            int end = apkPath.lastIndexOf(".apk");
            String outputFile = outDir + apkPath.substring(start + 1, end) + ".jar";
            Dex2jarCmd.main((String[])new String[]{"-f", apkPath, "-o", outputFile});
            return outputFile;
        }
    }

    public static class MultiReleaseJarAnalysisInputLocation
    extends ArchiveBasedAnalysisInputLocation
    implements ModuleInfoAnalysisInputLocation {
        @Nonnull
        private final int[] availableVersions;
        @Nonnull
        private final Map<Integer, Map<ModuleSignature, JavaModuleInfo>> moduleInfoMap = new HashMap<Integer, Map<ModuleSignature, JavaModuleInfo>>();
        @Nonnull
        private final Map<Integer, List<AnalysisInputLocation<JavaSootClass>>> inputLocations = new HashMap<Integer, List<AnalysisInputLocation<JavaSootClass>>>();
        @Nonnull
        private final List<AnalysisInputLocation<JavaSootClass>> baseInputLocations = new ArrayList<AnalysisInputLocation<JavaSootClass>>();
        boolean isResolved = false;

        private MultiReleaseJarAnalysisInputLocation(@Nonnull Path path, @Nullable SourceType srcType) {
            super(path, srcType);
            int[] tmp;
            try {
                FileSystem fs = (FileSystem)fileSystemCache.get((Object)path);
                Path archiveRoot = fs.getPath("/", new String[0]);
                tmp = Files.list(archiveRoot.getFileSystem().getPath("/META-INF/versions/", new String[0])).map(dir -> dir.getFileName().toString().replace("/", "")).mapToInt(Integer::new).sorted().toArray();
            }
            catch (IOException | ExecutionException e) {
                e.printStackTrace();
                tmp = new int[]{};
            }
            this.availableVersions = tmp;
            this.discoverInputLocations(srcType);
        }

        private void discoverInputLocations(@Nullable SourceType srcType) {
            FileSystem fs = null;
            try {
                fs = (FileSystem)fileSystemCache.get((Object)this.path);
            }
            catch (ExecutionException e) {
                e.printStackTrace();
            }
            Path archiveRoot = fs.getPath("/", new String[0]);
            String moduleInfoFilename = "module-info.class";
            this.baseInputLocations.add(new PathBasedAnalysisInputLocation(archiveRoot, srcType));
            String sep = archiveRoot.getFileSystem().getSeparator();
            if (!this.isResolved) {
                for (int i = this.availableVersions.length - 1; i >= 0; --i) {
                    this.inputLocations.put(this.availableVersions[i], new ArrayList());
                    Path versionRoot = archiveRoot.getFileSystem().getPath("/META-INF/versions/" + this.availableVersions[i] + sep, new String[0]);
                    if (this.availableVersions[i] > 8) {
                        this.moduleInfoMap.put(this.availableVersions[i], new HashMap());
                        try (DirectoryStream<Path> stream = Files.newDirectoryStream(versionRoot);){
                            for (Path entry : stream) {
                                JavaModulePathAnalysisInputLocation inputLocation;
                                ModuleSignature moduleSignature;
                                AsmModuleSource moduleInfo;
                                Path mi = this.path.resolve("module-info.class");
                                if (Files.exists(mi, new LinkOption[0])) {
                                    moduleInfo = new AsmModuleSource(mi);
                                    moduleSignature = moduleInfo.getModuleSignature();
                                    inputLocation = new JavaModulePathAnalysisInputLocation(versionRoot.toString(), versionRoot.getFileSystem());
                                    this.inputLocations.get(this.availableVersions[i]).add((AnalysisInputLocation<JavaSootClass>)inputLocation);
                                    this.moduleInfoMap.get(this.availableVersions[i]).put(moduleSignature, moduleInfo);
                                }
                                if (!Files.isDirectory(entry, new LinkOption[0]) || !Files.exists(mi = versionRoot.resolve("module-info.class"), new LinkOption[0])) continue;
                                moduleInfo = new AsmModuleSource(mi);
                                moduleSignature = moduleInfo.getModuleSignature();
                                inputLocation = new JavaModulePathAnalysisInputLocation(versionRoot.toString(), versionRoot.getFileSystem());
                                this.inputLocations.get(this.availableVersions[i]).add((AnalysisInputLocation<JavaSootClass>)inputLocation);
                                this.moduleInfoMap.get(this.availableVersions[i]).put(moduleSignature, moduleInfo);
                            }
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                    if (this.inputLocations.get(this.availableVersions[i]).size() != 0) continue;
                    this.inputLocations.get(this.availableVersions[i]).add(new PathBasedAnalysisInputLocation(versionRoot, srcType));
                }
            }
            this.isResolved = true;
        }

        @Override
        @Nonnull
        public Optional<? extends AbstractClassSource<JavaSootClass>> getClassSource(@Nonnull ClassType type, @Nonnull View<?> view) {
            Collection il = this.getBestMatchingInputLocationsRaw(view.getProject().getLanguage().getVersion());
            Collection baseIl = this.getBaseInputLocations();
            if (type instanceof ModuleJavaClassType) {
                il = il.stream().filter(location -> location instanceof ModuleInfoAnalysisInputLocation).collect(Collectors.toList());
                baseIl = baseIl.stream().filter(location -> location instanceof ModuleInfoAnalysisInputLocation).collect(Collectors.toList());
            } else {
                il = il.stream().filter(location -> !(location instanceof ModuleInfoAnalysisInputLocation)).collect(Collectors.toList());
                baseIl = baseIl.stream().filter(location -> !(location instanceof ModuleInfoAnalysisInputLocation)).collect(Collectors.toList());
            }
            Optional<AbstractClassSource> foundClass = il.stream().map(location -> location.getClassSource(type, view)).filter(Optional::isPresent).limit(1L).map(Optional::get).findAny();
            if (foundClass.isPresent()) {
                return foundClass;
            }
            return baseIl.stream().map(location -> location.getClassSource(type, view)).filter(Optional::isPresent).limit(1L).map(Optional::get).findAny();
        }

        @Nonnull
        public Collection<? extends AbstractClassSource<JavaSootClass>> getModulesClassSources(@Nonnull ModuleSignature moduleSignature, @Nonnull View<?> view) {
            return this.inputLocations.get(view.getProject().getLanguage().getVersion()).stream().filter(location -> location instanceof ModuleInfoAnalysisInputLocation).map(location -> ((ModuleInfoAnalysisInputLocation)location).getModulesClassSources(moduleSignature, view)).flatMap(Collection::stream).collect(Collectors.toList());
        }

        private Collection<AnalysisInputLocation<JavaSootClass>> getBestMatchingInputLocationsRaw(int javaVersion) {
            for (int i = this.availableVersions.length - 1; i >= 0; --i) {
                if (this.availableVersions[i] > javaVersion) continue;
                return new ArrayList<AnalysisInputLocation<JavaSootClass>>((Collection)this.inputLocations.get(this.availableVersions[i]));
            }
            return this.getBaseInputLocations();
        }

        private Collection<AnalysisInputLocation<JavaSootClass>> getBaseInputLocations() {
            return this.baseInputLocations;
        }

        @Override
        @Nonnull
        public Collection<? extends AbstractClassSource<JavaSootClass>> getClassSources(@Nonnull View<?> view) {
            Collection<AnalysisInputLocation<JavaSootClass>> il = this.getBestMatchingInputLocationsRaw(view.getProject().getLanguage().getVersion());
            Collection result = il.stream().map(location -> location.getClassSources(view)).flatMap(Collection::stream).collect(Collectors.toList());
            if (il != this.getBaseInputLocations()) {
                Collection baseSources = this.getBaseInputLocations().stream().map(location -> location.getClassSources(view)).flatMap(Collection::stream).collect(Collectors.toList());
                baseSources.forEach(cs -> {
                    if (result.stream().noneMatch(bestMatchCS -> bestMatchCS.getClassType().getFullyQualifiedName().equals(cs.getClassType().getFullyQualifiedName()))) {
                        result.add(cs);
                    }
                });
            }
            return result;
        }

        @Nonnull
        public Optional<JavaModuleInfo> getModuleInfo(ModuleSignature sig, View<?> view) {
            return Optional.ofNullable(this.moduleInfoMap.get(view.getProject().getLanguage().getVersion()).get(sig));
        }

        @Nonnull
        public Set<ModuleSignature> getModules(View<?> view) {
            return this.inputLocations.get(view.getProject().getLanguage().getVersion()).stream().filter(e -> e instanceof ModuleInfoAnalysisInputLocation).map(e -> ((ModuleInfoAnalysisInputLocation)e).getModules(view)).flatMap(Collection::stream).collect(Collectors.toSet());
        }

        public boolean equals(Object o) {
            if (!(o instanceof PathBasedAnalysisInputLocation)) {
                return false;
            }
            return this.path.equals(((PathBasedAnalysisInputLocation)o).path);
        }

        public int hashCode() {
            return this.path.hashCode();
        }
    }

    private static class DirectoryBasedAnalysisInputLocation
    extends PathBasedAnalysisInputLocation {
        private DirectoryBasedAnalysisInputLocation(@Nonnull Path path, @Nullable SourceType srcType) {
            super(path);
            super.setSpecifiedAsBuiltInByUser(srcType);
        }

        @Override
        @Nonnull
        public Collection<? extends AbstractClassSource<JavaSootClass>> getClassSources(@Nonnull View<?> view) {
            return this.walkDirectory(this.path, view.getIdentifierFactory(), new AsmJavaClassProvider(view));
        }

        @Override
        @Nonnull
        public Optional<? extends AbstractClassSource<JavaSootClass>> getClassSource(@Nonnull ClassType type, @Nonnull View<?> view) {
            return this.getClassSourceInternal((JavaClassType)type, this.path, new AsmJavaClassProvider(view));
        }
    }
}

