/*
 * Decompiled with CFR 0.152.
 */
package sootup.java.bytecode.interceptors.typeresolving;

import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import sootup.core.IdentifierFactory;
import sootup.core.graph.StmtGraph;
import sootup.core.jimple.basic.Immediate;
import sootup.core.jimple.basic.Local;
import sootup.core.jimple.basic.Value;
import sootup.core.jimple.common.constant.ClassConstant;
import sootup.core.jimple.common.constant.DoubleConstant;
import sootup.core.jimple.common.constant.EnumConstant;
import sootup.core.jimple.common.constant.FloatConstant;
import sootup.core.jimple.common.constant.IntConstant;
import sootup.core.jimple.common.constant.LongConstant;
import sootup.core.jimple.common.constant.MethodHandle;
import sootup.core.jimple.common.constant.MethodType;
import sootup.core.jimple.common.constant.NullConstant;
import sootup.core.jimple.common.constant.StringConstant;
import sootup.core.jimple.common.expr.AbstractBinopExpr;
import sootup.core.jimple.common.expr.AbstractConditionExpr;
import sootup.core.jimple.common.expr.AbstractFloatBinopExpr;
import sootup.core.jimple.common.expr.AbstractIntBinopExpr;
import sootup.core.jimple.common.expr.AbstractIntLongBinopExpr;
import sootup.core.jimple.common.expr.AbstractUnopExpr;
import sootup.core.jimple.common.expr.Expr;
import sootup.core.jimple.common.expr.JLengthExpr;
import sootup.core.jimple.common.expr.JShlExpr;
import sootup.core.jimple.common.expr.JShrExpr;
import sootup.core.jimple.common.expr.JUshrExpr;
import sootup.core.jimple.common.ref.JArrayRef;
import sootup.core.jimple.common.ref.JCaughtExceptionRef;
import sootup.core.jimple.common.ref.JFieldRef;
import sootup.core.jimple.common.ref.JParameterRef;
import sootup.core.jimple.common.ref.JThisRef;
import sootup.core.jimple.common.ref.Ref;
import sootup.core.jimple.common.stmt.Stmt;
import sootup.core.model.SootClass;
import sootup.core.typehierarchy.ViewTypeHierarchy;
import sootup.core.types.ArrayType;
import sootup.core.types.ClassType;
import sootup.core.types.PrimitiveType;
import sootup.core.types.Type;
import sootup.core.views.View;
import sootup.java.bytecode.interceptors.typeresolving.PrimitiveHierarchy;
import sootup.java.bytecode.interceptors.typeresolving.Typing;
import sootup.java.bytecode.interceptors.typeresolving.types.AugIntegerTypes;
import sootup.java.bytecode.interceptors.typeresolving.types.BottomType;
import sootup.java.core.JavaIdentifierFactory;

public class AugEvalFunction {
    IdentifierFactory factory = JavaIdentifierFactory.getInstance();
    View<? extends SootClass<?>> view;
    PrimitiveHierarchy primitiveHierarchy = new PrimitiveHierarchy();

    public AugEvalFunction(View<? extends SootClass<?>> view) {
        this.view = view;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Type evaluate(@Nonnull Typing typing, @Nonnull Value value, @Nonnull Stmt stmt, @Nonnull StmtGraph<?> graph) {
        if (value instanceof Immediate) {
            if (value instanceof Local) {
                return typing.getType((Local)value);
            }
            if (value instanceof IntConstant) {
                int val = ((IntConstant)value).getValue();
                if (val >= 0 && val < 2) {
                    return AugIntegerTypes.getInteger1();
                }
                if (val >= 2 && val < 128) {
                    return AugIntegerTypes.getInteger127();
                }
                if (val >= -128 && val < 0) {
                    return PrimitiveType.getByte();
                }
                if (val >= 128 && val < 32768) {
                    return AugIntegerTypes.getInteger32767();
                }
                if (val >= Short.MIN_VALUE && val < -128) {
                    return PrimitiveType.getShort();
                }
                if (val < 32768) return PrimitiveType.getInt();
                if (val >= 65536) return PrimitiveType.getInt();
                return PrimitiveType.getChar();
            }
            if (value instanceof LongConstant) return value.getType();
            if (value instanceof FloatConstant) return value.getType();
            if (value instanceof DoubleConstant) return value.getType();
            if (value instanceof NullConstant) return value.getType();
            if (value instanceof EnumConstant) {
                return value.getType();
            }
            if (value instanceof StringConstant) {
                return this.factory.getClassType("java.lang.String");
            }
            if (value instanceof ClassConstant) {
                return this.factory.getClassType("java.lang.Class");
            }
            if (value instanceof MethodHandle) {
                return this.factory.getClassType("java.lang.MethodHandle");
            }
            if (!(value instanceof MethodType)) throw new RuntimeException("Invaluable constant in AugEvalFunction: " + value);
            return this.factory.getClassType("java.lang.MethodType");
        }
        if (value instanceof Expr) {
            if (value instanceof AbstractBinopExpr) {
                Type tl = this.evaluate(typing, (Value)((AbstractBinopExpr)value).getOp1(), stmt, graph);
                Type tr = this.evaluate(typing, (Value)((AbstractBinopExpr)value).getOp2(), stmt, graph);
                if (value instanceof AbstractIntBinopExpr) {
                    if (!(value instanceof AbstractConditionExpr)) return PrimitiveType.getByte();
                    return PrimitiveType.getBoolean();
                }
                if (value instanceof AbstractIntLongBinopExpr) {
                    if (value instanceof JShlExpr || value instanceof JShrExpr || value instanceof JUshrExpr) {
                        return tl instanceof PrimitiveType.IntType ? PrimitiveType.getInt() : tl;
                    }
                    if (!(tl instanceof PrimitiveType.IntType) || !(tr instanceof PrimitiveType.IntType)) return tl instanceof PrimitiveType.LongType ? PrimitiveType.getLong() : tr;
                    if (tl instanceof PrimitiveType.BooleanType) {
                        return tr instanceof PrimitiveType.BooleanType ? PrimitiveType.getBoolean() : tr;
                    }
                    if (tr instanceof PrimitiveType.BooleanType) {
                        return tl;
                    }
                    Collection<Type> set = this.primitiveHierarchy.getLeastCommonAncestor(tl, tr);
                    if (!set.isEmpty()) return set.iterator().next();
                    throw new RuntimeException("Invaluable expression by using AugEvalFunction: " + value);
                }
                if (!(value instanceof AbstractFloatBinopExpr)) return null;
                return tl instanceof PrimitiveType.IntType ? PrimitiveType.getInt() : tl;
            }
            if (!(value instanceof AbstractUnopExpr)) return value.getType();
            Type opt = this.evaluate(typing, (Value)((AbstractUnopExpr)value).getOp(), stmt, graph);
            if (!(value instanceof JLengthExpr)) return opt instanceof PrimitiveType.IntType ? PrimitiveType.getInt() : opt;
            return PrimitiveType.getInt();
        }
        if (!(value instanceof Ref)) return null;
        if (value instanceof JCaughtExceptionRef) {
            Set<ClassType> exceptionTypes = this.getExceptionTypeCandidates(stmt, graph);
            ClassType throwable = this.factory.getClassType("java.lang.Throwable");
            ClassType type = null;
            for (ClassType exceptionType : exceptionTypes) {
                Optional exceptionClassOp = this.view.getClass(exceptionType);
                if (!exceptionClassOp.isPresent()) throw new RuntimeException("ExceptionType: \"" + exceptionType + "\" is not in the view");
                SootClass exceptionClass = (SootClass)exceptionClassOp.get();
                if (exceptionClass.isPhantomClass()) {
                    return throwable;
                }
                if (type == null) {
                    type = exceptionType;
                    continue;
                }
                type = this.getLeastCommonExceptionType(type, exceptionType);
            }
            if (type != null) return type;
            throw new RuntimeException("Invaluable reference in AugEvalFunction: " + value);
        }
        if (value instanceof JArrayRef) {
            String name;
            Type type = typing.getType(((JArrayRef)value).getBase());
            if (type instanceof ArrayType) {
                return ((ArrayType)type).getElementType();
            }
            if (!(type instanceof ClassType)) return BottomType.getInstance();
            switch (name = ((ClassType)type).getFullyQualifiedName()) {
                case "java.lang.Object": {
                    return this.factory.getClassType("java.lang.Object");
                }
                case "java.lang.Cloneable": {
                    return this.factory.getClassType("java.lang.Cloneable");
                }
                case "java.io.Serializable": {
                    return this.factory.getClassType("java.io.Serializable");
                }
                default: {
                    return BottomType.getInstance();
                }
            }
        }
        if (value instanceof JThisRef) return value.getType();
        if (value instanceof JParameterRef) return value.getType();
        if (!(value instanceof JFieldRef)) throw new RuntimeException("Invaluable reference in AugEvalFunction: " + value);
        return value.getType();
    }

    private Set<ClassType> getExceptionTypeCandidates(@Nonnull Stmt handlerStmt, @Nonnull StmtGraph<?> graph) {
        return graph.getBlockOf(handlerStmt).getExceptionalPredecessors().keySet();
    }

    private Deque<ClassType> getExceptionPath(@Nonnull ClassType exceptionType) {
        ViewTypeHierarchy hierarchy = new ViewTypeHierarchy(this.view);
        ClassType throwable = this.factory.getClassType("java.lang.Throwable");
        ArrayDeque<ClassType> path = new ArrayDeque<ClassType>();
        path.push(exceptionType);
        while (!exceptionType.equals((Object)throwable)) {
            ClassType superType = hierarchy.directSuperClassOf(exceptionType);
            if (superType != null) {
                path.push(superType);
                exceptionType = superType;
                continue;
            }
            throw new RuntimeException("The path from " + exceptionType + " to java.lang.Throwable cannot be found!");
        }
        return path;
    }

    private ClassType getLeastCommonExceptionType(@Nonnull ClassType a, @Nonnull ClassType b) {
        if (a.equals((Object)b)) {
            return a;
        }
        ClassType commonType = null;
        Deque<ClassType> pathA = this.getExceptionPath(a);
        Deque<ClassType> pathB = this.getExceptionPath(b);
        while (!pathA.isEmpty() && !pathB.isEmpty() && pathA.getFirst().equals((Object)pathB.getFirst())) {
            commonType = pathA.removeFirst();
            pathB.removeFirst();
        }
        return commonType;
    }
}

