/*
 * Decompiled with CFR 0.152.
 */
package sootup.java.bytecode.interceptors.typeresolving;

import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import sootup.core.IdentifierFactory;
import sootup.core.model.SootClass;
import sootup.core.typehierarchy.ViewTypeHierarchy;
import sootup.core.types.ArrayType;
import sootup.core.types.ClassType;
import sootup.core.types.NullType;
import sootup.core.types.PrimitiveType;
import sootup.core.types.Type;
import sootup.core.views.View;
import sootup.java.bytecode.interceptors.typeresolving.IHierarchy;
import sootup.java.bytecode.interceptors.typeresolving.PrimitiveHierarchy;
import sootup.java.bytecode.interceptors.typeresolving.types.BottomType;

public class BytecodeHierarchy
implements IHierarchy {
    private final ViewTypeHierarchy typeHierarchy;
    private final ClassType object;
    private final ClassType serializable;
    private final ClassType cloneable;
    private final PrimitiveHierarchy primitiveHierarchy;

    public BytecodeHierarchy(View<? extends SootClass<?>> view) {
        this.typeHierarchy = new ViewTypeHierarchy(view);
        IdentifierFactory factory = view.getIdentifierFactory();
        this.object = factory.getClassType("java.lang.Object");
        this.serializable = factory.getClassType("java.io.Serializable");
        this.cloneable = factory.getClassType("java.lang.Cloneable");
        this.primitiveHierarchy = new PrimitiveHierarchy();
    }

    @Override
    public boolean isAncestor(@Nonnull Type ancestor, @Nonnull Type child) {
        boolean isAncestor = this.primitiveHierarchy.isAncestor(ancestor, child);
        if (!isAncestor && !this.primitiveHierarchy.arePrimitives(ancestor, child)) {
            if (ancestor.equals(child)) {
                isAncestor = true;
            } else if (child instanceof BottomType) {
                isAncestor = true;
            } else {
                if (ancestor instanceof BottomType) {
                    return false;
                }
                if (ancestor instanceof PrimitiveType || child instanceof PrimitiveType) {
                    return false;
                }
                if (child instanceof NullType) {
                    isAncestor = true;
                } else {
                    if (ancestor instanceof NullType) {
                        return false;
                    }
                    if (child instanceof ClassType && ancestor instanceof ClassType) {
                        isAncestor = this.canStoreType((ClassType)ancestor, (ClassType)child);
                    } else if (child instanceof ArrayType && ancestor instanceof ClassType) {
                        isAncestor = ancestor.equals(this.object) || ancestor.equals(this.serializable) || ancestor.equals(this.cloneable);
                    } else if (child instanceof ArrayType && ancestor instanceof ArrayType) {
                        ArrayType anArr = (ArrayType)ancestor;
                        ArrayType chArr = (ArrayType)child;
                        Type anBase = anArr.getBaseType();
                        Type chBase = chArr.getBaseType();
                        if (anArr.getDimension() == chArr.getDimension()) {
                            if (anBase.equals(chBase)) {
                                isAncestor = true;
                            } else if (anBase instanceof ClassType && chBase instanceof ClassType) {
                                isAncestor = this.canStoreType((ClassType)anBase, (ClassType)chBase);
                            }
                        } else if (anArr.getDimension() < chArr.getDimension()) {
                            isAncestor = anBase.equals(this.object) || anBase.equals(this.serializable) || anBase.equals(this.cloneable);
                        }
                    }
                }
            }
        }
        return isAncestor;
    }

    @Override
    public Collection<Type> getLeastCommonAncestor(Type a, Type b) {
        HashSet<Type> ret = new HashSet<Type>();
        if (a instanceof BottomType) {
            return Collections.singleton(b);
        }
        if (b instanceof BottomType) {
            return Collections.singleton(a);
        }
        if (a instanceof NullType) {
            return Collections.singleton(b);
        }
        if (b instanceof NullType) {
            return Collections.singleton(a);
        }
        if (this.isAncestor(a, b)) {
            return Collections.singleton(a);
        }
        if (this.isAncestor(b, a)) {
            return Collections.singleton(b);
        }
        if (a instanceof PrimitiveType && b instanceof PrimitiveType) {
            return this.primitiveHierarchy.getLeastCommonAncestor(a, b);
        }
        if (a instanceof PrimitiveType || b instanceof PrimitiveType) {
            return Collections.emptySet();
        }
        if (a instanceof ArrayType && b instanceof ArrayType) {
            Type et_a = ((ArrayType)a).getElementType();
            Type et_b = ((ArrayType)b).getElementType();
            Collection<Object> temp = et_a instanceof PrimitiveType || et_b instanceof PrimitiveType ? Collections.emptySet() : this.getLeastCommonAncestor(et_a, et_b);
            if (temp.isEmpty()) {
                ret.add((Type)this.object);
                ret.add((Type)this.serializable);
                ret.add((Type)this.cloneable);
            } else {
                for (Type type : temp) {
                    ret.add((Type)Type.makeArrayType((Type)type, (int)1));
                }
            }
        } else if (a instanceof ArrayType || b instanceof ArrayType) {
            ClassType nonArray = (ClassType)(a instanceof ArrayType ? b : a);
            if (!nonArray.getFullyQualifiedName().equals("java.lang.Object")) {
                if (this.isAncestor((Type)this.serializable, (Type)nonArray)) {
                    ret.add((Type)this.serializable);
                }
                if (this.isAncestor((Type)this.cloneable, (Type)nonArray)) {
                    ret.add((Type)this.cloneable);
                }
            }
            if (ret.isEmpty()) {
                ret.add((Type)this.object);
            }
        } else {
            Set<AncestryPath> pathsA = this.buildAncestryPaths((ClassType)a);
            Set<AncestryPath> pathsB = this.buildAncestryPaths((ClassType)b);
            for (AncestryPath pathA : pathsA) {
                for (AncestryPath pathB : pathsB) {
                    ClassType lcn = this.leastCommonNode(pathA, pathB);
                    if (lcn == null) continue;
                    boolean isLcn = true;
                    for (Type l : ret) {
                        if (this.isAncestor((Type)lcn, l)) {
                            isLcn = false;
                            break;
                        }
                        if (!this.isAncestor(l, (Type)lcn)) continue;
                        ret.remove(l);
                    }
                    if (!isLcn) continue;
                    ret.add((Type)lcn);
                }
            }
            if (ret.isEmpty()) {
                ret.add((Type)this.object);
            }
        }
        return ret;
    }

    private boolean canStoreType(ClassType ancestor, ClassType child) {
        if (ancestor.equals((Object)this.object)) {
            return true;
        }
        return this.typeHierarchy.subtypesOf(ancestor).contains(child);
    }

    private Set<AncestryPath> buildAncestryPaths(ClassType type) {
        ArrayDeque<AncestryPath> pathNodes = new ArrayDeque<AncestryPath>();
        pathNodes.add(new AncestryPath(type, null));
        HashSet<AncestryPath> paths = new HashSet<AncestryPath>();
        while (!pathNodes.isEmpty()) {
            AncestryPath superNode;
            Set superInterfaces;
            AncestryPath node = (AncestryPath)pathNodes.removeFirst();
            if (node.type.getFullyQualifiedName().equals("java.lang.Object")) {
                paths.add(node);
                continue;
            }
            if (this.typeHierarchy.isInterface(node.type)) {
                superInterfaces = this.typeHierarchy.directlyExtendedInterfacesOf(node.type);
                if (superInterfaces.isEmpty()) {
                    paths.add(node);
                    continue;
                }
                for (ClassType superInterface : superInterfaces) {
                    superNode = new AncestryPath(superInterface, node);
                    pathNodes.add(superNode);
                }
                continue;
            }
            superInterfaces = this.typeHierarchy.directlyImplementedInterfacesOf(node.type);
            for (ClassType superInterface : superInterfaces) {
                superNode = new AncestryPath(superInterface, node);
                pathNodes.add(superNode);
            }
            ClassType superClass = this.typeHierarchy.directSuperClassOf(node.type);
            AncestryPath superNode2 = new AncestryPath(superClass, node);
            pathNodes.add(superNode2);
        }
        return paths;
    }

    @Nullable
    private ClassType leastCommonNode(AncestryPath a, AncestryPath b) {
        ClassType lcn = null;
        while (a != null && b != null && a.type.equals((Object)b.type)) {
            lcn = a.type;
            a = a.next;
            b = b.next;
        }
        return lcn;
    }

    private static class AncestryPath {
        public AncestryPath next;
        public ClassType type;

        public AncestryPath(@Nonnull ClassType type, @Nullable AncestryPath next) {
            this.type = type;
            this.next = next;
        }
    }
}

