/*
 * Decompiled with CFR 0.152.
 */
package sootup.java.bytecode.interceptors.typeresolving;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import sootup.core.jimple.Jimple;
import sootup.core.jimple.basic.Immediate;
import sootup.core.jimple.basic.Local;
import sootup.core.jimple.basic.StmtPositionInfo;
import sootup.core.jimple.basic.Value;
import sootup.core.jimple.common.ref.JArrayRef;
import sootup.core.jimple.common.stmt.AbstractDefinitionStmt;
import sootup.core.jimple.common.stmt.JAssignStmt;
import sootup.core.jimple.common.stmt.Stmt;
import sootup.core.jimple.visitor.Visitor;
import sootup.core.model.Body;
import sootup.core.types.Type;
import sootup.java.bytecode.interceptors.typeresolving.AugEvalFunction;
import sootup.java.bytecode.interceptors.typeresolving.BytecodeHierarchy;
import sootup.java.bytecode.interceptors.typeresolving.TypeChecker;
import sootup.java.bytecode.interceptors.typeresolving.Typing;

public class CastCounter
extends TypeChecker {
    private int castCount = 0;
    private boolean countOnly;
    private final Map<Stmt, Map<Value, Value>> changedValues = new HashMap<Stmt, Map<Value, Value>>();
    private int newLocalsCount = 0;
    public Map<Stmt, Stmt> stmt2NewStmt = new HashMap<Stmt, Stmt>();

    public CastCounter(@Nonnull Body.BodyBuilder builder, @Nonnull AugEvalFunction evalFunction, @Nonnull BytecodeHierarchy hierarchy) {
        super(builder, evalFunction, hierarchy);
    }

    public int getCastCount(@Nonnull Typing typing) {
        this.castCount = 0;
        this.countOnly = true;
        this.setTyping(typing);
        for (Stmt stmt : this.builder.getStmts()) {
            stmt.accept((Visitor)this);
        }
        return this.castCount;
    }

    public int getCastCount() {
        return this.castCount;
    }

    public void insertCastStmts(@Nonnull Typing typing) {
        this.castCount = 0;
        this.countOnly = false;
        this.setTyping(typing);
        for (Stmt stmt : this.builder.getStmts()) {
            stmt.accept((Visitor)this);
        }
    }

    @Override
    public void visit(@Nonnull Value value, @Nonnull Type stdType, @Nonnull Stmt stmt) {
        AugEvalFunction evalFunction = this.getFuntion();
        BytecodeHierarchy hierarchy = this.getHierarchy();
        Typing typing = this.getTyping();
        if (this.countOnly) {
            Type evaType = evalFunction.evaluate(typing, value, stmt, this.graph);
            if (hierarchy.isAncestor(stdType, evaType)) {
                return;
            }
            ++this.castCount;
        } else {
            Local old_local;
            Type evaType;
            Value updatedValue;
            Map<Value, Value> m;
            Stmt oriStmt = stmt;
            Value oriValue = value;
            Stmt updatedStmt = this.stmt2NewStmt.get(stmt);
            if (updatedStmt != null) {
                stmt = this.stmt2NewStmt.get(stmt);
            }
            if ((m = this.changedValues.get(oriStmt)) != null && (updatedValue = m.get(value)) != null) {
                value = updatedValue;
            }
            if (hierarchy.isAncestor(stdType, evaType = evalFunction.evaluate(typing, value, stmt, this.graph))) {
                return;
            }
            ++this.castCount;
            if (value instanceof Local) {
                old_local = (Local)value;
            } else {
                old_local = this.generateTempLocal(evaType);
                this.builder.addLocal(old_local);
                typing.set(old_local, evaType);
                JAssignStmt newAssign = Jimple.newAssignStmt((Value)old_local, (Value)value, (StmtPositionInfo)stmt.getPositionInfo());
                this.builder.insertBefore(stmt, (Stmt)newAssign);
            }
            Local new_local = this.generateTempLocal(stdType);
            this.builder.addLocal(new_local);
            typing.set(new_local, stdType);
            this.addUpdatedValue(oriValue, (Value)new_local, oriStmt);
            JAssignStmt newCast = Jimple.newAssignStmt((Value)new_local, (Value)Jimple.newCastExpr((Immediate)old_local, (Type)stdType), (StmtPositionInfo)stmt.getPositionInfo());
            this.builder.insertBefore(stmt, (Stmt)newCast);
            Stmt newStmt = stmt.getUses().contains(value) ? stmt.withNewUse(value, (Value)new_local) : ((AbstractDefinitionStmt)stmt).withNewDef(new_local);
            this.builder.replaceStmt(stmt, newStmt);
            this.stmt2NewStmt.put(oriStmt, newStmt);
        }
    }

    private void addUpdatedValue(Value oldValue, Value newValue, Stmt stmt) {
        Map<Object, Object> map;
        if (!this.changedValues.containsKey(stmt)) {
            map = new HashMap();
            this.changedValues.put(stmt, map);
        } else {
            map = this.changedValues.get(stmt);
        }
        map.put(oldValue, newValue);
        if (stmt instanceof JAssignStmt && stmt.containsArrayRef()) {
            Value leftOp = ((JAssignStmt)stmt).getLeftOp();
            Value rightOp = ((JAssignStmt)stmt).getRightOp();
            if (leftOp instanceof JArrayRef) {
                if (oldValue == leftOp) {
                    Local base = ((JArrayRef)oldValue).getBase();
                    Local nBase = ((JArrayRef)newValue).getBase();
                    map.put(base, nBase);
                } else if (leftOp.getUses().contains(oldValue)) {
                    JArrayRef nArrRef = ((JArrayRef)leftOp).withBase((Local)newValue);
                    map.put(leftOp, nArrRef);
                }
            } else if (rightOp instanceof JArrayRef) {
                if (oldValue == rightOp) {
                    Local base = ((JArrayRef)oldValue).getBase();
                    Local nBase = ((JArrayRef)newValue).getBase();
                    map.put(base, nBase);
                } else if (rightOp.getUses().contains(oldValue)) {
                    JArrayRef nArrRef = ((JArrayRef)rightOp).withBase((Local)newValue);
                    map.put(rightOp, nArrRef);
                }
            }
        }
    }

    private Local generateTempLocal(@Nonnull Type type) {
        String name = "#l" + this.newLocalsCount++;
        return Jimple.newLocal((String)name, (Type)type);
    }
}

