/*
 * Decompiled with CFR 0.152.
 */
package sootup.java.bytecode.interceptors.typeresolving;

import java.util.Collection;
import java.util.Collections;
import javax.annotation.Nonnull;
import sootup.core.types.ArrayType;
import sootup.core.types.PrimitiveType;
import sootup.core.types.Type;
import sootup.java.bytecode.interceptors.typeresolving.IHierarchy;
import sootup.java.bytecode.interceptors.typeresolving.types.AugIntegerTypes;
import sootup.java.bytecode.interceptors.typeresolving.types.BottomType;

public class PrimitiveHierarchy
implements IHierarchy {
    @Override
    @Nonnull
    public Collection<Type> getLeastCommonAncestor(@Nonnull Type a, @Nonnull Type b) {
        if (a.equals(b)) {
            return Collections.singleton(a);
        }
        if (this.arePrimitives(a, b)) {
            if (this.isAncestor(a, b)) {
                return Collections.singleton(a);
            }
            if (this.isAncestor(b, a)) {
                return Collections.singleton(b);
            }
            if (a instanceof PrimitiveType.ByteType) {
                if (b instanceof PrimitiveType.ShortType || b instanceof PrimitiveType.CharType || b instanceof AugIntegerTypes.Integer32767Type) {
                    return Collections.singleton(PrimitiveType.getInt());
                }
                return Collections.emptySet();
            }
            if (a instanceof PrimitiveType.ShortType) {
                if (b instanceof PrimitiveType.ByteType || b instanceof PrimitiveType.CharType) {
                    return Collections.singleton(PrimitiveType.getInt());
                }
                return Collections.emptySet();
            }
            if (a instanceof PrimitiveType.CharType) {
                if (b instanceof PrimitiveType.ByteType || b instanceof PrimitiveType.ShortType) {
                    return Collections.singleton(PrimitiveType.getInt());
                }
                return Collections.emptySet();
            }
            return Collections.emptySet();
        }
        return Collections.emptySet();
    }

    @Override
    public boolean isAncestor(@Nonnull Type ancestor, @Nonnull Type child) {
        if (ancestor.equals(child)) {
            return true;
        }
        if (this.arePrimitives(ancestor, child)) {
            if (ancestor instanceof AugIntegerTypes.Integer1Type) {
                return child instanceof BottomType;
            }
            if (ancestor instanceof PrimitiveType.BooleanType || ancestor instanceof AugIntegerTypes.Integer127Type) {
                return child instanceof AugIntegerTypes.Integer1Type || child instanceof BottomType;
            }
            if (ancestor instanceof PrimitiveType.ByteType || ancestor instanceof AugIntegerTypes.Integer32767Type) {
                return child instanceof AugIntegerTypes.Integer127Type || child instanceof AugIntegerTypes.Integer1Type || child instanceof BottomType;
            }
            if (ancestor instanceof PrimitiveType.CharType || ancestor instanceof PrimitiveType.ShortType) {
                return child instanceof AugIntegerTypes.Integer32767Type || child instanceof AugIntegerTypes.Integer127Type || child instanceof AugIntegerTypes.Integer1Type || child instanceof BottomType;
            }
            if (ancestor instanceof PrimitiveType.IntType) {
                return !(child instanceof PrimitiveType.BooleanType) && child instanceof PrimitiveType.IntType || child instanceof BottomType;
            }
            return child instanceof BottomType;
        }
        if (ancestor instanceof ArrayType && child instanceof ArrayType) {
            int childDim;
            Type ancestorBase = ((ArrayType)ancestor).getBaseType();
            Type childBase = ((ArrayType)child).getBaseType();
            int ancestorDim = ((ArrayType)ancestor).getDimension();
            if (ancestorDim == (childDim = ((ArrayType)child).getDimension()) && this.arePrimitives(ancestorBase, childBase)) {
                if (ancestorBase instanceof AugIntegerTypes.Integer1Type) {
                    return childBase instanceof BottomType;
                }
                if (ancestorBase instanceof PrimitiveType.BooleanType || ancestorBase instanceof AugIntegerTypes.Integer127Type) {
                    return childBase instanceof AugIntegerTypes.Integer1Type || childBase instanceof BottomType;
                }
                if (ancestorBase instanceof PrimitiveType.ByteType || ancestorBase instanceof AugIntegerTypes.Integer32767Type) {
                    return childBase instanceof AugIntegerTypes.Integer127Type || childBase instanceof AugIntegerTypes.Integer1Type || childBase instanceof BottomType;
                }
                if (ancestorBase instanceof PrimitiveType.IntType) {
                    return childBase instanceof AugIntegerTypes.Integer32767Type || childBase instanceof AugIntegerTypes.Integer127Type || childBase instanceof AugIntegerTypes.Integer1Type || childBase instanceof BottomType;
                }
                return childBase instanceof BottomType;
            }
            return childBase instanceof BottomType;
        }
        return child instanceof BottomType;
    }

    public boolean arePrimitives(Type a, Type b) {
        if (a instanceof PrimitiveType || a instanceof BottomType) {
            return b instanceof PrimitiveType || b instanceof BottomType;
        }
        return false;
    }
}

