/*
 * Decompiled with CFR 0.152.
 */
package sootup.java.bytecode.interceptors.typeresolving;

import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sootup.core.jimple.basic.Local;
import sootup.core.jimple.basic.Value;
import sootup.core.jimple.common.stmt.Stmt;
import sootup.core.jimple.visitor.Visitor;
import sootup.core.model.Body;
import sootup.core.types.PrimitiveType;
import sootup.core.types.Type;
import sootup.java.bytecode.interceptors.typeresolving.AugEvalFunction;
import sootup.java.bytecode.interceptors.typeresolving.BytecodeHierarchy;
import sootup.java.bytecode.interceptors.typeresolving.TypeChecker;
import sootup.java.bytecode.interceptors.typeresolving.Typing;
import sootup.java.bytecode.interceptors.typeresolving.types.AugIntegerTypes;

public class TypePromotionVisitor
extends TypeChecker {
    private boolean failed = false;
    private boolean typingChanged = true;
    private static final Logger logger = LoggerFactory.getLogger(TypePromotionVisitor.class);

    public TypePromotionVisitor(@Nonnull Body.BodyBuilder builder, @Nonnull AugEvalFunction evalFunction, @Nonnull BytecodeHierarchy hierarchy) {
        super(builder, evalFunction, hierarchy);
    }

    public Typing getPromotedTyping(Typing typing) {
        this.setTyping(typing);
        this.failed = false;
        while (this.typingChanged && !this.failed) {
            this.typingChanged = false;
            for (Stmt stmt : this.builder.getStmts()) {
                stmt.accept((Visitor)this);
            }
        }
        if (this.failed) {
            return null;
        }
        return this.getTyping();
    }

    public static boolean isIntermediateType(Type type) {
        return type.equals((Object)AugIntegerTypes.getInteger1()) || type.equals((Object)AugIntegerTypes.getInteger127()) || type.equals((Object)AugIntegerTypes.getInteger32767());
    }

    @Override
    public void visit(@Nonnull Value value, @Nonnull Type stdType, @Nonnull Stmt stmt) {
        AugEvalFunction evalFunction = this.getFuntion();
        BytecodeHierarchy hierarchy = this.getHierarchy();
        Typing typing = this.getTyping();
        Type evaType = evalFunction.evaluate(typing, value, stmt, this.graph);
        if (evaType.equals(stdType)) {
            return;
        }
        if (!hierarchy.isAncestor(stdType, evaType)) {
            logger.error(stdType + " is not compatible with the value '" + value + "' in the statement: '" + stmt + "' !");
            this.failed = true;
        } else if (value instanceof Local && TypePromotionVisitor.isIntermediateType(evaType)) {
            Local local = (Local)value;
            Type promotedType = this.promote(evaType, stdType);
            if (promotedType != null && !promotedType.equals(evaType)) {
                typing.set(local, promotedType);
                this.typingChanged = true;
            }
        }
    }

    private Type promote(Type low, Type high) {
        Class<?> lowClass = low.getClass();
        Class<?> highClass = high.getClass();
        if (lowClass == AugIntegerTypes.Integer1Type.class) {
            if (highClass == PrimitiveType.IntType.class) {
                return AugIntegerTypes.getInteger127();
            }
            if (highClass == PrimitiveType.ShortType.class) {
                return PrimitiveType.getByte();
            }
            if (highClass == PrimitiveType.BooleanType.class || highClass == PrimitiveType.ByteType.class || highClass == PrimitiveType.CharType.class || highClass == AugIntegerTypes.Integer127Type.class || highClass == AugIntegerTypes.Integer32767Type.class) {
                return high;
            }
            logger.error(low + " cannot be promoted with the supertype " + high + "!");
            return null;
        }
        if (lowClass == AugIntegerTypes.Integer127Type.class) {
            if (highClass == PrimitiveType.ShortType.class) {
                return PrimitiveType.getByte();
            }
            if (highClass == PrimitiveType.IntType.class) {
                return AugIntegerTypes.getInteger127();
            }
            if (highClass == PrimitiveType.ByteType.class || highClass == PrimitiveType.CharType.class || highClass == AugIntegerTypes.Integer32767Type.class) {
                return high;
            }
            logger.error(low + " cannot be promoted with the supertype " + high + "!");
            return null;
        }
        if (lowClass == AugIntegerTypes.Integer32767Type.class) {
            if (highClass == PrimitiveType.IntType.class) {
                return AugIntegerTypes.getInteger32767();
            }
            if (highClass == PrimitiveType.ShortType.class || highClass == PrimitiveType.CharType.class) {
                return high;
            }
            logger.error(low + " cannot be promoted with the supertype " + high + "!");
            return null;
        }
        logger.error(low + " cannot be promoted with the supertype " + high + "!");
        return null;
    }
}

