/*
 * Decompiled with CFR 0.152.
 */
package sootup.java.bytecode.frontend;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.MethodNode;
import sootup.core.IdentifierFactory;
import sootup.core.frontend.BodySource;
import sootup.core.frontend.ResolveException;
import sootup.core.inputlocation.AnalysisInputLocation;
import sootup.core.jimple.basic.NoPositionInformation;
import sootup.core.model.ClassModifier;
import sootup.core.model.FieldModifier;
import sootup.core.model.MethodModifier;
import sootup.core.model.Position;
import sootup.core.model.SootField;
import sootup.core.model.SootMethod;
import sootup.core.signatures.FieldSignature;
import sootup.core.signatures.MethodSignature;
import sootup.core.types.ClassType;
import sootup.core.types.Type;
import sootup.java.bytecode.frontend.AsmMethodSource;
import sootup.java.bytecode.frontend.AsmUtil;
import sootup.java.core.AnnotationUsage;
import sootup.java.core.JavaAnnotationSootClassSource;
import sootup.java.core.JavaAnnotationSootMethod;
import sootup.java.core.JavaIdentifierFactory;
import sootup.java.core.JavaSootField;
import sootup.java.core.types.JavaClassType;

public class AsmAnnotationClassSource
extends JavaAnnotationSootClassSource {
    @Nonnull
    protected final ClassNode classNode;

    public AsmAnnotationClassSource(AnalysisInputLocation inputLocation, Path sourcePath, JavaClassType javaClassType, @Nonnull ClassNode classNode) {
        super(inputLocation, (ClassType)javaClassType, sourcePath);
        this.classNode = classNode;
    }

    private static Set<JavaSootField> resolveFields(List<FieldNode> fieldNodes, IdentifierFactory signatureFactory, ClassType classSignature) {
        return fieldNodes.stream().map(fieldNode -> {
            String fieldName = fieldNode.name;
            Type fieldType = AsmUtil.toJimpleType(fieldNode.desc);
            FieldSignature fieldSignature = signatureFactory.getFieldSignature(fieldName, classSignature, fieldType);
            EnumSet<FieldModifier> modifiers = AsmUtil.getFieldModifiers(fieldNode.access);
            return new JavaSootField(fieldSignature, modifiers, AsmAnnotationClassSource.convertAnnotation(fieldNode.invisibleAnnotations), (Position)NoPositionInformation.getInstance());
        }).collect(Collectors.toSet());
    }

    @Nonnull
    public Collection<? extends SootMethod> resolveMethods() throws ResolveException {
        JavaIdentifierFactory identifierFactory = JavaIdentifierFactory.getInstance();
        return AsmAnnotationClassSource.resolveMethods(this.classNode.methods, (IdentifierFactory)identifierFactory, this.classSignature).collect(Collectors.toSet());
    }

    private static Stream<JavaAnnotationSootMethod> resolveMethods(List<MethodNode> methodNodes, IdentifierFactory signatureFactory, ClassType cs) {
        return methodNodes.stream().map(methodSource -> {
            AsmMethodSource asmClassClassSourceContent = (AsmMethodSource)((Object)methodSource);
            asmClassClassSourceContent.setDeclaringClass(cs);
            ArrayList<JavaClassType> exceptions = new ArrayList<JavaClassType>();
            exceptions.addAll(AsmUtil.asmIdToSignature(methodSource.exceptions));
            String methodName = methodSource.name;
            EnumSet<MethodModifier> modifiers = AsmUtil.getMethodModifiers(methodSource.access);
            List<Type> sigTypes = AsmUtil.toJimpleSignatureDesc(methodSource.desc);
            Type retType = sigTypes.remove(sigTypes.size() - 1);
            MethodSignature methodSignature = signatureFactory.getMethodSignature(cs, methodName, retType, sigTypes);
            ArrayList<AnnotationNode> annotations = new ArrayList<AnnotationNode>();
            if (methodSource.visibleAnnotations != null) {
                annotations.addAll(methodSource.visibleAnnotations);
            }
            if (methodSource.invisibleAnnotations != null) {
                annotations.addAll(methodSource.invisibleAnnotations);
            }
            return new JavaAnnotationSootMethod((BodySource)asmClassClassSourceContent, methodSignature, modifiers, exceptions, AsmAnnotationClassSource.convertAnnotation(annotations), (Position)NoPositionInformation.getInstance());
        });
    }

    protected static List<AnnotationUsage> convertAnnotation(List<AnnotationNode> nodes) {
        if (nodes == null) {
            return Collections.emptyList();
        }
        return StreamSupport.stream(AsmUtil.createAnnotationUsage(nodes).spliterator(), false).collect(Collectors.toList());
    }

    protected Iterable<AnnotationUsage> resolveAnnotations() {
        ArrayList<AnnotationNode> annotationNodes = new ArrayList<AnnotationNode>();
        annotationNodes.addAll(this.classNode.visibleAnnotations != null ? this.classNode.visibleAnnotations : Collections.emptyList());
        annotationNodes.addAll(this.classNode.visibleTypeAnnotations != null ? this.classNode.visibleTypeAnnotations : Collections.emptyList());
        annotationNodes.addAll(this.classNode.invisibleAnnotations != null ? this.classNode.invisibleAnnotations : Collections.emptyList());
        annotationNodes.addAll(this.classNode.invisibleTypeAnnotations != null ? this.classNode.invisibleTypeAnnotations : Collections.emptyList());
        return AsmAnnotationClassSource.convertAnnotation(annotationNodes);
    }

    @Nonnull
    public Collection<? extends SootField> resolveFields() throws ResolveException {
        JavaIdentifierFactory identifierFactory = JavaIdentifierFactory.getInstance();
        return AsmAnnotationClassSource.resolveFields(this.classNode.fields, (IdentifierFactory)identifierFactory, this.classSignature);
    }

    @Nonnull
    public EnumSet<ClassModifier> resolveModifiers() {
        return AsmUtil.getClassModifiers(this.classNode.access);
    }

    @Nonnull
    public Set<? extends ClassType> resolveInterfaces() {
        return new HashSet<JavaClassType>(AsmUtil.asmIdToSignature(this.classNode.interfaces));
    }

    @Nonnull
    public Optional<? extends ClassType> resolveSuperclass() {
        if (this.classNode.superName == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(AsmUtil.toJimpleClassType(this.classNode.superName));
    }

    @Nonnull
    public Optional<? extends ClassType> resolveOuterClass() {
        if (this.classNode.outerClass == null) {
            return Optional.empty();
        }
        return Optional.of(AsmUtil.toJimpleClassType(this.classNode.outerClass));
    }

    @Nonnull
    public Position resolvePosition() {
        return NoPositionInformation.getInstance();
    }

    public String toString() {
        return this.getSourcePath().toString();
    }
}

