/*
 * Decompiled with CFR 0.152.
 */
package sootup.java.bytecode.frontend;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.TryCatchBlockNode;
import sootup.java.bytecode.frontend.Operand;

class BranchedInsnInfo {
    @Nonnull
    private final AbstractInsnNode insn;
    @Nonnull
    private final LinkedList<Operand[]> prevStacks;
    @Nullable
    private final List<List<Operand>> operandStacks = new ArrayList<List<Operand>>();
    private final int lineNumber;
    private final Set<TryCatchBlockNode> activeTrapHandlers;

    BranchedInsnInfo(@Nonnull AbstractInsnNode insn, @Nonnull List<Operand> operands, int lineNumber, Set<TryCatchBlockNode> activeTrapHandlers) {
        this.insn = insn;
        this.prevStacks = new LinkedList();
        this.operandStacks.add(operands);
        this.lineNumber = lineNumber;
        this.activeTrapHandlers = new HashSet<TryCatchBlockNode>(activeTrapHandlers);
    }

    @Nonnull
    public AbstractInsnNode getInsn() {
        return this.insn;
    }

    @Nonnull
    public List<List<Operand>> getOperandStacks() {
        return this.operandStacks;
    }

    public void addOperandStack(@Nullable List<Operand> operandStack) {
        this.operandStacks.add(operandStack);
    }

    @Nonnull
    public LinkedList<Operand[]> getPrevStacks() {
        return this.prevStacks;
    }

    public void addToPrevStack(@Nonnull Operand[] stacksOperands) {
        this.prevStacks.add(stacksOperands);
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public Set<TryCatchBlockNode> getActiveTrapHandlers() {
        return this.activeTrapHandlers;
    }
}

