/*
 * Decompiled with CFR 0.152.
 */
package sootup.java.bytecode.interceptors;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import javax.annotation.Nonnull;
import sootup.core.graph.BasicBlock;
import sootup.core.graph.DominanceFinder;
import sootup.core.graph.DominanceTree;
import sootup.core.graph.MutableStmtGraph;
import sootup.core.graph.StmtGraph;
import sootup.core.jimple.basic.LValue;
import sootup.core.jimple.basic.Local;
import sootup.core.jimple.basic.StmtPositionInfo;
import sootup.core.jimple.basic.Value;
import sootup.core.jimple.common.expr.JPhiExpr;
import sootup.core.jimple.common.stmt.AbstractDefinitionStmt;
import sootup.core.jimple.common.stmt.FallsThroughStmt;
import sootup.core.jimple.common.stmt.JAssignStmt;
import sootup.core.jimple.common.stmt.Stmt;
import sootup.core.model.Body;
import sootup.core.transform.BodyInterceptor;
import sootup.core.views.View;

public class StaticSingleAssignmentFormer
implements BodyInterceptor {
    public void interceptBody(@Nonnull Body.BodyBuilder builder, @Nonnull View view) {
        LinkedHashSet<Local> newLocals = new LinkedHashSet<Local>(builder.getLocals());
        int nextFreeIdx = 0;
        MutableStmtGraph stmtGraph = builder.getStmtGraph();
        HashMap blockToDefs = new HashMap();
        HashMap localToBlocks = new HashMap();
        for (BasicBlock block : stmtGraph.getBlocks()) {
            HashSet<Local> defs = new HashSet<Local>();
            for (Object stmt : block.getStmts()) {
                if (stmt.getDefs().isEmpty() || !(stmt.getDefs().get(0) instanceof Local)) continue;
                Local local = (Local)stmt.getDefs().get(0);
                defs.add(local);
                if (localToBlocks.containsKey(local)) {
                    ((Set)localToBlocks.get(local)).add(block);
                    continue;
                }
                HashSet<BasicBlock> bs = new HashSet<BasicBlock>();
                bs.add(block);
                localToBlocks.put(local, bs);
            }
            blockToDefs.put(block, defs);
        }
        DominanceFinder dominanceFinder = new DominanceFinder((StmtGraph)stmtGraph);
        Map<BasicBlock<?>, Set<FallsThroughStmt>> blockToPhiStmts = this.decideBlockToPhiStmts(builder, dominanceFinder, blockToDefs, localToBlocks);
        this.addPhiStmts(blockToPhiStmts, stmtGraph, blockToDefs);
        DominanceTree tree = new DominanceTree(dominanceFinder);
        HashMap localToNameStack = new HashMap();
        for (Local local : builder.getLocals()) {
            localToNameStack.put(local, new Stack());
        }
        List treeNodes = tree.getAllNodesDFS();
        ArrayList<BasicBlock> blockStack = new ArrayList<BasicBlock>();
        HashSet visited = new HashSet();
        block3: for (BasicBlock block : treeNodes) {
            Object stmt22;
            HashSet<Object> newPhiStmts = new HashSet();
            for (Object stmt22 : block.getStmts()) {
                List defs;
                Stmt newStmt;
                List uses = stmt22.getUses();
                if (!uses.isEmpty() && !this.constainsPhiExpr((Stmt)stmt22)) {
                    for (Value use : uses) {
                        if (!(use instanceof Local)) continue;
                        Local local = (Local)((Stack)localToNameStack.get(use)).peek();
                        newStmt = stmt22.withNewUse(use, (Value)local);
                        stmtGraph.replaceNode((Stmt)stmt22, newStmt);
                        stmt22 = newStmt;
                    }
                }
                if ((defs = stmt22.getDefs()).isEmpty() || !(defs.get(0) instanceof Local)) continue;
                Local def = (Local)defs.get(0);
                Local local = def.withName(def.getName() + "#" + nextFreeIdx);
                newLocals.add(local);
                ++nextFreeIdx;
                ((Stack)localToNameStack.get(def)).push(local);
                newStmt = ((AbstractDefinitionStmt)stmt22).withNewDef(local);
                stmtGraph.replaceNode((Stmt)stmt22, newStmt);
                if (!this.constainsPhiExpr(newStmt)) continue;
                newPhiStmts.add(newStmt);
            }
            visited.add(block);
            blockStack.add(block);
            if (blockToPhiStmts.containsKey(block)) {
                blockToPhiStmts.put(block, newPhiStmts);
            }
            ArrayList succs = new ArrayList(block.getSuccessors());
            succs.addAll(block.getExceptionalSuccessors().values());
            stmt22 = succs.iterator();
            while (stmt22.hasNext()) {
                BasicBlock succ = (BasicBlock)stmt22.next();
                if (!blockToPhiStmts.containsKey(succ)) continue;
                Set<FallsThroughStmt> phiStmts = blockToPhiStmts.get(succ);
                newPhiStmts = new HashSet<FallsThroughStmt>(phiStmts);
                for (Stmt stmt : phiStmts) {
                    Local def = (Local)stmt.getDefs().get(0);
                    Local oriDef = this.getOriginalLocal(def, localToNameStack.keySet());
                    if (((Stack)localToNameStack.get(oriDef)).isEmpty()) continue;
                    Local arg = (Local)((Stack)localToNameStack.get(oriDef)).peek();
                    FallsThroughStmt newPhiStmt = this.addNewArgToPhi(stmt, arg, block);
                    newPhiStmts.remove(stmt);
                    newPhiStmts.add(newPhiStmt);
                    stmtGraph.replaceNode(stmt, (Stmt)newPhiStmt);
                }
                blockToPhiStmts.put(succ, newPhiStmts);
            }
            BasicBlock top = (BasicBlock)blockStack.get(blockStack.size() - 1);
            List children = tree.getChildren(top);
            while (this.containsAllChildren(visited, children)) {
                blockStack.remove(blockStack.size() - 1);
                for (Stmt stmt3 : top.getStmts()) {
                    Local local;
                    Local oriDef;
                    if (stmt3.getDefs().isEmpty() || !(stmt3.getDefs().get(0) instanceof Local) || ((Stack)localToNameStack.get(oriDef = this.getOriginalLocal(local = (Local)stmt3.getDefs().get(0), localToNameStack.keySet()))).isEmpty()) continue;
                    ((Stack)localToNameStack.get(oriDef)).pop();
                }
                if (blockStack.isEmpty()) continue block3;
                top = (BasicBlock)blockStack.get(blockStack.size() - 1);
                children = tree.getChildren(top);
            }
        }
        builder.setLocals(newLocals);
    }

    private Map<BasicBlock<?>, Set<FallsThroughStmt>> decideBlockToPhiStmts(Body.BodyBuilder builder, DominanceFinder dominanceFinder, Map<BasicBlock<?>, Set<Local>> blockToDefs, Map<Local, Set<BasicBlock<?>>> localToBlocks) {
        HashMap blockToPhiStmts = new HashMap();
        HashMap blockToPhiLocals = new HashMap();
        HashMap localToPhiBlocks = new HashMap();
        for (Local local : builder.getLocals()) {
            localToPhiBlocks.put(local, new HashSet());
            ArrayDeque<BasicBlock> blocks = new ArrayDeque<BasicBlock>((Collection)localToBlocks.get(local));
            while (!blocks.isEmpty()) {
                BasicBlock block = (BasicBlock)blocks.removeFirst();
                Set dfs = dominanceFinder.getDominanceFrontiers(block);
                for (BasicBlock df : dfs) {
                    Set basicBlocks = (Set)localToPhiBlocks.get(local);
                    if (basicBlocks.contains(df)) continue;
                    basicBlocks.add(df);
                    JAssignStmt phiStmt = this.createEmptyPhiStmt(local);
                    if (blockToPhiStmts.containsKey(df)) {
                        ((Set)blockToPhiStmts.get(df)).add(phiStmt);
                        ((Set)blockToPhiLocals.get(df)).add(local);
                    } else {
                        LinkedHashSet<JAssignStmt> phiStmts = new LinkedHashSet<JAssignStmt>();
                        phiStmts.add(phiStmt);
                        blockToPhiStmts.put(df, phiStmts);
                        HashSet<Local> phiLocals = new HashSet<Local>();
                        phiLocals.add(local);
                        blockToPhiLocals.put(df, phiLocals);
                    }
                    if (blockToDefs.get(df).contains(local)) continue;
                    blocks.add(df);
                }
            }
        }
        for (BasicBlock block : blockToPhiLocals.keySet()) {
            blockToDefs.get(block).addAll((Collection)blockToPhiLocals.get(block));
        }
        return blockToPhiStmts;
    }

    private void addPhiStmts(Map<BasicBlock<?>, Set<FallsThroughStmt>> blockToPhiStmts, MutableStmtGraph blockGraph, Map<BasicBlock<?>, Set<Local>> blockToDefs) {
        HashMap<Stmt, Integer> phiToNum = new HashMap<Stmt, Integer>();
        for (BasicBlock basicBlock : blockGraph.getBlocks()) {
            ArrayList succs = new ArrayList(basicBlock.getSuccessors());
            succs.addAll(basicBlock.getExceptionalSuccessors().values());
            for (BasicBlock succ : succs) {
                if (!blockToPhiStmts.containsKey(succ)) continue;
                for (Stmt stmt : blockToPhiStmts.get(succ)) {
                    Local local = (Local)stmt.getDefs().get(0);
                    if (!blockToDefs.get(basicBlock).contains(local)) continue;
                    if (phiToNum.containsKey(stmt)) {
                        int num = (Integer)phiToNum.get(stmt);
                        phiToNum.replace(stmt, num + 1);
                        continue;
                    }
                    phiToNum.put(stmt, 1);
                }
            }
        }
        for (BasicBlock basicBlock : blockToPhiStmts.keySet()) {
            Set<FallsThroughStmt> phis = blockToPhiStmts.get(basicBlock);
            HashSet checkedPhis = new HashSet(blockToPhiStmts.get(basicBlock));
            for (FallsThroughStmt cphi : checkedPhis) {
                if ((Integer)phiToNum.get(cphi) >= 2) continue;
                phis.remove(cphi);
            }
            for (FallsThroughStmt phi : phis) {
                blockGraph.insertBefore(basicBlock.getHead(), phi);
            }
        }
    }

    private boolean containsAllChildren(Set<BasicBlock<?>> blockSet, List<BasicBlock<?>> children) {
        for (BasicBlock<?> child : children) {
            if (blockSet.contains(child)) continue;
            return false;
        }
        return true;
    }

    private boolean constainsPhiExpr(Stmt stmt) {
        if (stmt instanceof JAssignStmt && !stmt.getUses().isEmpty()) {
            for (Value use : stmt.getUses()) {
                if (!(use instanceof JPhiExpr)) continue;
                return true;
            }
        }
        return false;
    }

    private JAssignStmt createEmptyPhiStmt(Local local) {
        JPhiExpr phi = new JPhiExpr(Collections.emptyList(), Collections.emptyMap());
        return new JAssignStmt((LValue)local, (Value)phi, StmtPositionInfo.getNoStmtPositionInfo());
    }

    private Local getOriginalLocal(Local local, Set<Local> oriLocals) {
        if (oriLocals.contains(local)) {
            return local;
        }
        int hashPos = local.getName().indexOf(35);
        String oriName = local.getName().substring(0, hashPos);
        for (Local oriLocal : oriLocals) {
            if (!oriLocal.getName().equals(oriName)) continue;
            return oriLocal;
        }
        throw new RuntimeException(local + " has no original local!");
    }

    private FallsThroughStmt addNewArgToPhi(Stmt phiStmt, Local arg, BasicBlock<?> block) {
        JAssignStmt newPhiStmt = null;
        for (Value use : phiStmt.getUses()) {
            if (!(use instanceof JPhiExpr)) continue;
            JPhiExpr newPhiExpr = (JPhiExpr)use;
            List args = ((JPhiExpr)use).getArgs();
            Map argToBlock = ((JPhiExpr)use).getArgToBlockMap();
            args.add(arg);
            argToBlock.put(arg, block);
            newPhiExpr = newPhiExpr.withArgs(args);
            newPhiExpr = newPhiExpr.withArgToBlockMap(argToBlock);
            newPhiStmt = ((JAssignStmt)phiStmt).withRValue((Value)newPhiExpr);
            break;
        }
        return newPhiStmt;
    }
}

