/*
 * Decompiled with CFR 0.152.
 */
package sootup.java.bytecode.interceptors;

import java.util.ArrayDeque;
import java.util.HashSet;
import javax.annotation.Nonnull;
import sootup.core.graph.MutableStmtGraph;
import sootup.core.jimple.common.stmt.Stmt;
import sootup.core.model.Body;
import sootup.core.transform.BodyInterceptor;
import sootup.core.views.View;

public class UnreachableCodeEliminator
implements BodyInterceptor {
    public void interceptBody(@Nonnull Body.BodyBuilder builder, @Nonnull View view) {
        MutableStmtGraph graph = builder.getStmtGraph();
        ArrayDeque<Stmt> queue = new ArrayDeque<Stmt>();
        queue.add(graph.getStartingStmt());
        HashSet<Stmt> reachableStmts = new HashSet<Stmt>();
        while (!queue.isEmpty()) {
            Stmt stmt = (Stmt)queue.removeFirst();
            reachableStmts.add(stmt);
            for (Stmt succ : graph.getAllSuccessors(stmt)) {
                if (reachableStmts.contains(succ)) continue;
                queue.add(succ);
            }
        }
        ArrayDeque<Stmt> removeQ = new ArrayDeque<Stmt>();
        for (Stmt stmt : graph.getNodes()) {
            if (reachableStmts.contains(stmt)) continue;
            removeQ.add(stmt);
        }
        for (Stmt stmt : removeQ) {
            graph.removeNode(stmt);
        }
    }
}

