/*
 * Decompiled with CFR 0.152.
 */
package sootup.java.bytecode.interceptors.typeresolving;

import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import sootup.core.IdentifierFactory;
import sootup.core.typehierarchy.TypeHierarchy;
import sootup.core.types.ArrayType;
import sootup.core.types.ClassType;
import sootup.core.types.NullType;
import sootup.core.types.PrimitiveType;
import sootup.core.types.Type;
import sootup.core.views.View;
import sootup.java.bytecode.interceptors.typeresolving.PrimitiveHierarchy;
import sootup.java.bytecode.interceptors.typeresolving.types.BottomType;

public class BytecodeHierarchy {
    private final TypeHierarchy typeHierarchy;
    public final ClassType objectClassType;
    public final ClassType throwableClassType;
    private final ClassType serializableClassType;
    private final ClassType cloneableClassType;

    public BytecodeHierarchy(View view) {
        this.typeHierarchy = view.getTypeHierarchy();
        IdentifierFactory factory = view.getIdentifierFactory();
        this.objectClassType = factory.getClassType("java.lang.Object");
        this.throwableClassType = factory.getClassType("java.lang.Throwable");
        this.serializableClassType = factory.getClassType("java.io.Serializable");
        this.cloneableClassType = factory.getClassType("java.lang.Cloneable");
    }

    boolean contains(ClassType type) {
        return this.typeHierarchy.contains(type);
    }

    public boolean isAncestor(@Nonnull Type ancestor, @Nonnull Type child) {
        if (PrimitiveHierarchy.isAncestor(ancestor, child)) {
            return true;
        }
        if (!PrimitiveHierarchy.arePrimitives(ancestor, child)) {
            if (ancestor == child) {
                return true;
            }
            if (child.getClass() == BottomType.class) {
                return true;
            }
            if (ancestor.getClass() == BottomType.class) {
                return false;
            }
            if (ancestor instanceof PrimitiveType || child instanceof PrimitiveType) {
                return false;
            }
            if (child == NullType.getInstance()) {
                return true;
            }
            if (ancestor == NullType.getInstance()) {
                return false;
            }
            if (child instanceof ClassType && ancestor instanceof ClassType) {
                return this.canStoreType((ClassType)ancestor, (ClassType)child);
            }
            if (child instanceof ArrayType && ancestor instanceof ClassType) {
                return ancestor == this.objectClassType || ancestor == this.serializableClassType || ancestor == this.cloneableClassType;
            }
            if (child instanceof ArrayType && ancestor instanceof ArrayType) {
                ArrayType ancestorArr = (ArrayType)ancestor;
                ArrayType childArr = (ArrayType)child;
                Type ancestorBase = ancestorArr.getBaseType();
                Type childBase = childArr.getBaseType();
                if (ancestorArr.getDimension() == childArr.getDimension()) {
                    if (ancestorBase == childBase) {
                        return true;
                    }
                    if (ancestorBase instanceof ClassType && childBase instanceof ClassType) {
                        return this.canStoreType((ClassType)ancestorBase, (ClassType)childBase);
                    }
                } else if (ancestorArr.getDimension() < childArr.getDimension()) {
                    return ancestorBase == this.objectClassType || ancestorBase == this.serializableClassType || ancestorBase == this.cloneableClassType;
                }
            }
        }
        return false;
    }

    public Collection<Type> getLeastCommonAncestor(Type a, Type b) {
        HashSet<Type> ret = new HashSet<Type>();
        if (a instanceof BottomType) {
            return Collections.singleton(b);
        }
        if (b instanceof BottomType) {
            return Collections.singleton(a);
        }
        if (a == NullType.getInstance()) {
            return Collections.singleton(b);
        }
        if (b == NullType.getInstance()) {
            return Collections.singleton(a);
        }
        if (this.isAncestor(a, b)) {
            return Collections.singleton(a);
        }
        if (this.isAncestor(b, a)) {
            return Collections.singleton(b);
        }
        if (a instanceof PrimitiveType && b instanceof PrimitiveType) {
            return PrimitiveHierarchy.getLeastCommonAncestor(a, b);
        }
        if (a instanceof PrimitiveType || b instanceof PrimitiveType) {
            return Collections.emptySet();
        }
        if (a instanceof ArrayType && b instanceof ArrayType) {
            Type et_a = ((ArrayType)a).getElementType();
            Type et_b = ((ArrayType)b).getElementType();
            Collection<Object> temp = et_a instanceof PrimitiveType || et_b instanceof PrimitiveType ? Collections.emptySet() : this.getLeastCommonAncestor(et_a, et_b);
            if (temp.isEmpty()) {
                ret.add((Type)this.objectClassType);
                ret.add((Type)this.serializableClassType);
                ret.add((Type)this.cloneableClassType);
            } else {
                for (Type type : temp) {
                    ret.add((Type)Type.createArrayType((Type)type, (int)1));
                }
            }
        } else if (a instanceof ArrayType || b instanceof ArrayType) {
            ClassType nonArray = (ClassType)(a instanceof ArrayType ? b : a);
            if (!nonArray.getFullyQualifiedName().equals("java.lang.Object")) {
                if (this.isAncestor((Type)this.serializableClassType, (Type)nonArray)) {
                    ret.add((Type)this.serializableClassType);
                }
                if (this.isAncestor((Type)this.cloneableClassType, (Type)nonArray)) {
                    ret.add((Type)this.cloneableClassType);
                }
            }
            if (ret.isEmpty()) {
                ret.add((Type)this.objectClassType);
            }
        } else {
            Set<AncestryPath> pathsA = this.buildAncestryPaths((ClassType)a);
            Set<AncestryPath> pathsB = this.buildAncestryPaths((ClassType)b);
            for (AncestryPath pathA : pathsA) {
                for (AncestryPath pathB : pathsB) {
                    ClassType lcn = this.leastCommonNode(pathA, pathB);
                    if (lcn == null) continue;
                    boolean isLcn = true;
                    for (Type l : ret) {
                        if (this.isAncestor((Type)lcn, l)) {
                            isLcn = false;
                            break;
                        }
                        if (!this.isAncestor(l, (Type)lcn)) continue;
                        ret.remove(l);
                    }
                    if (!isLcn) continue;
                    ret.add((Type)lcn);
                }
            }
            if (ret.isEmpty()) {
                ret.add((Type)this.objectClassType);
            }
        }
        return ret;
    }

    private boolean canStoreType(ClassType ancestor, ClassType child) {
        return ancestor == this.objectClassType || this.typeHierarchy.contains(ancestor) && this.typeHierarchy.subtypesOf(ancestor).contains(child);
    }

    private Set<AncestryPath> buildAncestryPaths(ClassType type) {
        ArrayDeque<AncestryPath> pathNodes = new ArrayDeque<AncestryPath>();
        pathNodes.add(new AncestryPath(type, null));
        HashSet<AncestryPath> paths = new HashSet<AncestryPath>();
        while (!pathNodes.isEmpty()) {
            ClassType superClass;
            Set superInterfaces;
            AncestryPath node = (AncestryPath)pathNodes.removeFirst();
            if (!this.typeHierarchy.contains(node.type)) break;
            if (node.type == this.objectClassType) {
                paths.add(node);
                continue;
            }
            if (this.typeHierarchy.isInterface(node.type)) {
                superInterfaces = this.typeHierarchy.directlyExtendedInterfacesOf(node.type);
                if (superInterfaces.isEmpty()) {
                    paths.add(node);
                    continue;
                }
                for (ClassType superInterface : superInterfaces) {
                    AncestryPath superNode = new AncestryPath(superInterface, node);
                    pathNodes.add(superNode);
                }
                continue;
            }
            try {
                superInterfaces = this.typeHierarchy.directlyImplementedInterfacesOf(node.type);
                superClass = this.typeHierarchy.superClassOf(node.type);
            }
            catch (IllegalArgumentException iae) {
                continue;
            }
            for (ClassType superInterface : superInterfaces) {
                AncestryPath superNode = new AncestryPath(superInterface, node);
                pathNodes.add(superNode);
            }
            if (superClass == null) continue;
            AncestryPath superNode = new AncestryPath(superClass, node);
            pathNodes.add(superNode);
        }
        return paths;
    }

    @Nullable
    private ClassType leastCommonNode(AncestryPath a, AncestryPath b) {
        ClassType lcn = null;
        while (a != null && b != null && a.type == b.type) {
            lcn = a.type;
            a = a.next;
            b = b.next;
        }
        return lcn;
    }

    private static class AncestryPath {
        public AncestryPath next;
        public ClassType type;

        public AncestryPath(@Nonnull ClassType type, @Nullable AncestryPath next) {
            this.type = type;
            this.next = next;
        }
    }
}

