/*
 * Decompiled with CFR 0.152.
 */
package sootup.java.bytecode.interceptors.typeresolving;

import com.google.common.collect.Lists;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import sootup.core.graph.StmtGraph;
import sootup.core.jimple.basic.Immediate;
import sootup.core.jimple.basic.LValue;
import sootup.core.jimple.basic.Local;
import sootup.core.jimple.basic.Value;
import sootup.core.jimple.common.expr.AbstractBinopExpr;
import sootup.core.jimple.common.expr.JCastExpr;
import sootup.core.jimple.common.expr.JNegExpr;
import sootup.core.jimple.common.ref.JArrayRef;
import sootup.core.jimple.common.stmt.AbstractDefinitionStmt;
import sootup.core.jimple.common.stmt.Stmt;
import sootup.core.model.Body;
import sootup.core.types.ArrayType;
import sootup.core.types.ClassType;
import sootup.core.types.PrimitiveType;
import sootup.core.types.Type;
import sootup.core.views.View;
import sootup.java.bytecode.interceptors.typeresolving.AugEvalFunction;
import sootup.java.bytecode.interceptors.typeresolving.BytecodeHierarchy;
import sootup.java.bytecode.interceptors.typeresolving.CastCounter;
import sootup.java.bytecode.interceptors.typeresolving.TypePromotionVisitor;
import sootup.java.bytecode.interceptors.typeresolving.Typing;
import sootup.java.bytecode.interceptors.typeresolving.types.AugmentIntegerTypes;
import sootup.java.bytecode.interceptors.typeresolving.types.BottomType;
import sootup.java.core.JavaIdentifierFactory;
import sootup.java.core.views.JavaView;

public class TypeResolver {
    private final ArrayList<AbstractDefinitionStmt> assignments = new ArrayList();
    private final Map<Local, BitSet> depends = new HashMap<Local, BitSet>();
    private final JavaView view;
    private int castCount;

    public TypeResolver(@Nonnull JavaView view) {
        this.view = view;
    }

    public boolean resolve(@Nonnull Body.BodyBuilder builder) {
        TypePromotionVisitor promotionVisitor;
        Typing promotedTyping;
        this.init(builder);
        BytecodeHierarchy hierarchy = new BytecodeHierarchy((View)this.view);
        AugEvalFunction evalFunction = new AugEvalFunction((View)this.view);
        ArrayList locals = Lists.newArrayList((Iterable)builder.getLocals());
        Typing iniTyping = new Typing(locals);
        Collection<Typing> typings = this.applyAssignmentConstraint((StmtGraph<?>)builder.getStmtGraph(), iniTyping, evalFunction, hierarchy);
        if (typings.isEmpty()) {
            return false;
        }
        Typing minCastsTyping = this.getMinCastsTyping(builder, typings, evalFunction, hierarchy);
        if (this.castCount > 0) {
            CastCounter castCounter = new CastCounter(builder, evalFunction, hierarchy);
            castCounter.insertCastStmts(minCastsTyping);
        }
        if ((promotedTyping = (promotionVisitor = new TypePromotionVisitor(builder, evalFunction, hierarchy)).getPromotedTyping(minCastsTyping)) == null) {
            return false;
        }
        for (Local local : locals) {
            Type convertedType;
            Type type = promotedTyping.getType(local);
            if (type == null || (convertedType = this.convertType(type)) == null) continue;
            promotedTyping.set(local, convertedType);
        }
        for (Local local : locals) {
            Type oldType = local.getType();
            Type newType = promotedTyping.getType(local);
            if (newType == null || oldType.equals(newType) || newType instanceof BottomType) continue;
            Local newLocal = local.withType(newType);
            builder.replaceLocal(local, newLocal);
        }
        return true;
    }

    private void init(Body.BodyBuilder builder) {
        for (Stmt stmt : builder.getStmts()) {
            AbstractDefinitionStmt defStmt;
            LValue lhs;
            if (!(stmt instanceof AbstractDefinitionStmt) || !((lhs = (defStmt = (AbstractDefinitionStmt)stmt).getLeftOp()) instanceof Local) && !(lhs instanceof JArrayRef)) continue;
            int id = this.assignments.size();
            this.assignments.add(defStmt);
            this.addDependsForRHS(defStmt.getRightOp(), id);
        }
    }

    private void addDependsForRHS(Value rhs, int id) {
        if (rhs instanceof Local) {
            this.addDependency((Local)rhs, id);
        } else if (rhs instanceof AbstractBinopExpr) {
            Immediate op1 = ((AbstractBinopExpr)rhs).getOp1();
            Immediate op2 = ((AbstractBinopExpr)rhs).getOp2();
            if (op1 instanceof Local) {
                this.addDependency((Local)op1, id);
            }
            if (op2 instanceof Local) {
                this.addDependency((Local)op2, id);
            }
        } else if (rhs instanceof JNegExpr) {
            Immediate op = ((JNegExpr)rhs).getOp();
            if (op instanceof Local) {
                this.addDependency((Local)op, id);
            }
        } else if (rhs instanceof JCastExpr) {
            Immediate op = ((JCastExpr)rhs).getOp();
            if (op instanceof Local) {
                this.addDependency((Local)op, id);
            }
        } else if (rhs instanceof JArrayRef) {
            Local base = ((JArrayRef)rhs).getBase();
            this.addDependency(base, id);
        }
    }

    private void addDependency(@Nonnull Local local, int id) {
        BitSet bitSet = this.depends.get(local);
        if (bitSet == null) {
            bitSet = new BitSet();
            this.depends.put(local, bitSet);
        }
        bitSet.set(id);
    }

    private Collection<Typing> applyAssignmentConstraint(@Nonnull StmtGraph<?> graph, @Nonnull Typing typing, @Nonnull AugEvalFunction evalFunction, @Nonnull BytecodeHierarchy hierarchy) {
        int numOfAssigns = this.assignments.size();
        if (numOfAssigns == 0) {
            return Collections.emptyList();
        }
        ArrayDeque<Typing> workQueue = new ArrayDeque<Typing>();
        ArrayList<Typing> ret = new ArrayList<Typing>();
        BitSet stmtsList = new BitSet(numOfAssigns);
        stmtsList.set(0, numOfAssigns);
        typing.setStmtsIDList(stmtsList);
        workQueue.add(typing);
        while (!workQueue.isEmpty()) {
            Local local;
            Typing actualTyping = (Typing)workQueue.getFirst();
            BitSet actualSL = actualTyping.getStmtsIDList();
            int stmtId = actualSL.nextSetBit(0);
            if (stmtId == -1) {
                ret.add(actualTyping);
                workQueue.removeFirst();
                continue;
            }
            actualSL.clear(stmtId);
            AbstractDefinitionStmt defStmt = this.assignments.get(stmtId);
            LValue lhs = defStmt.getLeftOp();
            if (lhs instanceof Local) {
                local = (Local)lhs;
            } else if (lhs instanceof JArrayRef) {
                local = ((JArrayRef)lhs).getBase();
            } else {
                throw new IllegalStateException("can not handle " + lhs.getClass());
            }
            Type t_old = actualTyping.getType(local);
            Type t_right = evalFunction.evaluate(actualTyping, defStmt.getRightOp(), (Stmt)defStmt, graph);
            if (t_right == null) {
                workQueue.removeFirst();
                continue;
            }
            if (lhs instanceof JArrayRef) {
                t_right = Type.createArrayType((Type)t_right, (int)1);
            }
            boolean isFirstType = true;
            Collection<Type> leastCommonAncestors = hierarchy.getLeastCommonAncestor(t_old, t_right);
            for (Type type : leastCommonAncestors) {
                if (type.equals(t_old)) continue;
                BitSet dependStmtList = this.depends.get(local);
                if (isFirstType) {
                    actualTyping.set(local, type);
                    if (dependStmtList != null) {
                        actualSL.or(dependStmtList);
                    }
                    isFirstType = false;
                    continue;
                }
                Typing newTyping = new Typing(actualTyping, (BitSet)actualSL.clone());
                workQueue.add(newTyping);
                BitSet newSL = newTyping.getStmtsIDList();
                newTyping.set(local, type);
                if (dependStmtList == null) continue;
                newSL.or(dependStmtList);
            }
        }
        this.minimize(ret, hierarchy);
        return ret;
    }

    private void minimize(@Nonnull List<Typing> typings, @Nonnull BytecodeHierarchy hierarchy) {
        HashSet<ClassType> objectLikeTypes = new HashSet<ClassType>();
        JavaIdentifierFactory identifierFactory = this.view.getIdentifierFactory();
        objectLikeTypes.add(identifierFactory.getClassType("java.lang.Object"));
        objectLikeTypes.add(identifierFactory.getClassType("java.io.Serializable"));
        objectLikeTypes.add(identifierFactory.getClassType("java.lang.Cloneable"));
        HashSet<Local> objectLikeLocals = new HashSet<Local>();
        Map<Local, Set<Type>> local2Types = this.getLocal2Types(typings);
        for (Map.Entry<Local, Set<Type>> local : local2Types.entrySet()) {
            if (!local.getValue().equals(objectLikeTypes)) continue;
            objectLikeLocals.add(local.getKey());
        }
        ArrayList<Typing> typings_clo = new ArrayList<Typing>(typings);
        block1: for (Typing tpi : typings_clo) {
            for (Typing tpj : typings_clo) {
                if (tpi.compare(tpj, hierarchy, objectLikeLocals) != 1) continue;
                typings.remove(tpi);
                continue block1;
            }
        }
    }

    private Map<Local, Set<Type>> getLocal2Types(@Nonnull List<Typing> typings) {
        HashMap<Local, Set<Type>> map = new HashMap<Local, Set<Type>>();
        for (Typing typing : typings) {
            for (Local local : typing.getLocals()) {
                Set types = map.computeIfAbsent(local, k -> new HashSet());
                types.add(typing.getType(local));
            }
        }
        return map;
    }

    private Typing getMinCastsTyping(@Nonnull Body.BodyBuilder builder, @Nonnull Collection<Typing> typings, @Nonnull AugEvalFunction evalFunction, @Nonnull BytecodeHierarchy hierarchy) {
        CastCounter castCounter = new CastCounter(builder, evalFunction, hierarchy);
        Iterator<Typing> typingIterator = typings.iterator();
        Typing ret = null;
        int min = Integer.MAX_VALUE;
        while (typingIterator.hasNext()) {
            Typing typing = typingIterator.next();
            int castCount = castCounter.getCastCount(typing);
            if (castCount >= min) continue;
            min = castCount;
            ret = typing;
        }
        this.castCount = min;
        return ret;
    }

    private Type convertType(@Nonnull Type type) {
        if (type instanceof AugmentIntegerTypes.Integer1Type) {
            return PrimitiveType.getBoolean();
        }
        if (type instanceof AugmentIntegerTypes.Integer127Type) {
            return PrimitiveType.getByte();
        }
        if (type instanceof AugmentIntegerTypes.Integer32767Type) {
            return PrimitiveType.getShort();
        }
        if (type instanceof ArrayType) {
            Type eleType = this.convertType(((ArrayType)type).getElementType());
            if (eleType != null) {
                return Type.createArrayType((Type)eleType, (int)1);
            }
            return null;
        }
        return null;
    }
}

