/*
 * Decompiled with CFR 0.152.
 */
package sootup.java.bytecode.interceptors.typeresolving;

import java.util.BitSet;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import sootup.core.jimple.basic.Local;
import sootup.core.types.Type;
import sootup.java.bytecode.interceptors.typeresolving.BytecodeHierarchy;
import sootup.java.bytecode.interceptors.typeresolving.types.BottomType;

public class Typing {
    @Nonnull
    private Map<Local, Type> local2Type;
    @Nonnull
    private BitSet stmtsIDList;

    public Typing(@Nonnull Collection<Local> locals) {
        this.local2Type = new IdentityHashMap<Local, Type>(locals.size());
        for (Local local : locals) {
            this.local2Type.put(local, BottomType.getInstance());
        }
        this.stmtsIDList = new BitSet();
    }

    public Typing(@Nonnull Typing typing, @Nonnull BitSet stmtsIDList) {
        this.local2Type = new IdentityHashMap<Local, Type>(typing.local2Type);
        this.stmtsIDList = stmtsIDList;
    }

    @Nullable
    protected Type getType(@Nonnull Local local) {
        return this.local2Type.get(local);
    }

    public void set(@Nonnull Local local, @Nonnull Type type) {
        this.local2Type.put(local, type);
    }

    public Collection<Local> getLocals() {
        return this.local2Type.keySet();
    }

    public Map<Local, Type> getMap() {
        return this.local2Type;
    }

    public void setStmtsIDList(@Nonnull BitSet bitSet) {
        this.stmtsIDList = bitSet;
    }

    @Nonnull
    public BitSet getStmtsIDList() {
        return this.stmtsIDList;
    }

    public int compare(@Nonnull Typing typing, @Nonnull BytecodeHierarchy hierarchy, @Nonnull Collection<Local> localsToIgnore) {
        if (!typing.getLocals().equals(this.getLocals())) {
            throw new RuntimeException("The compared typings should have the same locals' set!");
        }
        int ret = 0;
        for (Map.Entry<Local, Type> local : this.local2Type.entrySet()) {
            int cmp;
            Type tb;
            if (localsToIgnore.contains(local.getKey())) continue;
            Type ta = local.getValue();
            if (ta.equals(tb = typing.getType(local.getKey()))) {
                cmp = 0;
            } else if (hierarchy.isAncestor(ta, tb)) {
                cmp = 1;
            } else if (hierarchy.isAncestor(tb, ta)) {
                cmp = -1;
            } else {
                return -2;
            }
            if (cmp == 1 && ret == -1 || cmp == -1 && ret == 1) {
                return 2;
            }
            if (ret != 0) continue;
            ret = cmp;
        }
        return ret;
    }
}

