/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.tools;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Objects;
import org.apache.jena.ontology.OntModel;
import org.apache.jena.ontology.OntModelSpec;
import org.apache.jena.rdf.model.ModelFactory;
import org.spdx.tools.schema.OwlToJsonSchema;

public class RdfSchemaToJsonSchema {
    public static void main(String[] args) {
        if (args.length != 2) {
            System.err.println("Invalid number of arguments");
            RdfSchemaToJsonSchema.usage();
            return;
        }
        File fromFile = new File(args[0]);
        if (!fromFile.exists()) {
            System.err.println("Input file " + args[0] + " does not exist.");
            RdfSchemaToJsonSchema.usage();
            return;
        }
        File toFile = new File(args[1]);
        if (toFile.exists()) {
            System.err.println("Output file " + args[1] + " already exists.");
            RdfSchemaToJsonSchema.usage();
            return;
        }
        FileInputStream is = null;
        OntModel model = null;
        try {
            try {
                is = new FileInputStream(fromFile);
                model = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM);
                model.read((InputStream)is, "RDF/XML");
            }
            catch (FileNotFoundException e) {
                System.err.println("File not found for " + fromFile.getName());
                if (is != null) {
                    try {
                        ((InputStream)is).close();
                    }
                    catch (IOException e2) {
                        System.err.println("Error closing input file stream: " + e2.getMessage());
                    }
                }
                return;
            }
        }
        finally {
            if (is != null) {
                try {
                    ((InputStream)is).close();
                }
                catch (IOException e) {
                    System.err.println("Error closing input file stream: " + e.getMessage());
                }
            }
        }
        OwlToJsonSchema owlToJson = new OwlToJsonSchema(model);
        ObjectNode root = owlToJson.convertToJsonSchema();
        ObjectMapper jsonMapper = new ObjectMapper().enable(SerializationFeature.INDENT_OUTPUT);
        JsonGenerator jsonGenerator = null;
        try {
            try {
                jsonGenerator = jsonMapper.getFactory().createGenerator((OutputStream)new FileOutputStream(toFile));
                jsonMapper.writeTree(jsonGenerator.useDefaultPrettyPrinter(), (JsonNode)root);
            }
            catch (JsonProcessingException e) {
                System.err.println("JSON error " + e.getMessage());
                if (Objects.nonNull(is)) {
                    try {
                        ((InputStream)is).close();
                    }
                    catch (IOException e3) {
                        System.err.println("Error closing input file stream: " + e3.getMessage());
                    }
                }
                if (Objects.nonNull(jsonGenerator)) {
                    try {
                        jsonGenerator.close();
                    }
                    catch (IOException e4) {
                        System.err.println("Error closing output file stream: " + e4.getMessage());
                    }
                }
                return;
            }
            catch (IOException e) {
                System.err.println("I/O error: " + e.getMessage());
                if (Objects.nonNull(is)) {
                    try {
                        ((InputStream)is).close();
                    }
                    catch (IOException e5) {
                        System.err.println("Error closing input file stream: " + e5.getMessage());
                    }
                }
                if (Objects.nonNull(jsonGenerator)) {
                    try {
                        jsonGenerator.close();
                    }
                    catch (IOException e6) {
                        System.err.println("Error closing output file stream: " + e6.getMessage());
                    }
                }
                return;
            }
        }
        finally {
            if (Objects.nonNull(is)) {
                try {
                    ((InputStream)is).close();
                }
                catch (IOException e) {
                    System.err.println("Error closing input file stream: " + e.getMessage());
                }
            }
            if (Objects.nonNull(jsonGenerator)) {
                try {
                    jsonGenerator.close();
                }
                catch (IOException e) {
                    System.err.println("Error closing output file stream: " + e.getMessage());
                }
            }
        }
    }

    public static void usage() {
        System.out.println("Usage:");
        System.out.println("RdfSchemaToJsonScema rdfSchemaFile jsonSchemaFile");
        System.out.println("\trdfSchemaFile RDF schema file in RDF/XML format");
        System.out.println("\tjsonSchemaFile output JSON Schema file");
    }
}

