/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.tools;

import java.io.PrintWriter;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import org.spdx.library.InvalidSPDXAnalysisException;
import org.spdx.library.model.SpdxDocument;
import org.spdx.spdxRdfStore.RdfStore;
import org.spdx.storage.IModelStore;
import org.spdx.tag.CommonCode;

public class SpdxViewer {
    static final int MIN_ARGS = 1;
    static final int MAX_ARGS = 1;

    public static void main(String[] args) {
        if (args.length < 1) {
            System.err.println("Usage:\n SPDXViewer file\nwhere file is the file path to a valid SPDX RDF XML file");
            return;
        }
        if (args.length > 1) {
            System.out.printf("Warning: Extra arguments will be ignored", new Object[0]);
        }
        SpdxDocument doc = null;
        RdfStore store = null;
        PrintWriter writer = null;
        try {
            store = new RdfStore();
            try {
                String documentUri = store.loadModelFromFile(args[0], false);
                doc = new SpdxDocument((IModelStore)store, documentUri, null, false);
            }
            catch (Exception ex) {
                System.out.print("Error creating SPDX Document: " + ex.getMessage());
                if (Objects.nonNull(writer)) {
                    writer.close();
                }
                if (Objects.nonNull(store)) {
                    try {
                        store.close();
                    }
                    catch (Exception e) {
                        System.out.println("Warning - unable to close RDF store: " + e.getMessage());
                    }
                }
                return;
            }
            try {
                writer = new PrintWriter(System.out);
                List verify = doc.verify();
                if (verify.size() > 0) {
                    System.out.println("This SPDX Document is not valid due to:");
                    int i = 0;
                    while (i < verify.size()) {
                        System.out.print("\t" + (String)verify.get(i) + "\n");
                        ++i;
                    }
                }
                Properties constants = CommonCode.getTextFromProperties((String)"org/spdx/tag/SpdxViewerConstants.properties");
                CommonCode.printDoc((SpdxDocument)doc, (PrintWriter)writer, (Properties)constants);
            }
            catch (InvalidSPDXAnalysisException e) {
                System.out.print("Error pretty printing SPDX Document: " + e.getMessage());
                return;
            }
            catch (Exception e) {
                System.out.print("Unexpected error displaying SPDX Document: " + e.getMessage());
            }
        }
        finally {
            if (Objects.nonNull(writer)) {
                writer.close();
            }
            if (Objects.nonNull(store)) {
                try {
                    store.close();
                }
                catch (Exception e) {
                    System.out.println("Warning - unable to close RDF store: " + e.getMessage());
                }
            }
        }
    }
}

