/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.tools;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.spdx.library.InvalidSPDXAnalysisException;
import org.spdx.library.model.SpdxDocument;
import org.spdx.storage.IModelStore;
import org.spdx.storage.ISerializableModelStore;
import org.spdx.tagvaluestore.TagValueStore;
import org.spdx.tools.InvalidFileNameException;
import org.spdx.tools.SpdxToolsHelper;
import org.spdx.tools.SpdxVerificationException;

public class Verify {
    static final int MIN_ARGS = 1;
    static final int MAX_ARGS = 2;
    static final int ERROR_STATUS = 1;

    public static void main(String[] args) {
        if (args.length < 1) {
            System.err.println("Usage:\n Verify file\nwhere file is the file path to an SPDX file");
            System.exit(1);
        }
        if (args.length > 2) {
            System.out.printf("Warning: Extra arguments will be ignored", new Object[0]);
        }
        List<String> verify = null;
        try {
            SpdxToolsHelper.SerFileType fileType = null;
            if (args.length > 1) {
                try {
                    fileType = SpdxToolsHelper.strToFileType(args[1]);
                }
                catch (Exception ex) {
                    System.err.println("Invalid file type: " + args[1]);
                    System.exit(1);
                }
            } else {
                fileType = SpdxToolsHelper.fileToFileType(new File(args[0]));
            }
            verify = Verify.verify(args[0], fileType);
        }
        catch (SpdxVerificationException e) {
            System.out.println(e.getMessage());
            System.exit(1);
        }
        catch (InvalidFileNameException e) {
            System.err.println("Invalid file name: " + args[0]);
            System.exit(1);
        }
        if (verify.size() > 0) {
            System.out.println("This SPDX Document is not valid due to:");
            int i = 0;
            while (i < verify.size()) {
                System.out.print("\t" + verify.get(i) + "\n");
                ++i;
            }
            System.exit(1);
        } else {
            System.out.println("This SPDX Document is valid.");
        }
    }

    public static List<String> verify(String filePath, SpdxToolsHelper.SerFileType fileType) throws SpdxVerificationException {
        List verify;
        Objects.requireNonNull(filePath);
        Objects.requireNonNull(fileType);
        File file = new File(filePath);
        if (!file.exists()) {
            throw new SpdxVerificationException("File " + filePath + " not found.");
        }
        if (!file.isFile()) {
            throw new SpdxVerificationException(String.valueOf(filePath) + " is not a file.");
        }
        ISerializableModelStore store = null;
        try {
            store = SpdxToolsHelper.fileTypeToStore(fileType);
        }
        catch (InvalidSPDXAnalysisException e) {
            throw new SpdxVerificationException("Error converting fileType to store", e);
        }
        SpdxDocument doc = null;
        try {
            Throwable throwable = null;
            Object var6_11 = null;
            try (FileInputStream is = new FileInputStream(file);){
                String documentUri = store.deSerialize((InputStream)is, false);
                doc = new SpdxDocument((IModelStore)store, documentUri, null, false);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (FileNotFoundException e) {
            throw new SpdxVerificationException("File " + filePath + " not found.", e);
        }
        catch (IOException e) {
            throw new SpdxVerificationException("IO Error reading SPDX file", e);
        }
        catch (InvalidSPDXAnalysisException e) {
            throw new SpdxVerificationException("Analysis exception processing SPDX file: " + e.getMessage(), e);
        }
        ArrayList<String> retval = new ArrayList<String>();
        if (store instanceof TagValueStore) {
            retval.addAll(((TagValueStore)store).getWarnings());
        }
        if (!(verify = doc.verify()).isEmpty()) {
            for (String verifyMsg : verify) {
                if (retval.contains(verifyMsg)) continue;
                retval.add(verifyMsg);
            }
        }
        return retval;
    }

    public static List<String> verifyTagFile(String filePath) throws SpdxVerificationException {
        return Verify.verify(filePath, SpdxToolsHelper.SerFileType.TAG);
    }

    public static List<String> verifyRDFFile(String filePath) throws SpdxVerificationException {
        return Verify.verify(filePath, SpdxToolsHelper.SerFileType.RDFXML);
    }

    public void usage() {
        System.out.println("Verify filepath [RDFXML|JSON|XLS|XLSX|YAML|TAG]");
        System.out.println("    where filepath is a path to the SPDX file and [RDFXML|JSON|XLS|XLSX|YAML|TAG] is an optional file type - if not present, file type of the to file will be used");
    }
}

