/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.tools.compare;

import java.util.Arrays;
import java.util.List;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.spdx.library.InvalidSPDXAnalysisException;
import org.spdx.tools.compare.AbstractSheet;
import org.spdx.utility.compare.SpdxCompareException;
import org.spdx.utility.compare.SpdxComparer;

public class CreatorSheet
extends AbstractSheet {
    private static final int COL_WIDTH = 50;

    public CreatorSheet(Workbook workbook, String sheetName) {
        super(workbook, sheetName);
    }

    @Override
    public String verify() {
        return null;
    }

    public static void create(Workbook wb, String sheetName) {
        int sheetNum = wb.getSheetIndex(sheetName);
        if (sheetNum >= 0) {
            wb.removeSheetAt(sheetNum);
        }
        Sheet sheet = wb.createSheet(sheetName);
        CellStyle headerStyle = AbstractSheet.createHeaderStyle(wb);
        CellStyle defaultStyle = AbstractSheet.createLeftWrapStyle(wb);
        Row row = sheet.createRow(0);
        int i = 0;
        while (i < 25) {
            sheet.setColumnWidth(i, 12800);
            sheet.setDefaultColumnStyle(i, defaultStyle);
            Cell cell = row.createCell(i);
            cell.setCellStyle(headerStyle);
            ++i;
        }
    }

    public void importCompareResults(SpdxComparer comparer, List<String> docNames) throws SpdxCompareException, InvalidSPDXAnalysisException {
        if (comparer.getNumSpdxDocs() != docNames.size()) {
            throw new SpdxCompareException("Number of document names does not match the number of SPDX documents");
        }
        this.clear();
        Row header = this.sheet.getRow(0);
        int i = 0;
        while (i < comparer.getNumSpdxDocs()) {
            Cell headerCell = header.getCell(i);
            headerCell.setCellValue(docNames.get(i));
            Object[] creators = comparer.getSpdxDoc(i).getCreationInfo().getCreators().toArray(new String[comparer.getSpdxDoc(i).getCreationInfo().getCreators().size()]);
            Arrays.sort(creators);
            int j = 0;
            while (j < creators.length) {
                Cell creatorCell = null;
                while (j + 1 > this.getNumDataRows()) {
                    this.addRow();
                }
                creatorCell = this.sheet.getRow(j + 1).createCell(i);
                creatorCell.setCellValue((String)creators[j]);
                ++j;
            }
            ++i;
        }
    }
}

