/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.tools.compare;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.spdx.library.InvalidSPDXAnalysisException;
import org.spdx.library.model.ModelObject;
import org.spdx.library.model.Relationship;
import org.spdx.library.model.SpdxElement;
import org.spdx.tools.compare.AbstractSheet;
import org.spdx.tools.compare.CompareHelper;
import org.spdx.utility.compare.SpdxCompareException;
import org.spdx.utility.compare.SpdxComparer;

public class DocumentRelationshipSheet
extends AbstractSheet {
    RelationshipComparator relationshipComparator = new RelationshipComparator();
    static final int TYPE_COL = 0;
    static final int TYPE_COL_WIDTH = 25;
    static final String TYPE_COL_TEXT_TITLE = "Type";
    static final int FIRST_RELATIONSHIP_COL = 1;
    static final int FIRST_RELATIONSHIP_COL_WIDTH = 60;

    public DocumentRelationshipSheet(Workbook workbook, String sheetName) {
        super(workbook, sheetName);
    }

    public static void create(Workbook wb, String sheetName) {
        int sheetNum = wb.getSheetIndex(sheetName);
        if (sheetNum >= 0) {
            wb.removeSheetAt(sheetNum);
        }
        Sheet sheet = wb.createSheet(sheetName);
        CellStyle headerStyle = AbstractSheet.createHeaderStyle(wb);
        CellStyle defaultStyle = AbstractSheet.createLeftWrapStyle(wb);
        Row row = sheet.createRow(0);
        sheet.setColumnWidth(0, 6400);
        sheet.setDefaultColumnStyle(0, defaultStyle);
        Cell typeHeaderCell = row.createCell(0);
        typeHeaderCell.setCellStyle(headerStyle);
        typeHeaderCell.setCellValue(TYPE_COL_TEXT_TITLE);
        int i = 1;
        while (i < 25) {
            sheet.setColumnWidth(i, 15360);
            sheet.setDefaultColumnStyle(i, defaultStyle);
            Cell cell = row.createCell(i);
            cell.setCellStyle(headerStyle);
            ++i;
        }
    }

    public void importCompareResults(SpdxComparer comparer, List<String> docNames) throws SpdxCompareException, InvalidSPDXAnalysisException {
        if (comparer.getNumSpdxDocs() != docNames.size()) {
            throw new SpdxCompareException("Number of document names does not match the number of SPDX documents");
        }
        this.clear();
        Row header = this.sheet.getRow(0);
        int[] relationshipsIndexes = new int[comparer.getNumSpdxDocs()];
        Relationship[][] relationships = new Relationship[comparer.getNumSpdxDocs()][];
        int i = 0;
        while (i < relationships.length) {
            Cell headerCell = header.getCell(1 + i);
            headerCell.setCellValue(docNames.get(i));
            Relationship[] docRelationships = comparer.getSpdxDoc(i).getRelationships().toArray(new Relationship[comparer.getSpdxDoc(i).getRelationships().size()]);
            Arrays.sort(docRelationships, this.relationshipComparator);
            relationships[i] = docRelationships;
            relationshipsIndexes[i] = 0;
            ++i;
        }
        while (!this.allRelationshipsExhausted(relationships, relationshipsIndexes)) {
            Row currentRow = this.addRow();
            Relationship nextRelationship = this.getNexRelationship(relationships, relationshipsIndexes);
            if (!Objects.nonNull(nextRelationship)) continue;
            Cell typeCell = currentRow.createCell(0);
            typeCell.setCellValue(nextRelationship.getRelationshipType().toString());
            int i2 = 0;
            while (i2 < relationships.length) {
                Relationship compareRelationship;
                if (relationships[i2].length > relationshipsIndexes[i2] && this.relationshipComparator.compare(nextRelationship, compareRelationship = relationships[i2][relationshipsIndexes[i2]]) == 0) {
                    Cell relationshipCell = currentRow.createCell(1 + i2);
                    relationshipCell.setCellValue(CompareHelper.relationshipToString(relationships[i2][relationshipsIndexes[i2]]));
                    int n = i2;
                    relationshipsIndexes[n] = relationshipsIndexes[n] + 1;
                }
                ++i2;
            }
        }
    }

    private Relationship getNexRelationship(Relationship[][] relationships, int[] relationshipsIndexes) {
        Relationship retval = null;
        int i = 0;
        while (i < relationships.length) {
            if (relationships[i].length > relationshipsIndexes[i]) {
                Relationship candidate = relationships[i][relationshipsIndexes[i]];
                if (retval == null || this.relationshipComparator.compare(retval, candidate) > 0) {
                    retval = candidate;
                }
            }
            ++i;
        }
        return retval;
    }

    private boolean allRelationshipsExhausted(Relationship[][] relationships, int[] relationshipsIndexes) {
        int i = 0;
        while (i < relationships.length) {
            if (relationshipsIndexes[i] < relationships[i].length) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public String verify() {
        return null;
    }

    private static class RelationshipComparator
    implements Comparator<Relationship>,
    Serializable {
        private static final long serialVersionUID = 1L;

        private RelationshipComparator() {
        }

        @Override
        public int compare(Relationship o1, Relationship o2) {
            block7: {
                block8: {
                    Optional relatedElement2;
                    Optional relatedElement1;
                    block11: {
                        block10: {
                            block9: {
                                try {
                                    if (o1 == null) break block7;
                                    if (o2 == null) break block8;
                                    Relationship r1 = o1;
                                    Relationship r2 = o2;
                                    int retval = r1.getRelationshipType().toString().compareTo(r2.getRelationshipType().toString());
                                    if (retval != 0) {
                                        return retval;
                                    }
                                    relatedElement1 = r1.getRelatedSpdxElement();
                                    relatedElement2 = r2.getRelatedSpdxElement();
                                    if (!relatedElement1.isPresent() || relatedElement2.isPresent()) break block9;
                                    return 1;
                                }
                                catch (InvalidSPDXAnalysisException ex) {
                                    logger.error("Error comparing relationships", (Throwable)ex);
                                    throw new RuntimeException(ex);
                                }
                            }
                            if (relatedElement1.isPresent() || !relatedElement2.isPresent()) break block10;
                            return -1;
                        }
                        if (!((SpdxElement)relatedElement1.get()).equivalent((ModelObject)relatedElement2.get())) break block11;
                        return 0;
                    }
                    Optional name1 = ((SpdxElement)relatedElement1.get()).getName();
                    Optional name2 = ((SpdxElement)relatedElement2.get()).getName();
                    if (name1.isPresent() && name2.isPresent()) {
                        return ((String)name1.get()).compareTo((String)name2.get());
                    }
                    return ((SpdxElement)relatedElement1.get()).getId().compareTo(((SpdxElement)relatedElement2.get()).getId());
                }
                return 1;
            }
            return -1;
        }
    }
}

