/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.tools.schema;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Collection;
import java.util.Objects;
import org.apache.jena.ontology.OntClass;
import org.apache.jena.ontology.OntModel;
import org.apache.jena.ontology.OntProperty;
import org.apache.jena.ontology.Ontology;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.spdx.jacksonstore.MultiFormatStore;
import org.spdx.jacksonstore.SpdxJsonLDContext;
import org.spdx.library.model.ReferenceType;
import org.spdx.library.model.SpdxElement;
import org.spdx.library.model.SpdxModelFactory;
import org.spdx.library.model.license.AnyLicenseInfo;
import org.spdx.tools.schema.AbstractOwlRdfConverter;

public class OwlToJsonSchema
extends AbstractOwlRdfConverter {
    private static final String SCHEMA_VERSION_URI = "http://json-schema.org/draft-07/schema#";
    private static final String RELATIONSHIP_TYPE = "http://spdx.org/rdf/terms#Relationship";
    static ObjectMapper jsonMapper = new ObjectMapper().enable(SerializationFeature.INDENT_OUTPUT);

    public OwlToJsonSchema(OntModel model) {
        super(model);
    }

    public ObjectNode convertToJsonSchema() {
        ObjectNode root = jsonMapper.createObjectNode();
        root.put("$schema", SCHEMA_VERSION_URI);
        ExtendedIterator ontologyIter = this.model.listOntologies();
        if (ontologyIter.hasNext()) {
            String title;
            Ontology ont = (Ontology)ontologyIter.next();
            String ontologyUri = ont.getURI();
            if (Objects.nonNull(ontologyUri)) {
                root.put("$id", ontologyUri);
            }
            if (Objects.nonNull(title = ont.getLabel(null))) {
                root.put("title", title);
            }
        }
        root.put("type", "object");
        ObjectNode properties = jsonMapper.createObjectNode();
        OntClass docClass = this.model.getOntClass("http://spdx.org/rdf/terms#SpdxDocument");
        Objects.requireNonNull(docClass, "Missing SpdxDocument class in OWL document");
        ObjectNode documentClassSchema = this.ontClassToJsonSchema(docClass);
        ObjectNode docSchemaProperties = (ObjectNode)documentClassSchema.get("properties");
        OntClass packageClass = this.model.getOntClass("http://spdx.org/rdf/terms#Package");
        Objects.requireNonNull(packageClass, "Missing SPDX Package class in OWL document");
        docSchemaProperties.set("packages", this.toArrayPropertySchema(packageClass, 0));
        OntClass fileClass = this.model.getOntClass("http://spdx.org/rdf/terms#File");
        Objects.requireNonNull(fileClass, "Missing SPDX File class in OWL document");
        docSchemaProperties.set("files", this.toArrayPropertySchema(fileClass, 0));
        OntClass snippetClass = this.model.getOntClass("http://spdx.org/rdf/terms#Snippet");
        Objects.requireNonNull(snippetClass, "Missing SPDX Snippet class in OWL document");
        docSchemaProperties.set("snippets", this.toArrayPropertySchema(snippetClass, 0));
        OntClass relationshipClass = this.model.getOntClass(RELATIONSHIP_TYPE);
        Objects.requireNonNull(relationshipClass, "Missing SPDX Relationship class in OWL document");
        docSchemaProperties.set("relationships", this.toArrayPropertySchema(relationshipClass, 0));
        properties.set("Document", (JsonNode)documentClassSchema);
        root.set("properties", (JsonNode)properties);
        return root;
    }

    private JsonNode toArrayPropertySchema(OntClass ontClass, int min) {
        ObjectNode classSchema = this.ontClassToJsonSchema(ontClass);
        ObjectNode property = jsonMapper.createObjectNode();
        property.put("description", String.valueOf(OwlToJsonSchema.checkConvertRenamedPropertyName(ontClass.getLocalName())) + "s referenced in the SPDX document");
        property.put("type", "array");
        property.set("items", (JsonNode)classSchema);
        if (min > 0) {
            property.put("minItems", min);
        }
        return property;
    }

    private ObjectNode ontClassToJsonSchema(OntClass spdxClass) {
        ObjectNode retval = jsonMapper.createObjectNode();
        retval.put("type", "object");
        ObjectNode properties = jsonMapper.createObjectNode();
        Collection<OntProperty> ontProperties = this.propertiesFromClassRestrictions(spdxClass);
        for (OntProperty property : ontProperties) {
            if (SKIPPED_PROPERTIES.contains(property.getURI())) continue;
            AbstractOwlRdfConverter.PropertyRestrictions restrictions = this.getPropertyRestrictions(spdxClass, property);
            Objects.requireNonNull(restrictions.getTypeUri(), "Missing type for property " + property.getLocalName());
            if (restrictions.getTypeUri().equals(RELATIONSHIP_TYPE)) continue;
            if (restrictions.isListProperty()) {
                properties.set(MultiFormatStore.propertyNameToCollectionPropertyName((String)OwlToJsonSchema.checkConvertRenamedPropertyName(property.getLocalName())), (JsonNode)this.derivePropertySchema(property, restrictions, true));
                continue;
            }
            properties.set(OwlToJsonSchema.checkConvertRenamedPropertyName(property.getLocalName()), (JsonNode)this.derivePropertySchema(property, restrictions, false));
        }
        retval.set("properties", (JsonNode)properties);
        return retval;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ObjectNode derivePropertySchema(OntProperty property, AbstractOwlRdfConverter.PropertyRestrictions restrictions, boolean list) {
        ObjectNode propertySchema = jsonMapper.createObjectNode();
        Statement commentStatement = property.getProperty(this.commentProperty);
        if (Objects.nonNull(commentStatement) && Objects.nonNull(commentStatement.getObject()) && commentStatement.getObject().isLiteral()) {
            propertySchema.put("description", commentStatement.getObject().asLiteral().getString());
        }
        if (list) {
            propertySchema.put("type", "array");
            propertySchema.set("items", (JsonNode)this.derivePropertySchema(property, restrictions, false));
            if (restrictions.getAbsoluteCardinality() > 0) {
                propertySchema.put("minItems", restrictions.getAbsoluteCardinality());
                propertySchema.put("maxItems", restrictions.getAbsoluteCardinality());
            }
            if (restrictions.getMinCardinality() > 0) {
                propertySchema.put("minItems", restrictions.getMinCardinality());
            }
            if (restrictions.getMaxCardinality() <= 0) return propertySchema;
            propertySchema.put("maxItems", restrictions.getMaxCardinality());
            return propertySchema;
        } else if (restrictions.isEnumProperty()) {
            propertySchema.put("type", "string");
            ArrayNode enums = jsonMapper.createArrayNode();
            for (String val : restrictions.getEnumValues()) {
                enums.add(val);
            }
            propertySchema.set("enum", (JsonNode)enums);
            return propertySchema;
        } else if (restrictions.getTypeUri().equals("http://www.w3.org/2000/01/rdf-schema#Literal")) {
            propertySchema.put("type", "string");
            return propertySchema;
        } else if (restrictions.getTypeUri().startsWith("http://www.w3.org/2001/XMLSchema#")) {
            String primitiveType = restrictions.getTypeUri().substring("http://www.w3.org/2001/XMLSchema#".length());
            Class primitiveClass = (Class)SpdxJsonLDContext.XMLSCHEMA_TYPE_TO_JAVA_CLASS.get(primitiveType);
            Objects.requireNonNull(primitiveClass, "No primitive class found for type " + restrictions.getTypeUri());
            if (Boolean.class.equals((Object)primitiveClass)) {
                propertySchema.put("type", "boolean");
                return propertySchema;
            } else if (String.class.equals((Object)primitiveClass)) {
                propertySchema.put("type", "string");
                return propertySchema;
            } else {
                if (!Integer.class.equals((Object)primitiveClass)) throw new RuntimeException("Unknown primitive class " + primitiveType);
                propertySchema.put("type", "integer");
            }
            return propertySchema;
        } else if (restrictions.getTypeUri().startsWith("http://spdx.org/rdf/terms#")) {
            String spdxType = restrictions.getTypeUri().substring("http://spdx.org/rdf/terms#".length());
            Class clazz = (Class)SpdxModelFactory.SPDX_TYPE_TO_CLASS.get(spdxType);
            if (Objects.nonNull(clazz) && AnyLicenseInfo.class.isAssignableFrom(clazz) && !"hasExtractedLicensingInfo".equals(OwlToJsonSchema.checkConvertRenamedPropertyName(property.getLocalName()))) {
                JsonNode description = propertySchema.get("description");
                if (Objects.isNull(description)) {
                    propertySchema.put("description", "License expression");
                } else {
                    propertySchema.put("description", "License expression for " + OwlToJsonSchema.checkConvertRenamedPropertyName(property.getLocalName()) + ".  " + description.asText());
                }
                propertySchema.put("type", "string");
                return propertySchema;
            } else if (Objects.nonNull(clazz) && SpdxElement.class.isAssignableFrom(clazz)) {
                JsonNode description = propertySchema.get("description");
                if (Objects.isNull(description)) {
                    propertySchema.put("description", "SPDX ID for " + spdxType);
                } else {
                    propertySchema.put("description", "SPDX ID for " + spdxType + ".  " + description.asText());
                }
                propertySchema.put("type", "string");
                return propertySchema;
            } else if (Objects.nonNull(clazz) && ReferenceType.class.isAssignableFrom(clazz)) {
                JsonNode description = propertySchema.get("description");
                if (Objects.nonNull(description)) {
                    propertySchema.put("description", description.asText());
                }
                propertySchema.put("type", "string");
                return propertySchema;
            } else {
                OntClass typeClass = this.model.getOntClass(restrictions.getTypeUri());
                Objects.requireNonNull(typeClass, "No type class found for " + restrictions.getTypeUri());
                propertySchema = this.ontClassToJsonSchema(typeClass);
                commentStatement = typeClass.getProperty(this.commentProperty);
                if (!Objects.nonNull(commentStatement)) return propertySchema;
                if (!Objects.nonNull(commentStatement.getObject())) return propertySchema;
                if (!commentStatement.getObject().isLiteral()) return propertySchema;
                propertySchema.put("description", commentStatement.getObject().asLiteral().getString());
            }
            return propertySchema;
        } else {
            OntClass typeClass = this.model.getOntClass(restrictions.getTypeUri());
            commentStatement = typeClass.getProperty(this.commentProperty);
            if (Objects.nonNull(commentStatement) && Objects.nonNull(commentStatement.getObject()) && commentStatement.getObject().isLiteral()) {
                propertySchema.put("description", commentStatement.getObject().asLiteral().getString());
            }
            Objects.requireNonNull(typeClass, "No type class found for " + restrictions.getTypeUri());
            return this.ontClassToJsonSchema(typeClass);
        }
    }
}

