/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.tools;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spdx.library.InvalidSPDXAnalysisException;
import org.spdx.library.model.SpdxDocument;
import org.spdx.spreadsheetstore.SpreadsheetException;
import org.spdx.tools.InvalidFileNameException;
import org.spdx.tools.OnlineToolException;
import org.spdx.tools.SpdxToolsHelper;
import org.spdx.tools.compare.MultiDocumentSpreadsheet;
import org.spdx.utility.compare.SpdxCompareException;
import org.spdx.utility.compare.SpdxComparer;

public class CompareSpdxDocs {
    static final int MIN_ARGS = 3;
    static final int MAX_ARGS = 26;
    static final int ERROR_STATUS = 1;
    static final Logger logger = LoggerFactory.getLogger(CompareSpdxDocs.class);

    public static void main(String[] args) {
        if (args.length < 3) {
            System.out.println("Insufficient arguments");
            CompareSpdxDocs.usage();
            System.exit(1);
        }
        if (args.length > 26) {
            System.out.println("Too many SPDX documents specified.  Must be less than " + String.valueOf(25) + " document filenames");
            CompareSpdxDocs.usage();
            System.exit(1);
        }
        try {
            CompareSpdxDocs.onlineFunction(args);
        }
        catch (OnlineToolException e) {
            System.out.println(e.getMessage());
            System.exit(1);
        }
    }

    public static void onlineFunction(String[] args) throws OnlineToolException {
        File outputFile = new File(args[0]);
        if (outputFile.exists()) {
            throw new OnlineToolException("Output file " + args[0] + " already exists. Change the name of the result file.");
        }
        ArrayList<SpdxDocument> compareDocs = new ArrayList<SpdxDocument>();
        ArrayList<List<String>> verificationErrors = new ArrayList<List<String>>();
        for (int i = 1; i < args.length; ++i) {
            try {
                SpdxDocument doc = SpdxToolsHelper.deserializeDocument(new File(args[i]));
                compareDocs.add(doc);
                List warnings = doc.verify();
                if (!warnings.isEmpty()) {
                    System.out.println("Verification errors were found in " + args[i].trim() + ".  See verification errors sheet for details.");
                }
                verificationErrors.add(warnings);
                continue;
            }
            catch (IOException | InvalidSPDXAnalysisException | InvalidFileNameException e) {
                throw new OnlineToolException("Error opening SPDX document " + args[i] + ": " + e.getMessage());
            }
        }
        List<String> docNames = CompareSpdxDocs.convertToDocNames(args, 1);
        MultiDocumentSpreadsheet outSheet = null;
        try {
            outSheet = new MultiDocumentSpreadsheet(outputFile, true, false);
            outSheet.importVerificationErrors(verificationErrors, docNames);
            SpdxComparer comparer = new SpdxComparer();
            comparer.compare(compareDocs);
            outSheet.importCompareResults(comparer, docNames);
        }
        catch (SpreadsheetException e) {
            throw new OnlineToolException("Unable to create output spreadsheet: " + e.getMessage());
        }
        catch (InvalidSPDXAnalysisException e) {
            throw new OnlineToolException("Invalid SPDX analysis: " + e.getMessage());
        }
        catch (SpdxCompareException e) {
            throw new OnlineToolException("Error comparing SPDX documents: " + e.getMessage());
        }
        finally {
            if (outSheet != null) {
                try {
                    outSheet.close();
                }
                catch (SpreadsheetException e) {
                    logger.warn("Warning - error closing spreadsheet: " + e.getMessage());
                }
            }
        }
    }

    private static List<String> convertToDocNames(String[] args, int startNameIndex) {
        int i;
        ArrayList<String> docNames = new ArrayList<String>();
        if (args.length < startNameIndex) {
            return docNames;
        }
        int commonPrefixIndex = args[startNameIndex].length();
        for (i = startNameIndex + 1; i < args.length; ++i) {
            if (args[i].length() >= commonPrefixIndex) continue;
            commonPrefixIndex = args[i].length();
        }
        block1: for (i = startNameIndex + 1; i < args.length; ++i) {
            for (int j = 0; j < commonPrefixIndex; ++j) {
                if (args[i - 1].charAt(j) == args[i].charAt(j)) continue;
                commonPrefixIndex = j;
                continue block1;
            }
        }
        for (i = startNameIndex; i < args.length; ++i) {
            docNames.add(args[i].substring(commonPrefixIndex).replace("\\", "/"));
        }
        return docNames;
    }

    private static void usage() {
        System.out.println("Usage: CompareMultipleSpdxDoc output.xls doc1 doc2 ... docN");
        System.out.println("where output.xls is a file name for the output spreadsheet file");
        System.out.println("and doc1 through docN are file names of valid SPDX documents ");
        System.out.println("in either tag/value or RDF/XML format");
    }
}

