/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.tools;

import java.io.File;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.spdx.library.InvalidSPDXAnalysisException;
import org.spdx.library.model.SpdxPackageVerificationCode;
import org.spdx.storage.IModelStore;
import org.spdx.storage.simple.InMemSpdxStore;
import org.spdx.tools.OnlineToolException;
import org.spdx.utility.verificationcode.IFileChecksumGenerator;
import org.spdx.utility.verificationcode.JavaSha1ChecksumGenerator;
import org.spdx.utility.verificationcode.VerificationCodeGenerator;

public class GenerateVerificationCode {
    public static void main(String[] args) {
        if (args.length < 1 || args.length > 2) {
            GenerateVerificationCode.error("Incorrect number of arguments.");
            System.exit(1);
        }
        String directoryPath = args[0];
        String skippedRegex = null;
        if (args.length > 1) {
            skippedRegex = args[1];
        }
        try {
            SpdxPackageVerificationCode verificationCode = GenerateVerificationCode.generateVerificationCode(directoryPath, skippedRegex);
            GenerateVerificationCode.printVerificationCode(verificationCode);
            System.exit(0);
        }
        catch (Exception ex) {
            GenerateVerificationCode.error("Error creating verification code: " + ex.getMessage());
            System.exit(1);
        }
    }

    public static SpdxPackageVerificationCode generateVerificationCode(String directoryPath, @Nullable String skippedRegex) throws OnlineToolException {
        Objects.requireNonNull(directoryPath, "Directory path must not be null");
        File sourceDirectory = new File(directoryPath);
        if (!sourceDirectory.exists()) {
            throw new OnlineToolException("Source directory " + directoryPath + " does not exist.");
        }
        if (!sourceDirectory.isDirectory()) {
            throw new OnlineToolException("File " + directoryPath + " is not a directory.");
        }
        File[] skippedFiles = new File[]{};
        if (Objects.nonNull(skippedRegex)) {
            skippedFiles = GenerateVerificationCode.collectSkippedFiles(skippedRegex, sourceDirectory);
        }
        try {
            VerificationCodeGenerator vcg = new VerificationCodeGenerator((IFileChecksumGenerator)new JavaSha1ChecksumGenerator());
            InMemSpdxStore ms = new InMemSpdxStore();
            return vcg.generatePackageVerificationCode(sourceDirectory, skippedFiles, (IModelStore)ms, "https://temp/URI");
        }
        catch (NoSuchAlgorithmException e) {
            throw new OnlineToolException("Error creating checksum algorithm", e);
        }
        catch (IOException e) {
            throw new OnlineToolException("I/O Error generating verification code", e);
        }
        catch (InvalidSPDXAnalysisException e) {
            throw new OnlineToolException("SPDX Analysis Error generating verification code", e);
        }
    }

    private static File[] collectSkippedFiles(String skippedRegex, File dir) {
        Pattern skippedPattern = Pattern.compile(skippedRegex);
        ArrayList<File> skippedFiles = new ArrayList<File>();
        GenerateVerificationCode.collectSkippedFiles(skippedPattern, skippedFiles, dir.getPath(), dir);
        File[] retval = new File[skippedFiles.size()];
        retval = skippedFiles.toArray(retval);
        return retval;
    }

    private static void collectSkippedFiles(Pattern skippedPattern, List<File> skippedFiles, String rootPath, File dir) {
        File[] children;
        if (dir.isFile()) {
            String relativePath = dir.getPath().substring(rootPath.length() + 1);
            if (skippedPattern.matcher(relativePath).matches()) {
                skippedFiles.add(dir);
            }
        } else if (dir.isDirectory() && (children = dir.listFiles()) != null) {
            for (int i = 0; i < children.length; ++i) {
                if (children[i].isFile()) {
                    String relativePath = children[i].getPath().substring(rootPath.length() + 1);
                    if (!skippedPattern.matcher(relativePath).matches()) continue;
                    skippedFiles.add(children[i]);
                    continue;
                }
                if (!children[i].isDirectory()) continue;
                GenerateVerificationCode.collectSkippedFiles(skippedPattern, skippedFiles, rootPath, children[i]);
            }
        }
    }

    private static void printVerificationCode(SpdxPackageVerificationCode verificationCode) throws InvalidSPDXAnalysisException {
        System.out.println("Verification code value: " + verificationCode.getValue());
        String[] excludedFiles = verificationCode.getExcludedFileNames().toArray(new String[verificationCode.getExcludedFileNames().size()]);
        if (excludedFiles != null && excludedFiles.length > 0) {
            System.out.println("Excluded files:");
            for (int i = 0; i < excludedFiles.length; ++i) {
                System.out.println("\t" + excludedFiles[i]);
            }
        } else {
            System.out.println("No excluded files");
        }
    }

    private static void error(String string) {
        System.out.println(string);
        GenerateVerificationCode.usage();
    }

    private static void usage() {
        System.out.println("Usage: GenerateVerificationCode sourceDirectory [skippedFiles]");
        System.out.println("where sourceDirectory is the root of the archive file for which the verification code is generated and [skippedFiles] is an optional regular expression of skipped files.  The expression is applied against a file path relative the the source directory supplied");
    }
}

