/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.tools;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.spdx.jacksonstore.MultiFormatStore;
import org.spdx.library.InvalidSPDXAnalysisException;
import org.spdx.library.model.SpdxDocument;
import org.spdx.spdxRdfStore.RdfStore;
import org.spdx.spreadsheetstore.SpreadsheetStore;
import org.spdx.storage.IModelStore;
import org.spdx.storage.ISerializableModelStore;
import org.spdx.storage.simple.InMemSpdxStore;
import org.spdx.tagvaluestore.TagValueStore;
import org.spdx.tools.InvalidFileNameException;

public class SpdxToolsHelper {
    static Map<String, SerFileType> EXT_TO_FILETYPE;

    public static ISerializableModelStore fileTypeToStore(SerFileType fileType) throws InvalidSPDXAnalysisException {
        switch (fileType) {
            case JSON: {
                return new MultiFormatStore((IModelStore)new InMemSpdxStore(), MultiFormatStore.Format.JSON_PRETTY, MultiFormatStore.Verbose.COMPACT);
            }
            case RDFXML: {
                return new RdfStore();
            }
            case TAG: {
                return new TagValueStore((IModelStore)new InMemSpdxStore());
            }
            case XLS: {
                return new SpreadsheetStore((IModelStore)new InMemSpdxStore(), SpreadsheetStore.SpreadsheetFormatType.XLS);
            }
            case XLSX: {
                return new SpreadsheetStore((IModelStore)new InMemSpdxStore(), SpreadsheetStore.SpreadsheetFormatType.XLSX);
            }
            case XML: {
                return new MultiFormatStore((IModelStore)new InMemSpdxStore(), MultiFormatStore.Format.XML, MultiFormatStore.Verbose.COMPACT);
            }
            case YAML: {
                return new MultiFormatStore((IModelStore)new InMemSpdxStore(), MultiFormatStore.Format.YAML, MultiFormatStore.Verbose.COMPACT);
            }
        }
        throw new InvalidSPDXAnalysisException("Unsupported file type: " + (Object)((Object)fileType) + ".  Check back later.");
    }

    public static SerFileType fileToFileType(File file) throws InvalidFileNameException {
        SerFileType retval;
        String fileName = file.getName();
        if (!fileName.contains(".")) {
            throw new InvalidFileNameException("Can not convert file to file type - no file extension");
        }
        String ext = fileName.substring(fileName.lastIndexOf(".") + 1).toLowerCase();
        if ("xml".equals(ext) && fileName.endsWith("rdf.xml")) {
            ext = "rdf.xml";
        }
        if (Objects.isNull((Object)(retval = EXT_TO_FILETYPE.get(ext)))) {
            throw new InvalidFileNameException("Unrecognized file extension: " + ext);
        }
        return retval;
    }

    public static SerFileType strToFileType(String str) {
        String strFileType = str.toUpperCase().trim();
        return SerFileType.valueOf(strFileType);
    }

    public static SpdxDocument deserializeDocument(File file) throws InvalidSPDXAnalysisException, IOException, InvalidFileNameException {
        ISerializableModelStore store = SpdxToolsHelper.fileTypeToStore(SpdxToolsHelper.fileToFileType(file));
        try (FileInputStream is = new FileInputStream(file);){
            String documentUri = store.deSerialize((InputStream)is, false);
            SpdxDocument spdxDocument = new SpdxDocument((IModelStore)store, documentUri, null, false);
            return spdxDocument;
        }
    }

    public static SpdxDocument deserializeDocument(File file, SerFileType fileType) throws InvalidSPDXAnalysisException, IOException {
        ISerializableModelStore store = SpdxToolsHelper.fileTypeToStore(fileType);
        try (FileInputStream is = new FileInputStream(file);){
            String documentUri = store.deSerialize((InputStream)is, false);
            SpdxDocument spdxDocument = new SpdxDocument((IModelStore)store, documentUri, null, false);
            return spdxDocument;
        }
    }

    static {
        HashMap<String, SerFileType> temp = new HashMap<String, SerFileType>();
        temp.put("json", SerFileType.JSON);
        temp.put("rdf.xml", SerFileType.RDFXML);
        temp.put("rdf", SerFileType.RDFXML);
        temp.put("xml", SerFileType.XML);
        temp.put("xls", SerFileType.XLS);
        temp.put("xlsx", SerFileType.XLSX);
        temp.put("yaml", SerFileType.YAML);
        temp.put("tag", SerFileType.TAG);
        temp.put("spdx", SerFileType.TAG);
        temp.put("yml", SerFileType.YAML);
        EXT_TO_FILETYPE = Collections.unmodifiableMap(temp);
    }

    public static enum SerFileType {
        JSON,
        RDFXML,
        XML,
        XLS,
        XLSX,
        YAML,
        TAG;

    }
}

