/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.tools.compare;

import java.util.Optional;
import org.apache.poi.ss.usermodel.Workbook;
import org.spdx.library.InvalidSPDXAnalysisException;
import org.spdx.library.model.SpdxFile;
import org.spdx.tools.compare.AbstractFileCompareSheet;
import org.spdx.utility.compare.SpdxCompareException;
import org.spdx.utility.compare.SpdxComparer;

public class FileCommentSheet
extends AbstractFileCompareSheet {
    private static final int FILE_COMMENT_COL_WIDTH = 60;

    public FileCommentSheet(Workbook workbook, String sheetName) {
        super(workbook, sheetName);
    }

    static void create(Workbook wb, String sheetName) {
        AbstractFileCompareSheet.create(wb, sheetName, 60);
    }

    @Override
    String getFileValue(SpdxFile spdxFile) throws InvalidSPDXAnalysisException {
        Optional comment = spdxFile.getComment();
        if (!comment.isPresent()) {
            return "";
        }
        return (String)comment.get();
    }

    @Override
    boolean valuesMatch(SpdxComparer comparer, SpdxFile fileA, int docIndexA, SpdxFile fileB, int docIndexB) throws SpdxCompareException, InvalidSPDXAnalysisException {
        return SpdxComparer.stringsEqual((Optional)fileA.getComment(), (Optional)fileB.getComment());
    }
}

